/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AttributesConfig;
import com.newrelic.agent.config.AttributesConfigImpl;
import com.newrelic.agent.config.AuditModeConfig;
import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.BrowserMonitoringConfig;
import com.newrelic.agent.config.BrowserMonitoringConfigImpl;
import com.newrelic.agent.config.CircuitBreakerConfig;
import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.config.ClassTransformerConfigImpl;
import com.newrelic.agent.config.CommandParserConfig;
import com.newrelic.agent.config.CommandParserConfigImpl;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.config.CrossProcessConfig;
import com.newrelic.agent.config.CrossProcessConfigImpl;
import com.newrelic.agent.config.DatastoreConfig;
import com.newrelic.agent.config.DatastoreConfigImpl;
import com.newrelic.agent.config.DeprecatedProperty;
import com.newrelic.agent.config.DistributedTracingConfig;
import com.newrelic.agent.config.ErrorCollectorConfig;
import com.newrelic.agent.config.ErrorCollectorConfigImpl;
import com.newrelic.agent.config.ExtensionsConfig;
import com.newrelic.agent.config.ExtensionsConfigImpl;
import com.newrelic.agent.config.ExternalTracerConfig;
import com.newrelic.agent.config.ExternalTracerConfigImpl;
import com.newrelic.agent.config.IBMUtils;
import com.newrelic.agent.config.InfiniteTracingConfig;
import com.newrelic.agent.config.InfiniteTracingConfigImpl;
import com.newrelic.agent.config.InsightsConfig;
import com.newrelic.agent.config.InsightsConfigImpl;
import com.newrelic.agent.config.JarCollectorConfig;
import com.newrelic.agent.config.JarCollectorConfigImpl;
import com.newrelic.agent.config.JfrConfig;
import com.newrelic.agent.config.JfrConfigImpl;
import com.newrelic.agent.config.JmxConfig;
import com.newrelic.agent.config.JmxConfigImpl;
import com.newrelic.agent.config.KeyTransactionConfig;
import com.newrelic.agent.config.KeyTransactionConfigImpl;
import com.newrelic.agent.config.LabelsConfig;
import com.newrelic.agent.config.LabelsConfigImpl;
import com.newrelic.agent.config.NormalizationRuleConfig;
import com.newrelic.agent.config.OpenTracingConfig;
import com.newrelic.agent.config.ReinstrumentConfig;
import com.newrelic.agent.config.ReinstrumentConfigImpl;
import com.newrelic.agent.config.ServerProp;
import com.newrelic.agent.config.SpanEventsConfig;
import com.newrelic.agent.config.SqlTraceConfig;
import com.newrelic.agent.config.SqlTraceConfigImpl;
import com.newrelic.agent.config.StripExceptionConfig;
import com.newrelic.agent.config.StripExceptionConfigImpl;
import com.newrelic.agent.config.SystemPropertyFactory;
import com.newrelic.agent.config.ThreadProfilerConfig;
import com.newrelic.agent.config.ThreadProfilerConfigImpl;
import com.newrelic.agent.config.TransactionEventsConfig;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.config.TransactionTracerConfigImpl;
import com.newrelic.agent.config.UtilizationDataConfig;
import com.newrelic.agent.deps.com.google.common.base.Joiner;
import com.newrelic.agent.transaction.TransactionNamingScheme;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class AgentConfigImpl
extends BaseConfig
implements AgentConfig {
    public static final String AGENT_ENABLED = "agent_enabled";
    public static final String APDEX_T = "apdex_t";
    public static final String API_HOST = "api_host";
    public static final String API_PORT = "api_port";
    public static final String APP_NAME = "app_name";
    public static final String ASYNC_TIMEOUT = "async_timeout";
    public static final String CA_BUNDLE_PATH = "ca_bundle_path";
    public static final String COMPRESSED_CONTENT_ENCODING_PROPERTY = "compressed_content_encoding";
    public static final String CPU_SAMPLING_ENABLED = "cpu_sampling_enabled";
    public static final String ENABLED = "enabled";
    public static final String ENABLE_AUTO_APP_NAMING = "enable_auto_app_naming";
    public static final String ENABLE_AUTO_TRANSACTION_NAMING = "enable_auto_transaction_naming";
    public static final String ENABLE_BOOTSTRAP_CLASS_INSTRUMENTATION = "enable_bootstrap_class_instrumentation";
    public static final String ENABLE_CLASS_RETRANSFORMATION = "enable_class_retransformation";
    public static final String ENABLE_CUSTOM_TRACING = "enable_custom_tracing";
    public static final String EXT_CONFIG_DIR = "extensions.dir";
    public static final String HIGH_SECURITY = "high_security";
    public static final String HOST = "host";
    public static final String IBM_WORKAROUND = "ibm_iv25688_workaround";
    public static final String IGNORE_JARS = "ignore_jars";
    public static final String INSERT_API_KEY = "insert_api_key";
    public static final String JDBC_SUPPORT = "jdbc_support";
    public static final String LABELS = "labels";
    public static final String LANGUAGE = "language";
    public static final String LICENSE_KEY = "license_key";
    public static final String LITE_MODE = "lite_mode";
    public static final String LOG_DAILY = "log_daily";
    public static final String LOG_FILE_COUNT = "log_file_count";
    public static final String LOG_FILE_NAME = "log_file_name";
    public static final String LOG_FILE_PATH = "log_file_path";
    public static final String LOG_LEVEL = "log_level";
    public static final String LOG_LIMIT = "log_limit_in_kbytes";
    public static final String MAX_STACK_TRACE_LINES = "max_stack_trace_lines";
    public static final String METRIC_INGEST_URI = "metric_ingest_uri";
    public static final String EVENT_INGEST_URI = "event_ingest_uri";
    public static final String DEBUG = "newrelic.debug";
    public static final String PLATFORM_INFORMATION_ENABLED = "platform_information_enabled";
    public static final String PORT = "port";
    public static final String PROXY_HOST = "proxy_host";
    public static final String PROXY_PASS = "proxy_password";
    public static final String PROXY_PORT = "proxy_port";
    public static final String PROXY_SCHEME = "proxy_scheme";
    public static final String PROXY_USER = "proxy_user";
    public static final String PUT_FOR_DATA_SEND_PROPERTY = "put_for_data_send";
    public static final String REPORT_SQL_PARSER_ERRORS = "report_sql_parser_errors";
    public static final String LASP_TOKEN = "security_policies_token";
    public static final String SEND_DATA_ON_EXIT = "send_data_on_exit";
    public static final String SEND_DATA_ON_EXIT_THRESHOLD = "send_data_on_exit_threshold";
    public static final String SEND_ENVIRONMENT_INFO = "send_environment_info";
    public static final String SEND_JVM_PROPS = "send_jvm_props";
    public static final String SIMPLE_COMPRESSION_PROPERTY = "simple_compression";
    private static final String REQUEST_TIMEOUT_IN_SECONDS_PROPERTY = "timeout";
    public static final String STARTUP_LOG_LEVEL = "startup_log_level";
    public static final String STARTUP_TIMING = "startup_timing";
    public static final String STDOUT = "STDOUT";
    public static final String SYNC_STARTUP = "sync_startup";
    public static final String THREAD_CPU_TIME_ENABLED = "thread_cpu_time_enabled";
    public static final String TRACE_DATA_CALLS = "trace_data_calls";
    public static final String TRANSACTION_NAMING_SCHEME = "transaction_naming_scheme";
    public static final String TRANSACTION_SIZE_LIMIT = "transaction_size_limit";
    public static final String TRIM_STATS = "trim_stats";
    public static final String USE_PRIVATE_SSL = "use_private_ssl";
    public static final String WAIT_FOR_RPM_CONNECT = "wait_for_rpm_connect";
    public static final String WAIT_FOR_TRANSACTIONS = "wait_for_transactions";
    public static final String KEY_TRANSACTIONS = "web_transactions_apdex";
    public static final String ATTRIBUTES = "attributes";
    public static final String BROWSER_MONITORING = "browser_monitoring";
    public static final String CLASS_TRANSFORMER = "class_transformer";
    public static final String CROSS_APPLICATION_TRACER = "cross_application_tracer";
    public static final String CUSTOM_INSIGHT_EVENTS = "custom_insights_events";
    public static final String DATASTORE_TRACER = "datastore_tracer";
    public static final String DISTRIBUTED_TRACING = "distributed_tracing";
    public static final String ERROR_COLLECTOR = "error_collector";
    public static final String EXTENSIONS = "extensions";
    public static final String INSTRUMENTATION = "instrumentation";
    public static final String JAR_COLLECTOR = "jar_collector";
    public static final String JMX = "jmx";
    public static final String JFR = "jfr";
    public static final String OPEN_TRACING = "open_tracing";
    public static final String REINSTRUMENT = "reinstrument";
    public static final String SLOW_SQL = "slow_sql";
    public static final String SPAN_EVENTS = "span_events";
    public static final String STRIP_EXCEPTION_MESSAGES = "strip_exception_messages";
    public static final String THREAD_PROFILER = "thread_profiler";
    public static final String TRANSACTION_EVENTS = "transaction_events";
    public static final String TRANSACTION_SEGMENTS = "transaction_segments";
    public static final String TRANSACTION_TRACER = "transaction_tracer";
    public static final double DEFAULT_APDEX_T = 1.0;
    public static final String DEFAULT_API_HOST = "rpm.newrelic.com";
    public static final String DEFAULT_CA_BUNDLE_PATH = null;
    public static final String DEFAULT_COMPRESSED_CONTENT_ENCODING = "gzip";
    public static final boolean DEFAULT_CPU_SAMPLING_ENABLED = true;
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_ENABLE_AUTO_APP_NAMING = false;
    public static final boolean DEFAULT_ENABLE_AUTO_TRANSACTION_NAMING = true;
    public static final boolean DEFAULT_ENABLE_CUSTOM_TRACING = true;
    public static final boolean DEFAULT_HIGH_SECURITY = false;
    public static final String DEFAULT_HOST = "collector.newrelic.com";
    public static final boolean DEFAULT_IBM_WORKAROUND = IBMUtils.getIbmWorkaroundDefault();
    public static final String DEFAULT_INSERT_API_KEY = "";
    public static final String GENERIC_JDBC_SUPPORT = "generic";
    public static final String DEFAULT_JDBC_SUPPORT = "generic";
    public static final String DEFAULT_LANGUAGE = "java";
    public static final boolean DEFAULT_LOG_DAILY = false;
    public static final int DEFAULT_LOG_FILE_COUNT = 1;
    public static final String DEFAULT_LOG_FILE_NAME = "newrelic_agent.log";
    public static final String DEFAULT_LOG_LEVEL = "info";
    public static final int DEFAULT_LOG_LIMIT = 0;
    public static final int DEFAULT_MAX_STACK_TRACE_LINES = 30;
    public static final String DEFAULT_METRIC_INGEST_URI = "https://metric-api.newrelic.com/metric/v1";
    public static final String DEFAULT_EVENT_INGEST_URI = "https://insights-collector.newrelic.com/v1/accounts/events";
    public static final String EU_METRIC_INGEST_URI = "https://metric-api.eu.newrelic.com/metric/v1";
    public static final String EU_EVENT_INGEST_URI = "https://insights-collector.eu01.nr-data.net/v1/accounts/events";
    public static final boolean DEFAULT_PLATFORM_INFORMATION_ENABLED = true;
    public static final int DEFAULT_PORT = 80;
    public static final String DEFAULT_PROXY_HOST = null;
    public static final int DEFAULT_PROXY_PORT = 8080;
    public static final String DEFAULT_PROXY_SCHEME = null;
    public static final boolean DEFAULT_PUT_FOR_DATA_SEND_ENABLED = false;
    public static final String DEFAULT_SECURITY_POLICIES_TOKEN = "";
    public static final boolean DEFAULT_SEND_DATA_ON_EXIT = false;
    public static final int DEFAULT_SEND_DATA_ON_EXIT_THRESHOLD = 60;
    public static final boolean DEFAULT_SEND_ENVIRONMENT_INFO = true;
    public static final boolean DEFAULT_SIMPLE_COMPRESSION_ENABLED = false;
    public static final int DEFAULT_SSL_PORT = 443;
    public static final boolean DEFAULT_STARTUP_TIMING = true;
    public static final boolean DEFAULT_SYNC_STARTUP = false;
    public static final boolean DEFAULT_TRACE_DATA_CALLS = false;
    public static final int DEFAULT_TRANSACTION_SIZE_LIMIT = 2000;
    public static final boolean DEFAULT_TRIM_STATS = true;
    public static final boolean DEFAULT_WAIT_FOR_RPM_CONNECT = true;
    public static final int DEFAULT_WAIT_FOR_TRANSACTIONS = 0;
    private static final int DEFAULT_REQUEST_TIMEOUT_IN_SECONDS = 120;
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.";
    public static final Pattern REGION_AWARE = Pattern.compile("^.+?x");
    private final long apdexTInMillis;
    private final String appName;
    private final List<String> appNames;
    private final boolean autoAppNamingEnabled;
    private final boolean autoTransactionNamingEnabled;
    private final String caBundlePath;
    private final String compressedContentEncoding;
    private final boolean cpuSamplingEnabled;
    private final boolean customInstrumentationEditorAllowed;
    private final boolean customParameters;
    private final boolean debug;
    private final boolean enabled;
    private final boolean genericJdbcSupportEnabled;
    private final boolean highSecurity = this.getProperty("high_security", false);
    private final String host;
    private final boolean ibmWorkaroundEnabled;
    private final List<String> ignoreJars;
    private final String insertApiKey;
    private final boolean isApdexTSet;
    private final HashSet<String> jdbcSupport;
    private final String licenseKey;
    private final boolean litemode;
    private final boolean logDaily;
    private final String logLevel;
    private final int maxStackTraceLines;
    private final String metricIngestUri;
    private final String eventIngestUri;
    private final boolean platformInformationEnabled;
    private final int port;
    private final String proxyHost;
    private final String proxyPass;
    private final Integer proxyPort;
    private final String proxyScheme;
    private final String proxyUser;
    private final boolean putForDataSend;
    private final int segmentTimeoutInSec;
    private final String securityPoliciesToken = this.getProperty("security_policies_token", "");
    private final boolean sendJvmProps;
    private final boolean simpleCompression = this.getProperty("simple_compression", false);
    private final boolean startupTimingEnabled;
    private final int tokenTimeoutInSec;
    private final TransactionNamingScheme transactionNamingMode;
    private final int transactionSizeLimit;
    private final boolean trimStats;
    private final boolean waitForRPMConnect;
    private final int waitForTransactionsInMillis;
    private final int requestTimeoutInMillis;
    private final AttributesConfig attributesConfig;
    private final AuditModeConfig auditModeConfig;
    private final TransactionTracerConfigImpl backgroundTransactionTracerConfig;
    private final BrowserMonitoringConfig browserMonitoringConfig;
    private final ClassTransformerConfig classTransformerConfig;
    private final CircuitBreakerConfig circuitBreakerConfig;
    private final CrossProcessConfig crossProcessConfig;
    private final DatastoreConfig datastoreConfig;
    private final DistributedTracingConfig distributedTracingConfig;
    private final ErrorCollectorConfig errorCollectorConfig;
    private final ExtensionsConfig extensionsConfig;
    private final ExternalTracerConfig externalTracerConfig;
    private final InfiniteTracingConfig infiniteTracingConfig;
    private final InsightsConfig insightsConfig;
    private final Config instrumentationConfig;
    private final JarCollectorConfig jarCollectorConfig;
    private final JfrConfig jfrConfig;
    private final JmxConfig jmxConfig;
    private final KeyTransactionConfig keyTransactionConfig;
    private final LabelsConfig labelsConfig;
    private final NormalizationRuleConfig normalizationRuleConfig;
    private final OpenTracingConfig openTracingConfig;
    private final ReinstrumentConfig reinstrumentConfig;
    private final TransactionTracerConfigImpl requestTransactionTracerConfig;
    private final SpanEventsConfig spanEventsConfig;
    private final SqlTraceConfig sqlTraceConfig;
    private final StripExceptionConfig stripExceptionConfig;
    private final ThreadProfilerConfig threadProfilerConfig;
    private final TransactionEventsConfig transactionEventsConfig;
    private final TransactionTracerConfigImpl transactionTracerConfig;
    private final UtilizationDataConfig utilizationConfig;
    private final Map<String, Object> flattenedProperties;
    private final CommandParserConfig commandParserConfig;

    public static AgentConfig createAgentConfig(Map<String, Object> settings) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new AgentConfigImpl(settings);
    }

    private AgentConfigImpl(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
        this.compressedContentEncoding = this.initCompressedContentEncoding();
        this.putForDataSend = this.getProperty(PUT_FOR_DATA_SEND_PROPERTY, false);
        this.isApdexTSet = this.getProperty(APDEX_T) != null;
        this.apdexTInMillis = (long)(this.getDoubleProperty(APDEX_T, 1.0) * 1000.0);
        this.debug = Boolean.getBoolean(DEBUG);
        this.enabled = this.getProperty(ENABLED, true) != false && this.getProperty(AGENT_ENABLED, true) != false;
        this.licenseKey = (String)this.getProperty(LICENSE_KEY);
        String region = this.parseRegion(this.licenseKey);
        this.host = this.parseHost(region);
        this.metricIngestUri = this.parseMetricIngestUri(region);
        this.eventIngestUri = this.parseEventIngestUri(region);
        this.ignoreJars = new ArrayList<String>(this.getUniqueStrings(IGNORE_JARS, ","));
        this.insertApiKey = this.getProperty(INSERT_API_KEY, "");
        this.logLevel = this.initLogLevel();
        this.logDaily = this.getProperty(LOG_DAILY, false);
        this.port = this.getIntProperty(PORT, 443);
        this.proxyHost = this.getProperty(PROXY_HOST, DEFAULT_PROXY_HOST);
        this.proxyPort = this.getIntProperty(PROXY_PORT, 8080);
        this.proxyScheme = this.getProperty(PROXY_SCHEME, DEFAULT_PROXY_SCHEME);
        this.proxyUser = this.getStringPropertyOrNull(PROXY_USER);
        this.proxyPass = this.getStringPropertyOrNull(PROXY_PASS);
        this.appNames = new ArrayList<String>(this.getUniqueStrings(APP_NAME, ";"));
        this.appName = this.getPrimaryAppName();
        this.cpuSamplingEnabled = this.getProperty(CPU_SAMPLING_ENABLED, true);
        this.autoAppNamingEnabled = this.getProperty(ENABLE_AUTO_APP_NAMING, false);
        this.autoTransactionNamingEnabled = this.getProperty(ENABLE_AUTO_TRANSACTION_NAMING, true);
        this.transactionSizeLimit = this.getIntProperty(TRANSACTION_SIZE_LIMIT, 2000) * 1024;
        this.waitForRPMConnect = this.getProperty(WAIT_FOR_RPM_CONNECT, true);
        this.startupTimingEnabled = this.getProperty(STARTUP_TIMING, true);
        this.sendJvmProps = this.getProperty(SEND_JVM_PROPS, true);
        this.litemode = this.getProperty(LITE_MODE, false);
        this.caBundlePath = this.initSSLConfig();
        this.trimStats = this.getProperty(TRIM_STATS, true);
        this.platformInformationEnabled = this.getProperty(PLATFORM_INFORMATION_ENABLED, true);
        this.ibmWorkaroundEnabled = this.getProperty(IBM_WORKAROUND, DEFAULT_IBM_WORKAROUND);
        this.transactionNamingMode = this.parseTransactionNamingMode();
        this.maxStackTraceLines = this.getProperty(MAX_STACK_TRACE_LINES, 30);
        String[] jdbcSupport = this.getProperty(JDBC_SUPPORT, "generic").split(",");
        this.jdbcSupport = new HashSet<String>(Arrays.asList(jdbcSupport));
        this.genericJdbcSupportEnabled = this.jdbcSupport.contains("generic");
        this.requestTimeoutInMillis = this.getProperty(REQUEST_TIMEOUT_IN_SECONDS_PROPERTY, 120) * 1000;
        this.instrumentationConfig = new BaseConfig(this.nestedProps(INSTRUMENTATION), "newrelic.config.instrumentation");
        this.transactionTracerConfig = this.initTransactionTracerConfig(this.apdexTInMillis, this.highSecurity);
        this.requestTransactionTracerConfig = this.transactionTracerConfig.createRequestTransactionTracerConfig(this.apdexTInMillis, this.highSecurity);
        this.backgroundTransactionTracerConfig = this.transactionTracerConfig.createBackgroundTransactionTracerConfig(this.apdexTInMillis, this.highSecurity);
        this.errorCollectorConfig = this.initErrorCollectorConfig();
        this.extensionsConfig = this.initExtensionsConfig();
        this.threadProfilerConfig = this.initThreadProfilerConfig();
        this.keyTransactionConfig = this.initKeyTransactionConfig(this.apdexTInMillis);
        this.sqlTraceConfig = this.initSqlTraceConfig();
        this.auditModeConfig = this.initAuditModeConfig();
        this.browserMonitoringConfig = this.initBrowserMonitoringConfig();
        this.classTransformerConfig = this.initClassTransformerConfig(this.litemode);
        this.crossProcessConfig = this.initCrossProcessConfig();
        this.stripExceptionConfig = this.initStripExceptionConfig(this.highSecurity);
        this.labelsConfig = new LabelsConfigImpl(this.getProperty(LABELS));
        this.utilizationConfig = this.initUtilizationConfig();
        this.datastoreConfig = this.initDatastoreConfig();
        this.externalTracerConfig = this.initExternalTracerConfig();
        this.jfrConfig = this.initJfrConfig();
        this.jmxConfig = this.initJmxConfig();
        this.jarCollectorConfig = this.initJarCollectorConfig();
        this.insightsConfig = this.initInsightsConfig();
        this.infiniteTracingConfig = this.initInfiniteTracingConfig(this.autoAppNamingEnabled);
        this.attributesConfig = this.initAttributesConfig();
        this.reinstrumentConfig = this.initReinstrumentConfig();
        this.circuitBreakerConfig = this.initCircuitBreakerConfig();
        this.segmentTimeoutInSec = this.initSegmentTimeout();
        this.tokenTimeoutInSec = this.initTokenTimeout();
        this.openTracingConfig = this.initOpenTracingConfig();
        this.distributedTracingConfig = this.initDistributedTracing();
        this.spanEventsConfig = this.initSpanEventsConfig(this.distributedTracingConfig.isEnabled());
        this.transactionEventsConfig = this.initTransactionEvents();
        this.commandParserConfig = this.initCommandParserConfig();
        this.normalizationRuleConfig = new NormalizationRuleConfig(props);
        HashMap<String, Object> flattenedProps = new HashMap<String, Object>();
        this.flatten("", props, flattenedProps);
        HashMap<String, Object> propsWithSystemProps = new HashMap<String, Object>();
        propsWithSystemProps.putAll(SystemPropertyFactory.getSystemPropertyProvider().getNewRelicPropertiesWithoutPrefix());
        propsWithSystemProps.putAll(SystemPropertyFactory.getSystemPropertyProvider().getNewRelicEnvVarsWithoutPrefix());
        this.flatten("", propsWithSystemProps, flattenedProps);
        this.checkHighSecurityPropsInFlattened(flattenedProps);
        this.flattenedProperties = Collections.unmodifiableMap(flattenedProps);
        this.waitForTransactionsInMillis = this.getProperty(WAIT_FOR_TRANSACTIONS, 0);
        this.customInstrumentationEditorAllowed = this.getProperty("custom_instrumentation_editor", !this.highSecurity);
        this.customParameters = this.getProperty("custom_parameters", !this.highSecurity);
        if (this.getProperty(REPORT_SQL_PARSER_ERRORS) != null) {
            AgentConfigImpl.addDeprecatedProperty(new String[]{REPORT_SQL_PARSER_ERRORS}, null);
        }
    }

    private String initSSLConfig() {
        String caBundlePath = this.getProperty(CA_BUNDLE_PATH, DEFAULT_CA_BUNDLE_PATH);
        if (this.getProperty(USE_PRIVATE_SSL) != null) {
            if (caBundlePath != null) {
                Agent.LOG.log(Level.INFO, "use_private_ssl configuration setting has been removed.");
            } else {
                Agent.LOG.log(Level.SEVERE, "The use_private_ssl configuration setting has been removed and will be ignored. The agent will use the JVM/JRE truststore by default unless you configure ca_bundle_path to use a different truststore.");
            }
        }
        return caBundlePath;
    }

    private String parseRegion(String licenseKey) {
        if (licenseKey != null && REGION_AWARE.matcher(licenseKey = licenseKey.toLowerCase()).find()) {
            return licenseKey.substring(0, licenseKey.indexOf("x"));
        }
        return "";
    }

    private String parseHost(String region) {
        String host = (String)this.getProperty(HOST);
        if (host != null) {
            Agent.LOG.log(Level.INFO, "Using configured collector host: {0}", host);
            return host;
        }
        if (region.isEmpty()) {
            Agent.LOG.log(Level.INFO, "Using default collector host: {0}", DEFAULT_HOST);
            return DEFAULT_HOST;
        }
        host = "collector." + region + ".nr-data.net";
        Agent.LOG.log(Level.INFO, "Using region aware collector host: {0}", host);
        return host;
    }

    private String parseMetricIngestUri(String region) {
        String metricIngestUri = (String)this.getProperty(METRIC_INGEST_URI);
        if (metricIngestUri != null) {
            Agent.LOG.log(Level.INFO, "Using configured metric ingest URI: {0}", metricIngestUri);
            return metricIngestUri;
        }
        if (region.isEmpty()) {
            Agent.LOG.log(Level.INFO, "Using default metric ingest URI: {0}", DEFAULT_METRIC_INGEST_URI);
            return DEFAULT_METRIC_INGEST_URI;
        }
        if (region.toLowerCase().contains("eu")) {
            Agent.LOG.log(Level.INFO, "Using region aware metric ingest URI: {0}", EU_METRIC_INGEST_URI);
            return EU_METRIC_INGEST_URI;
        }
        Agent.LOG.log(Level.INFO, "Unrecognized region parsed from license_key, please explicitly set the {0} property. Currently using default metric ingest URI: {1}", METRIC_INGEST_URI, DEFAULT_METRIC_INGEST_URI);
        return DEFAULT_METRIC_INGEST_URI;
    }

    private String parseEventIngestUri(String region) {
        String eventIngestUri = (String)this.getProperty(EVENT_INGEST_URI);
        if (eventIngestUri != null) {
            Agent.LOG.log(Level.INFO, "Using configured event ingest URI: {0}", eventIngestUri);
            return eventIngestUri;
        }
        if (region.isEmpty()) {
            Agent.LOG.log(Level.INFO, "Using default event ingest URI: {0}", DEFAULT_EVENT_INGEST_URI);
            return DEFAULT_EVENT_INGEST_URI;
        }
        if (region.toLowerCase().contains("eu")) {
            Agent.LOG.log(Level.INFO, "Using region aware event ingest URI: {0}", EU_EVENT_INGEST_URI);
            return EU_EVENT_INGEST_URI;
        }
        Agent.LOG.log(Level.INFO, "Unrecognized region parsed from license_key, please explicitly set the {0} property. Currently using default event ingest URI: {1}", EVENT_INGEST_URI, DEFAULT_EVENT_INGEST_URI);
        return DEFAULT_EVENT_INGEST_URI;
    }

    private OpenTracingConfig initOpenTracingConfig() {
        Map<String, Object> openTracing = this.nestedProps(OPEN_TRACING);
        return new OpenTracingConfig(openTracing);
    }

    private DistributedTracingConfig initDistributedTracing() {
        Map<String, Object> distributedTracing = this.nestedProps(DISTRIBUTED_TRACING);
        return new DistributedTracingConfig(distributedTracing);
    }

    private SpanEventsConfig initSpanEventsConfig(boolean dtEnabled) {
        Map<String, Object> spanEvents = this.nestedProps(SPAN_EVENTS);
        return new SpanEventsConfig(spanEvents, dtEnabled);
    }

    private int initTokenTimeout() {
        if (this.getProperty(ASYNC_TIMEOUT) != null) {
            Agent.LOG.log(Level.INFO, "The property async_timeout is deprecated. Change to token_timeout");
            return this.getProperty(ASYNC_TIMEOUT, 180);
        }
        return this.getProperty("token_timeout", 180);
    }

    private int initSegmentTimeout() {
        if (this.getProperty("traced_activity_timeout") != null) {
            Agent.LOG.log(Level.INFO, "The property traced_activity_timeout is deprecated. Change to segment_timeout");
            return this.getProperty("traced_activity_timeout", 600);
        }
        return this.getProperty("segment_timeout", 600);
    }

    private TransactionNamingScheme parseTransactionNamingMode() {
        TransactionNamingScheme mode = TransactionNamingScheme.LEGACY;
        String mode_name = this.getProperty(TRANSACTION_NAMING_SCHEME, "legacy");
        if (mode_name.equals("resource_based")) {
            mode = TransactionNamingScheme.RESOURCE_BASED;
        }
        return mode;
    }

    private void checkHighSecurityPropsInFlattened(Map<String, Object> flattenedProps) {
        if (this.highSecurity && !flattenedProps.isEmpty()) {
            flattenedProps.put("transaction_tracer.record_sql", this.transactionTracerConfig.getRecordSql());
        }
    }

    private void flatten(String prefix, Map<String, Object> source2, Map<String, Object> dest) {
        for (Map.Entry<String, Object> e : source2.entrySet()) {
            if (e.getValue() instanceof Map) {
                this.flatten(prefix + e.getKey() + '.', (Map)e.getValue(), dest);
                continue;
            }
            Object destinationValue = dest.get(prefix + e.getKey());
            if (destinationValue instanceof ServerProp) continue;
            dest.put(prefix + e.getKey(), e.getValue());
        }
    }

    public <T> T getValue(String path) {
        return this.getValue(path, null);
    }

    public <T> T getValue(String path, T defaultValue) {
        Object value = this.flattenedProperties.get(path.replaceAll("[.-]", "_"));
        if (value == null) {
            value = this.flattenedProperties.get(path);
        }
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof ServerProp) {
            value = ((ServerProp)value).getValue();
            return this.castValue(path, value, defaultValue);
        }
        if (value instanceof String && defaultValue instanceof Boolean) {
            value = Boolean.valueOf((String)value);
            return (T)value;
        }
        if (value instanceof String && defaultValue instanceof Integer) {
            value = Integer.valueOf((String)value);
            return (T)value;
        }
        try {
            return (T)value;
        }
        catch (ClassCastException ccx) {
            Agent.LOG.log(Level.FINE, "Using default value \"{0}\" for \"{1}\"", defaultValue, path);
            return defaultValue;
        }
    }

    private String initLogLevel() {
        String val = this.getProperty(LOG_LEVEL, DEFAULT_LOG_LEVEL);
        if (val instanceof Boolean) {
            return "off";
        }
        return this.getProperty(LOG_LEVEL, DEFAULT_LOG_LEVEL).toLowerCase();
    }

    private String getPrimaryAppName() {
        Collection values2;
        Iterator iterator2;
        Object val = this.getProperty(APP_NAME);
        if (val instanceof String) {
            String[] values3 = ((String)val).split(";");
            if (values3.length == 0) {
                return null;
            }
            String res = values3[0].trim();
            if (res.length() == 0) {
                return null;
            }
            return res;
        }
        if (val instanceof Collection && (iterator2 = (values2 = (Collection)val).iterator()).hasNext()) {
            Object value = iterator2.next();
            String res = (String)value;
            if ((res = res.trim()).length() != 0) {
                return res;
            }
            return null;
        }
        return null;
    }

    private CrossProcessConfig initCrossProcessConfig() {
        Boolean prop = (Boolean)this.getProperty("cross_application_tracing");
        Map<String, Object> props = this.nestedProps(CROSS_APPLICATION_TRACER);
        if (prop != null) {
            if (props == null) {
                props = new HashMap<String, Object>();
            }
            props.put("cross_application_tracing", prop);
        }
        return CrossProcessConfigImpl.createCrossProcessConfig(props);
    }

    private StripExceptionConfig initStripExceptionConfig(boolean highSecurity) {
        Map<String, Object> props = this.nestedProps(STRIP_EXCEPTION_MESSAGES);
        return StripExceptionConfigImpl.createStripExceptionConfig(props, highSecurity);
    }

    private ThreadProfilerConfig initThreadProfilerConfig() {
        Map<String, Object> props = this.nestedProps(THREAD_PROFILER);
        return ThreadProfilerConfigImpl.createThreadProfilerConfig(props);
    }

    private KeyTransactionConfig initKeyTransactionConfig(long apdexTInMillis) {
        Map<String, Object> props = this.nestedProps(KEY_TRANSACTIONS);
        return KeyTransactionConfigImpl.createKeyTransactionConfig(props, apdexTInMillis);
    }

    private TransactionTracerConfigImpl initTransactionTracerConfig(long apdexTInMillis, boolean highSecurity) {
        Map<String, Object> props = this.nestedProps(TRANSACTION_TRACER);
        return TransactionTracerConfigImpl.createTransactionTracerConfig(props, apdexTInMillis, highSecurity);
    }

    private ErrorCollectorConfig initErrorCollectorConfig() {
        Map<String, Object> props = this.nestedProps(ERROR_COLLECTOR);
        return ErrorCollectorConfigImpl.createErrorCollectorConfig(props);
    }

    private ExtensionsConfig initExtensionsConfig() {
        Map<String, Object> props = this.nestedProps(EXTENSIONS);
        return ExtensionsConfigImpl.createExtensionsConfig(props);
    }

    private SqlTraceConfig initSqlTraceConfig() {
        Map<String, Object> props = this.nestedProps(SLOW_SQL);
        SqlTraceConfig sqlTraceConfig = SqlTraceConfigImpl.createSqlTraceConfig(props);
        if (sqlTraceConfig.isUsingLongerSqlId()) {
            Agent.LOG.info("Agent is configured to use longer sql id for sql traces");
        }
        return sqlTraceConfig;
    }

    private JfrConfig initJfrConfig() {
        Map<String, Object> props = this.nestedProps(JFR);
        return JfrConfigImpl.createJfrConfig(props);
    }

    private JmxConfig initJmxConfig() {
        Map<String, Object> props = this.nestedProps(JMX);
        return JmxConfigImpl.createJmxConfig(props);
    }

    private JarCollectorConfig initJarCollectorConfig() {
        Map<String, Object> props = this.nestedProps(JAR_COLLECTOR);
        return JarCollectorConfigImpl.createJarCollectorConfig(props);
    }

    private InsightsConfig initInsightsConfig() {
        Map<String, Object> props = this.nestedProps(CUSTOM_INSIGHT_EVENTS);
        return InsightsConfigImpl.createInsightsConfig(props, this.highSecurity);
    }

    private AttributesConfig initAttributesConfig() {
        Map<String, Object> props = this.nestedProps(ATTRIBUTES);
        return AttributesConfigImpl.createAttributesConfig(props);
    }

    private ReinstrumentConfig initReinstrumentConfig() {
        Map<String, Object> props = this.nestedProps(REINSTRUMENT);
        return ReinstrumentConfigImpl.createReinstrumentConfig(props);
    }

    private AuditModeConfig initAuditModeConfig() {
        Object auditMode = this.getProperty("audit_mode");
        if (auditMode instanceof Map) {
            Map<String, Object> props = this.nestedProps("audit_mode");
            return new AuditModeConfig(props);
        }
        boolean auditModeEnabled = this.getProperty("audit_mode", false);
        boolean traceDataCalls = this.getProperty(TRACE_DATA_CALLS, false);
        return new AuditModeConfig(auditModeEnabled, traceDataCalls);
    }

    private BrowserMonitoringConfig initBrowserMonitoringConfig() {
        Map<String, Object> props = this.nestedProps(BROWSER_MONITORING);
        return BrowserMonitoringConfigImpl.createBrowserMonitoringConfig(props);
    }

    private ClassTransformerConfig initClassTransformerConfig(boolean liteMode) {
        boolean customTracingEnabled = this.getProperty(ENABLE_CUSTOM_TRACING, true);
        Map<String, Object> props = this.nestedProps(CLASS_TRANSFORMER);
        return ClassTransformerConfigImpl.createClassTransformerConfig(props, customTracingEnabled, liteMode);
    }

    private CircuitBreakerConfig initCircuitBreakerConfig() {
        Map<String, Object> props = this.nestedProps("circuitbreaker");
        return new CircuitBreakerConfig(props);
    }

    private UtilizationDataConfig initUtilizationConfig() {
        Map<String, Object> props = this.nestedProps("utilization");
        return new UtilizationDataConfig(props);
    }

    private DatastoreConfig initDatastoreConfig() {
        Map<String, Object> props = this.nestedProps(DATASTORE_TRACER);
        return new DatastoreConfigImpl(props);
    }

    private ExternalTracerConfig initExternalTracerConfig() {
        Map<String, Object> props = this.nestedProps("external_tracer");
        return new ExternalTracerConfigImpl(props);
    }

    private InfiniteTracingConfig initInfiniteTracingConfig(boolean autoAppNamingEnabled) {
        Map<String, Object> props = this.nestedProps("infinite_tracing");
        return new InfiniteTracingConfigImpl(props, autoAppNamingEnabled);
    }

    private TransactionEventsConfig initTransactionEvents() {
        Map<String, Object> transactionEvents = this.nestedProps(TRANSACTION_EVENTS);
        return new TransactionEventsConfig(transactionEvents);
    }

    private String initCompressedContentEncoding() {
        if ("deflate".equals(this.getProperty(COMPRESSED_CONTENT_ENCODING_PROPERTY))) {
            return "deflate";
        }
        return DEFAULT_COMPRESSED_CONTENT_ENCODING;
    }

    private CommandParserConfig initCommandParserConfig() {
        return new CommandParserConfigImpl(this.nestedProps("command_parser"));
    }

    @Override
    public long getApdexTInMillis() {
        return this.apdexTInMillis;
    }

    @Override
    public long getApdexTInMillis(String transactionName) {
        return this.keyTransactionConfig.getApdexTInMillis(transactionName);
    }

    @Override
    public boolean isApdexTSet() {
        return this.isApdexTSet;
    }

    @Override
    public boolean isApdexTSet(String transactionName) {
        return this.keyTransactionConfig.isApdexTSet(transactionName);
    }

    @Override
    public boolean isAgentEnabled() {
        return this.enabled;
    }

    @Override
    public String getLicenseKey() {
        return this.licenseKey;
    }

    @Override
    public int getTimeoutInMilliseconds() {
        return this.requestTimeoutInMillis;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Override
    public String getProxyScheme() {
        return this.proxyScheme;
    }

    @Override
    public String getProxyUser() {
        return this.proxyUser;
    }

    @Override
    public String getProxyPassword() {
        return this.proxyPass;
    }

    @Override
    public String getApiHost() {
        return this.getProperty(API_HOST, DEFAULT_API_HOST);
    }

    @Override
    public int getApiPort() {
        return this.getProperty(API_PORT, 443);
    }

    @Override
    public String getInsertApiKey() {
        return this.insertApiKey;
    }

    @Override
    public String getApplicationName() {
        return this.appName;
    }

    @Override
    public List<String> getApplicationNames() {
        return this.appNames;
    }

    @Override
    public boolean isCpuSamplingEnabled() {
        return this.cpuSamplingEnabled;
    }

    @Override
    public boolean isAutoAppNamingEnabled() {
        return this.autoAppNamingEnabled;
    }

    @Override
    public boolean isAutoTransactionNamingEnabled() {
        return this.autoTransactionNamingEnabled;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debug;
    }

    @Override
    public boolean isDebugEnabled(String key) {
        return this.getProperty(key + "_debug", false);
    }

    @Override
    public String getLanguage() {
        return this.getProperty(LANGUAGE, DEFAULT_LANGUAGE);
    }

    @Override
    public boolean isSendDataOnExit() {
        return this.getProperty(SEND_DATA_ON_EXIT, false);
    }

    @Override
    public long getSendDataOnExitThresholdInMillis() {
        int valueInSecs = this.getIntProperty(SEND_DATA_ON_EXIT_THRESHOLD, 60);
        return TimeUnit.MILLISECONDS.convert(valueInSecs, TimeUnit.SECONDS);
    }

    @Override
    public boolean isAuditMode() {
        return this.auditModeConfig.isEnabled();
    }

    @Override
    public AuditModeConfig getAuditModeConfig() {
        return this.auditModeConfig;
    }

    @Override
    public boolean liteMode() {
        return this.litemode;
    }

    @Override
    public int getSegmentTimeoutInSec() {
        return this.segmentTimeoutInSec;
    }

    @Override
    public int getTokenTimeoutInSec() {
        return this.tokenTimeoutInSec;
    }

    @Override
    public int waitForTransactionsInMillis() {
        return this.waitForTransactionsInMillis;
    }

    @Override
    public boolean laspEnabled() {
        return !this.securityPoliciesToken.isEmpty();
    }

    @Override
    public String securityPoliciesToken() {
        return this.securityPoliciesToken;
    }

    @Override
    public boolean isCustomInstrumentationEditorAllowed() {
        return this.customInstrumentationEditorAllowed;
    }

    @Override
    public boolean isCustomParametersAllowed() {
        return this.customParameters;
    }

    @Override
    public DistributedTracingConfig getDistributedTracingConfig() {
        return this.distributedTracingConfig;
    }

    @Override
    public ExtensionsConfig getExtensionsConfig() {
        return this.extensionsConfig;
    }

    @Override
    public SpanEventsConfig getSpanEventsConfig() {
        return this.spanEventsConfig;
    }

    @Override
    public CommandParserConfig getCommandParserConfig() {
        return this.commandParserConfig;
    }

    @Override
    public InfiniteTracingConfig getInfiniteTracingConfig() {
        return this.infiniteTracingConfig;
    }

    private Object findPropertyInMap(String[] property, Map<String, Object> map) {
        Map<String, Object> result = map;
        for (String component : property) {
            if (result == null) break;
            if (!(result instanceof Map)) continue;
            Map<String, Object> resultMap = result;
            result = resultMap.containsKey(component) ? resultMap.get(component) : null;
        }
        return result;
    }

    @Override
    public List<String> logDeprecatedProperties(Map<String, Object> localSettings) {
        LinkedList<String> messages = new LinkedList<String>();
        Joiner stringJoiner = Joiner.on(".");
        for (DeprecatedProperty deprecatedProperty : deprecatedProperties.values()) {
            String joinedName = stringJoiner.join(deprecatedProperty.propertyName);
            String format = "Configuration {0} is deprecated and will be removed in the next major version.";
            if (this.getPropertyFromSystemEnvironment(joinedName, null) != null) {
                format = format + " It was set in the environment.";
            } else if (this.getPropertyFromSystemProperties(joinedName, null) != null) {
                format = format + " It was set as a system property.";
            } else {
                if (this.findPropertyInMap(deprecatedProperty.propertyName, localSettings) == null) continue;
                format = format + " It was set in the configuration file.";
            }
            format = deprecatedProperty.newPropertyName != null ? format + " Use " + stringJoiner.join(deprecatedProperty.newPropertyName) + " instead." : format + " This property is obsolete.";
            messages.add(MessageFormat.format(format, joinedName));
        }
        for (String message : messages) {
            Agent.LOG.log(Level.WARNING, message);
        }
        AgentConfigImpl.clearDeprecatedProperties();
        addDeprecatedProperties = false;
        return messages;
    }

    @Override
    public int getTransactionSizeLimit() {
        return this.transactionSizeLimit;
    }

    @Override
    public boolean waitForRPMConnect() {
        return this.waitForRPMConnect;
    }

    @Override
    public boolean isSyncStartup() {
        return this.getProperty(SYNC_STARTUP, false);
    }

    @Override
    public boolean isSendEnvironmentInfo() {
        return this.getProperty(SEND_ENVIRONMENT_INFO, true);
    }

    @Override
    public boolean isLoggingToStdOut() {
        String logFileName = this.getLogFileName();
        return STDOUT.equalsIgnoreCase(logFileName);
    }

    @Override
    public int getLogFileCount() {
        return this.getIntProperty(LOG_FILE_COUNT, 1);
    }

    @Override
    public String getLogFileName() {
        return this.getProperty(LOG_FILE_NAME, DEFAULT_LOG_FILE_NAME);
    }

    @Override
    public String getLogFilePath() {
        return (String)this.getProperty(LOG_FILE_PATH);
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public int getLogLimit() {
        return this.getIntProperty(LOG_LIMIT, 0);
    }

    @Override
    public TransactionTracerConfig getTransactionTracerConfig() {
        return this.transactionTracerConfig;
    }

    @Override
    public TransactionTracerConfig getBackgroundTransactionTracerConfig() {
        return this.backgroundTransactionTracerConfig;
    }

    @Override
    public TransactionTracerConfig getRequestTransactionTracerConfig() {
        return this.requestTransactionTracerConfig;
    }

    @Override
    public ErrorCollectorConfig getErrorCollectorConfig() {
        return this.errorCollectorConfig;
    }

    @Override
    public SqlTraceConfig getSqlTraceConfig() {
        return this.sqlTraceConfig;
    }

    @Override
    public CrossProcessConfig getCrossProcessConfig() {
        return this.crossProcessConfig;
    }

    @Override
    public ThreadProfilerConfig getThreadProfilerConfig() {
        return this.threadProfilerConfig;
    }

    @Override
    public JfrConfig getJfrConfig() {
        return this.jfrConfig;
    }

    @Override
    public JmxConfig getJmxConfig() {
        return this.jmxConfig;
    }

    @Override
    public JarCollectorConfig getJarCollectorConfig() {
        return this.jarCollectorConfig;
    }

    @Override
    public InsightsConfig getInsightsConfig() {
        return this.insightsConfig;
    }

    @Override
    public AttributesConfig getAttributesConfig() {
        return this.attributesConfig;
    }

    @Override
    public ReinstrumentConfig getReinstrumentConfig() {
        return this.reinstrumentConfig;
    }

    @Override
    public BrowserMonitoringConfig getBrowserMonitoringConfig() {
        return this.browserMonitoringConfig;
    }

    @Override
    public ClassTransformerConfig getClassTransformerConfig() {
        return this.classTransformerConfig;
    }

    @Override
    public List<String> getIgnoreJars() {
        return this.ignoreJars;
    }

    @Override
    public boolean isSendJvmProps() {
        return this.sendJvmProps;
    }

    @Override
    public String getCaBundlePath() {
        return this.caBundlePath;
    }

    @Override
    public boolean isLogDaily() {
        return this.logDaily;
    }

    @Override
    public boolean isTrimStats() {
        return this.trimStats;
    }

    @Override
    public boolean isPlatformInformationEnabled() {
        return this.platformInformationEnabled;
    }

    @Override
    public Set<String> getJDBCSupport() {
        return this.jdbcSupport;
    }

    @Override
    public boolean isGenericJDBCSupportEnabled() {
        return this.genericJdbcSupportEnabled;
    }

    @Override
    public int getMaxStackTraceLines() {
        return this.maxStackTraceLines;
    }

    @Override
    public Config getInstrumentationConfig() {
        return this.instrumentationConfig;
    }

    @Override
    public String getMetricIngestUri() {
        return this.metricIngestUri;
    }

    @Override
    public String getEventIngestUri() {
        return this.eventIngestUri;
    }

    @Override
    public boolean isHighSecurity() {
        return this.highSecurity;
    }

    @Override
    public boolean isSimpleCompression() {
        return this.simpleCompression;
    }

    @Override
    public String getCompressedContentEncoding() {
        return this.compressedContentEncoding;
    }

    @Override
    public boolean isPutForDataSend() {
        return this.putForDataSend;
    }

    @Override
    public boolean getIbmWorkaroundEnabled() {
        return this.ibmWorkaroundEnabled;
    }

    @Override
    public LabelsConfig getLabelsConfig() {
        return this.labelsConfig;
    }

    @Override
    public NormalizationRuleConfig getNormalizationRuleConfig() {
        return this.normalizationRuleConfig;
    }

    @Override
    public boolean isStartupTimingEnabled() {
        return this.startupTimingEnabled;
    }

    @Override
    public CircuitBreakerConfig getCircuitBreakerConfig() {
        return this.circuitBreakerConfig;
    }

    @Override
    public StripExceptionConfig getStripExceptionConfig() {
        return this.stripExceptionConfig;
    }

    @Override
    public TransactionNamingScheme getTransactionNamingScheme() {
        return this.transactionNamingMode;
    }

    @Override
    public UtilizationDataConfig getUtilizationDataConfig() {
        return this.utilizationConfig;
    }

    @Override
    public DatastoreConfig getDatastoreConfig() {
        return this.datastoreConfig;
    }

    @Override
    public ExternalTracerConfig getExternalTracerConfig() {
        return this.externalTracerConfig;
    }

    @Override
    public boolean openTracingEnabled() {
        return this.openTracingConfig.isEnabled();
    }

    @Override
    public TransactionEventsConfig getTransactionEventsConfig() {
        return this.transactionEventsConfig;
    }
}

