/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import java.util.Map;

public class SpanEventsConfig
extends BaseConfig {
    public static final int DEFAULT_MAX_SPAN_EVENTS_PER_HARVEST = 1000;
    public static final int DEFAULT_TARGET_SAMPLES_STORED = 10;
    public static final boolean DEFAULT_CROSS_PROCESS_ONLY = false;
    public static final String COLLECT_SPAN_EVENTS = "collect_span_events";
    private static final String ROOT = "newrelic.config.";
    private static final String SPAN_EVENTS = "span_events.";
    private static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.span_events.";
    public static final String ENABLED = "enabled";
    private static final String TARGET_SAMPLES_STORED = "target_samples_stored";
    private static final String CROSS_PROCESS_ONLY = "cross_process_only";
    private static final boolean DEFAULT_COLLECT_SPANS = false;
    public static final String SYSTEM_PROPERTY_SPAN_EVENTS_ENABLED = "newrelic.config.span_events.enabled";
    public static final String SPAN_EVENTS_ENABLED = "span_events.enabled";
    public static final String ENABLED_ENV_KEY = "NEW_RELIC_SPAN_EVENTS_ENABLED";
    private final boolean dtEnabled;
    private final int maxSamplesStored;
    private final boolean enabled;
    private final int targetSamplesStored;
    private final boolean crossProcessOnly;

    public SpanEventsConfig(Map<String, Object> props, boolean dtEnabled) {
        super(props, SYSTEM_PROPERTY_ROOT);
        this.dtEnabled = dtEnabled;
        this.maxSamplesStored = 1000;
        this.enabled = this.initEnabled(this.maxSamplesStored);
        this.targetSamplesStored = this.getProperty(TARGET_SAMPLES_STORED, 10);
        this.crossProcessOnly = this.getProperty(CROSS_PROCESS_ONLY, false);
    }

    private boolean initEnabled(int maxSamplesStored) {
        Boolean configEnabled = this.getProperty(ENABLED, this.dtEnabled) != false && this.dtEnabled;
        boolean collectSpanEventsFromCollector = this.getProperty(COLLECT_SPAN_EVENTS, false);
        return maxSamplesStored > 0 && configEnabled != false && collectSpanEventsFromCollector;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxSamplesStored() {
        return this.maxSamplesStored;
    }

    public int getTargetSamplesStored() {
        return this.targetSamplesStored;
    }

    public boolean isCrossProcessOnly() {
        return this.crossProcessOnly;
    }
}

