/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transaction;

import com.newrelic.agent.Agent;
import com.newrelic.agent.TransactionErrorPriority;
import com.newrelic.agent.transaction.TransactionErrorTracker;
import com.newrelic.agent.transaction.TransactionThrowable;
import com.newrelic.agent.util.StackTraces;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class TransactionErrorTrackerImpl
implements TransactionErrorTracker {
    private static final String SERVLET_EXCEPTION_CLASS_NAME = "javax.servlet.ServletException";
    private volatile TransactionThrowable throwable;
    private final ConcurrentMap<Integer, String> tracerErrors = new ConcurrentHashMap<Integer, String>();
    private final AtomicReference<TransactionErrorPriority> throwablePriority = new AtomicReference();

    public static Throwable unwrapIfServletException(Throwable throwable) {
        if (throwable != null && SERVLET_EXCEPTION_CLASS_NAME.equals(throwable.getClass().getName())) {
            return StackTraces.getRootCause(throwable);
        }
        return throwable;
    }

    @Override
    public TransactionThrowable getThrowable() {
        return this.throwable;
    }

    @Override
    public void setThrowable(TransactionThrowable transactionThrowable) {
        this.throwable = transactionThrowable;
    }

    @Override
    public void setThrowable(Throwable throwable, TransactionErrorPriority priority, boolean expected, String mostRecentSpanId) {
        if (throwable == null) {
            return;
        }
        Agent.LOG.log(Level.FINER, "Set throwable {0} (expected {1}) in transaction {2}", throwable.getClass().getName(), expected, this);
        Throwable rootCause = TransactionErrorTrackerImpl.unwrapIfServletException(throwable);
        String spanId = this.getSpanIdForThrowable(priority, throwable, mostRecentSpanId);
        this.setThrowable(new TransactionThrowable(rootCause, expected, spanId));
    }

    @Override
    public boolean tryUpdatePriority(TransactionErrorPriority newPriority) {
        return newPriority.updateCurrentPriority(this.throwablePriority);
    }

    @Override
    public TransactionErrorPriority getPriority() {
        return this.throwablePriority.get();
    }

    @Override
    public void noticeTracerException(Throwable throwable, String spanId) {
        if (throwable == null) {
            return;
        }
        int hashCode = System.identityHashCode(throwable);
        this.tracerErrors.putIfAbsent(hashCode, spanId);
    }

    private String getSpanIdForThrowable(TransactionErrorPriority priority, Throwable throwable, String mostRecentSpanId) {
        return priority == TransactionErrorPriority.API ? this.getCurrentSpanThenFallBackToNoticed(throwable, mostRecentSpanId) : this.getNoticedSpanThenFallBackToCurrent(throwable, mostRecentSpanId);
    }

    private String getNoticedSpanThenFallBackToCurrent(Throwable throwable, String mostRecentSpanId) {
        String noticedSpan = this.safeGetSpanIdForThrowable(throwable);
        return noticedSpan != null ? noticedSpan : mostRecentSpanId;
    }

    private String getCurrentSpanThenFallBackToNoticed(Throwable throwable, String mostRecentSpan) {
        return mostRecentSpan != null ? mostRecentSpan : this.safeGetSpanIdForThrowable(throwable);
    }

    private String safeGetSpanIdForThrowable(Throwable throwable) {
        return (String)this.tracerErrors.get(System.identityHashCode(throwable));
    }
}

