/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.jregex.util.io;

import com.newrelic.agent.deps.jregex.MatchResult;
import com.newrelic.agent.deps.jregex.Pattern;
import com.newrelic.agent.deps.jregex.RETokenizer;
import com.newrelic.agent.deps.jregex.Replacer;
import com.newrelic.agent.deps.jregex.Substitution;
import com.newrelic.agent.deps.jregex.TextBuffer;
import com.newrelic.agent.deps.jregex.util.io.PathElementEnumerator;
import com.newrelic.agent.deps.jregex.util.io.PathElementMask;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class PathPattern
extends Pattern {
    private static final int RESERVED = 1;
    private static int GRP_NO = 2;
    private static final int ANY_G = GRP_NO++;
    private static final int FS_G = GRP_NO++;
    private static final int STAR_G = GRP_NO++;
    private static final int QMARK_G = GRP_NO++;
    private static final int SPCHAR_G = GRP_NO++;
    private static final int NONROOT_G = GRP_NO++;
    private static final String fsChars = "/\\" + File.separator;
    private static final String fsClass = "[" + fsChars + "]";
    private static final String nfsClass = "[^" + fsChars + "]";
    private static final String fName = nfsClass + "+";
    private static final Pattern fs = new Pattern(fsClass);
    private static final Pattern spCharPattern = new Pattern(PathPattern.grp(NONROOT_G, "^(?!" + fsClass + ")") + "|" + PathPattern.grp(ANY_G, fsClass + "?\\*\\*" + fsClass + "?") + "|" + PathPattern.grp(FS_G, fsClass) + "|" + PathPattern.grp(STAR_G, "\\*") + "|" + PathPattern.grp(QMARK_G, "\\?") + "|" + PathPattern.grp(SPCHAR_G, "[.()\\{\\}+|^$\\[\\]\\\\]"));
    private static final Replacer spCharProcessor = new Replacer(spCharPattern, new Substitution(){

        public void appendSubstitution(MatchResult mr, TextBuffer dest) {
            if (mr.isCaptured(FS_G)) {
                dest.append(fsClass);
            } else if (mr.isCaptured(ANY_G)) {
                dest.append("(?:(?:");
                dest.append(fsClass);
                dest.append("|^)((?:");
                dest.append(fName);
                dest.append("(?:");
                dest.append(fsClass);
                dest.append(fName);
                dest.append(")*)?))?");
                dest.append("(?:");
                dest.append(fsClass);
                dest.append("|$)");
            } else if (mr.isCaptured(STAR_G)) {
                dest.append("(");
                dest.append(nfsClass);
                dest.append("*)");
            } else if (mr.isCaptured(QMARK_G)) {
                dest.append("(");
                dest.append(nfsClass);
                dest.append(")");
            } else if (mr.isCaptured(SPCHAR_G)) {
                dest.append("\\");
                mr.getGroup(SPCHAR_G, dest);
            } else if (mr.isCaptured(NONROOT_G)) {
                dest.append("(?:\\.");
                dest.append(fsClass);
                dest.append(")?");
            }
        }
    });
    private String str;
    private String root;
    private File rootf;
    private PathElementMask queue;
    private PathElementMask last;

    private static final String grp(int gno, String s2) {
        return "({" + gno + "}" + s2 + ")";
    }

    public PathPattern(String ptn) {
        this(ptn, 0);
    }

    public PathPattern(String ptn, boolean icase) {
        this(ptn, icase ? 1 : 0);
    }

    public PathPattern(String path, int flags) {
        this(null, path, flags);
    }

    public PathPattern(File dir, String path, boolean icase) {
        this(null, path, icase ? 1 : 0);
    }

    public PathPattern(File dir, String path, int flags) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("empty path not allowed");
        }
        this.str = path;
        RETokenizer tok = new RETokenizer(fs.matcher(path), true);
        String s2 = tok.nextToken();
        if (s2.equals("")) {
            if (dir != null) {
                this.rootf = dir;
            } else {
                this.root = "/";
            }
        } else {
            if (dir != null) {
                this.rootf = dir;
            } else {
                this.root = ".";
            }
            this.addElement(PathPattern.newMask(s2, flags, tok.hasMore()));
        }
        while (tok.hasMore()) {
            s2 = tok.nextToken();
            boolean hasMore = tok.hasMore();
            if (s2.equals("")) {
                if (!hasMore) break;
                throw new IllegalArgumentException("\"//\" not allowed");
            }
            this.addElement(PathPattern.newMask(s2, flags, hasMore));
        }
        this.compile(spCharProcessor.replace(path), flags);
    }

    private void addElement(PathElementMask mask) {
        if (this.queue == null) {
            this.queue = this.last = mask;
        } else {
            this.last = this.last.next = mask;
        }
    }

    public Enumeration enumerateFiles() {
        PathElementEnumerator fe = this.queue.newEnumerator();
        fe.setDir(this.rootf != null ? this.rootf : new File(this.root));
        return fe;
    }

    public File[] files() {
        Enumeration e = this.enumerateFiles();
        Vector v = new Vector();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        Object[] files = new File[v.size()];
        v.copyInto(files);
        return files;
    }

    public String[] names() {
        return null;
    }

    public File directory() {
        return null;
    }

    private static PathElementMask newMask(String s2, int flags, boolean dirsOnly) {
        if (s2 == null || s2.length() == 0) {
            throw new IllegalArgumentException("Error: empty path element not allowed");
        }
        if (s2.indexOf(42) < 0 && s2.indexOf(63) < 0) {
            if ((flags & 1) == 0 || s2.indexOf(58) >= 0) {
                return PathElementMask.fixedMask(s2, dirsOnly);
            }
            return PathElementMask.regularMask(s2, flags, dirsOnly);
        }
        if (s2.equals("*")) {
            return PathElementMask.anyFile(dirsOnly);
        }
        if (s2.equals("**")) {
            return PathElementMask.anyPath(dirsOnly);
        }
        return PathElementMask.regularMask(s2, flags, dirsOnly);
    }

    public String toString() {
        return this.str;
    }
}

