/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.context;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.instrumentation.InstrumentationUtils;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.ContextClassTransformer;
import com.newrelic.agent.instrumentation.context.FinalClassTransformer;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.context.InstrumentationContextManager;
import com.newrelic.agent.instrumentation.tracing.TraceClassTransformer;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.util.asm.Utils;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class InstrumentationClassTransformer
implements ClassFileTransformer {
    private static final Set<String> MARKER_INTERFACES_TO_SKIP = ImmutableSet.of("org/hibernate/proxy/HibernateProxy", "org/springframework/aop/SpringProxy", "java/security/PrivilegedAction");
    private final InstrumentationContextManager manager;
    private final TraceClassTransformer traceTransformer;
    private final boolean bootstrapClassloaderEnabled;
    private final boolean defaultMethodTracingEnabled;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final FinalClassTransformer finalClassTransformer = new FinalClassTransformer();

    public InstrumentationClassTransformer(InstrumentationContextManager manager, TraceClassTransformer traceTransformer, boolean bootstrapClassloaderEnabled, boolean defaultMethodTracingEnabled) {
        this.manager = manager;
        this.traceTransformer = traceTransformer;
        this.bootstrapClassloaderEnabled = bootstrapClassloaderEnabled;
        this.defaultMethodTracingEnabled = defaultMethodTracingEnabled;
    }

    public void setInitialized(boolean isInitialized) {
        this.initialized.set(isInitialized);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        long transformStartTimeInNs = System.nanoTime();
        try {
            byte[] bytes;
            if (className == null) {
                return null;
            }
            if (!this.initialized.get() && className.startsWith("com/newrelic/agent/")) {
                return null;
            }
            if (loader == null && !this.bootstrapClassloaderEnabled) {
                Agent.LOG.finest(MessageFormat.format("Instrumentation skipped by ''bootstrap'' rule: {0}", className));
                return null;
            }
            if (!this.manager.shouldTransform(className, loader)) {
                return null;
            }
            ClassReader reader = new ClassReader(classfileBuffer);
            if (InstrumentationUtils.isAnnotation(reader)) {
                return null;
            }
            if (InstrumentationUtils.isInterface(reader)) {
                this.manager.applyInterfaceVisitors(loader, classBeingRedefined, reader);
                if (!InstrumentationUtils.isDefaultMethodSupported(reader) || !this.defaultMethodTracingEnabled) {
                    return null;
                }
            }
            if (Utils.isJdkProxy(reader)) {
                Agent.LOG.finest(MessageFormat.format("Instrumentation skipped by ''JDK proxy'' rule: {0}", className));
                return null;
            }
            InstrumentationContext context = new InstrumentationContext(classfileBuffer, classBeingRedefined, protectionDomain);
            context.match(loader, classBeingRedefined, reader, this.manager.getMatchVisitors().keySet());
            if (context.isGenerated()) {
                if (context.hasSourceAttribute()) {
                    Agent.LOG.finest(MessageFormat.format("Instrumentation skipped by ''generated'' rule: {0}", className));
                } else {
                    Agent.LOG.finest(MessageFormat.format("Instrumentation skipped by ''no source'' rule: {0}", className));
                }
                return null;
            }
            if (!context.getMatches().isEmpty() && InstrumentationClassTransformer.skipInterfaceMarkers(reader)) {
                Agent.LOG.finest(MessageFormat.format("Instrumentation skipped by ''class name'' rule: {0}", className));
                return null;
            }
            for (Map.Entry<ClassMatchVisitorFactory, OptimizedClassMatcher.Match> entry : context.getMatches().entrySet()) {
                ContextClassTransformer transformer = this.manager.getMatchVisitors().get(entry.getKey());
                if (transformer != null && transformer != InstrumentationContextManager.NO_OP_TRANSFORMER) {
                    byte[] bytes2 = transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer, context, entry.getValue());
                    if (bytes2 == null) continue;
                    context.markAsModified();
                    classfileBuffer = bytes2;
                    continue;
                }
                Agent.LOG.log(Level.FINE, "Unable to find a class transformer to process match {0}", entry.getValue());
            }
            if (context.isTracerMatch() && (bytes = this.traceTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer, context, null)) != null) {
                context.markAsModified();
                classfileBuffer = bytes;
            }
            if (context.isModified()) {
                byte[] transformation = this.finalClassTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer, context, null);
                ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordMetricWork("Supportability/Classloader/TransformTime", System.nanoTime() - transformStartTimeInNs));
                return transformation;
            }
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINE, t, "Unexpected exception thrown in class transformer: {0}--{1}", loader, className);
        }
        return null;
    }

    private static boolean skipInterfaceMarkers(ClassReader reader) {
        for (String interfaceName : reader.getInterfaces()) {
            if (!MARKER_INTERFACES_TO_SKIP.contains(interfaceName)) continue;
            return true;
        }
        return false;
    }
}

