/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.context;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.tracing.TraceDetails;
import com.newrelic.agent.instrumentation.tracing.TraceDetailsBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class TraceInformation {
    private Map<Method, TraceDetails> traces;
    private Set<Method> ignoreApdexMethods;
    private Set<Method> ignoreTransactionMethods;

    public Map<Method, TraceDetails> getTraceAnnotations() {
        return this.traces == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.traces);
    }

    void pullAll(Map<Method, TraceDetails> tracedMethods) {
        if (this.traces == null) {
            this.traces = new HashMap<Method, TraceDetails>(tracedMethods);
        } else {
            for (Map.Entry<Method, TraceDetails> entry : tracedMethods.entrySet()) {
                this.putTraceAnnotation(entry.getKey(), entry.getValue());
            }
        }
    }

    void putTraceAnnotation(Method method, TraceDetails trace) {
        if (this.traces == null) {
            this.traces = new HashMap<Method, TraceDetails>();
        } else {
            TraceDetails existing = this.traces.get(method);
            if (existing != null) {
                Agent.LOG.log(Level.FINEST, "Merging trace details {0} and {1} for method {2}", existing, trace, method);
                trace = TraceDetailsBuilder.merge(existing, trace);
            }
        }
        this.traces.put(method, trace);
    }

    public Set<Method> getIgnoreApdexMethods() {
        return this.ignoreApdexMethods == null ? Collections.emptySet() : this.ignoreApdexMethods;
    }

    public Set<Method> getIgnoreTransactionMethods() {
        return this.ignoreTransactionMethods == null ? Collections.emptySet() : this.ignoreTransactionMethods;
    }

    public void addIgnoreApdexMethod(String methodName, String methodDesc) {
        if (this.ignoreApdexMethods == null) {
            this.ignoreApdexMethods = new HashSet<Method>();
        }
        this.ignoreApdexMethods.add(new Method(methodName, methodDesc));
    }

    public void addIgnoreTransactionMethod(String methodName, String methodDesc) {
        if (this.ignoreTransactionMethods == null) {
            this.ignoreTransactionMethods = new HashSet<Method>();
        }
        this.ignoreTransactionMethods.add(new Method(methodName, methodDesc));
    }

    public void addIgnoreTransactionMethod(Method m3) {
        if (this.ignoreTransactionMethods == null) {
            this.ignoreTransactionMethods = new HashSet<Method>();
        }
        this.ignoreTransactionMethods.add(m3);
    }

    public boolean isMatch() {
        return !this.getTraceAnnotations().isEmpty() || !this.getIgnoreApdexMethods().isEmpty() || !this.getIgnoreTransactionMethods().isEmpty();
    }
}

