/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.v2;

import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.profile.ProfilerControl;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.profile.v2.ProfileSession;
import com.newrelic.agent.profile.v2.TransactionProfileService;
import com.newrelic.agent.profile.v2.TransactionProfileSession;
import com.newrelic.agent.profile.v2.TransactionProfileSessionImpl;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.util.DefaultThreadFactory;
import com.newrelic.agent.util.SafeWrappers;
import java.text.MessageFormat;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ProfilerService
extends AbstractService
implements ProfilerControl {
    private static final String PROFILER_THREAD_NAME = "New Relic Profiler Service";
    private volatile ProfileSession currentSession;
    private final ScheduledExecutorService scheduledExecutor;
    private final TransactionListener transactionListener = new TransactionListener(){

        @Override
        public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
            ProfilerService.this.transactionFinished(transactionData);
        }
    };
    private final TransactionProfileService transactionProfileService;

    public ProfilerService() {
        this(Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory(PROFILER_THREAD_NAME, true)));
    }

    public ProfilerService(ScheduledExecutorService scheduledExecutorService) {
        super(ProfilerService.class.getSimpleName());
        this.scheduledExecutor = scheduledExecutorService;
        this.transactionProfileService = new TransactionProfileServiceImpl();
    }

    protected void transactionFinished(TransactionData transactionData) {
        ProfileSession session = this.getCurrentSession();
        if (null != session) {
            session.transactionFinished(transactionData);
        }
    }

    @Override
    public boolean isEnabled() {
        return ServiceFactory.getConfigService().getDefaultAgentConfig().getThreadProfilerConfig().isEnabled();
    }

    @Override
    public synchronized void startProfiler(ProfilerParameters parameters) {
        long samplePeriodInMillis = parameters.getSamplePeriodInMillis();
        long durationInMillis = parameters.getDurationInMillis();
        boolean enabled = ServiceFactory.getConfigService().getDefaultAgentConfig().getThreadProfilerConfig().isEnabled();
        if (!enabled || samplePeriodInMillis <= 0L || durationInMillis <= 0L || samplePeriodInMillis > durationInMillis) {
            this.getLogger().info(MessageFormat.format("Ignoring the start profiler command: enabled={0}, samplePeriodInMillis={1}, durationInMillis={2}", enabled, samplePeriodInMillis, durationInMillis));
            return;
        }
        ProfileSession oldSession = this.currentSession;
        if (oldSession != null && !oldSession.isDone()) {
            this.getLogger().info(MessageFormat.format("Ignoring the start profiler command because a session is currently active. {0}", oldSession.getProfileId()));
            return;
        }
        ProfileSession newSession = this.createProfileSession(parameters);
        newSession.start();
        this.currentSession = newSession;
    }

    @Override
    public synchronized int stopProfiler(Long profileId, boolean shouldReport) {
        ProfileSession session = this.currentSession;
        if (session != null && profileId.equals(session.getProfileId())) {
            session.stop(shouldReport);
            return 0;
        }
        return -1;
    }

    synchronized void sessionCompleted(ProfileSession session) {
        if (this.currentSession != session) {
            return;
        }
        this.currentSession = null;
    }

    protected ProfileSession createProfileSession(ProfilerParameters parameters) {
        return new ProfileSession(this, parameters);
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        return SafeWrappers.safeExecutor(this.scheduledExecutor);
    }

    @Override
    protected void doStart() {
    }

    protected ProfileSession getCurrentSession() {
        return this.currentSession;
    }

    @Override
    protected void doStop() {
        ProfileSession session = this.getCurrentSession();
        if (session != null) {
            session.stop(false);
        }
        ServiceFactory.getTransactionService().removeTransactionListener(this.transactionListener);
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
            try {
                if (!this.scheduledExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                    this.getLogger().log(Level.FINE, "Profiler Service executor service did not terminate");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public TransactionProfileService getTransactionProfileService() {
        return this.transactionProfileService;
    }

    private class TransactionProfileServiceImpl
    implements TransactionProfileService {
        private TransactionProfileServiceImpl() {
        }

        @Override
        public boolean isTransactionProfileSessionActive() {
            return this.getTransactionProfileSession().isActive();
        }

        @Override
        public TransactionProfileSession getTransactionProfileSession() {
            if (ServiceFactory.getServiceManager().getCircuitBreakerService().isTripped()) {
                return TransactionProfileSessionImpl.NO_OP_TRANSACTION_PROFILE_SESSION;
            }
            ProfileSession session = ProfilerService.this.currentSession;
            return session == null ? TransactionProfileSessionImpl.NO_OP_TRANSACTION_PROFILE_SESSION : session.getProfile().getTransactionProfileSession();
        }
    }
}

