/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.module;

import com.newrelic.agent.interfaces.backport.Consumer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TrackedAddSet<T>
implements Consumer<T> {
    private static final int DEFAULT_MAX_SIZE = 1000;
    private final Set<T> fullSet = new HashSet<T>();
    private Set<T> addedElementSet = new HashSet<T>();
    private final int maxSize;
    private final Object lock = new Object();

    public TrackedAddSet() {
        this(1000);
    }

    public TrackedAddSet(int overrideMaxSize) {
        this.maxSize = overrideMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> resetReturningAdded() {
        Object object = this.lock;
        synchronized (object) {
            Set<T> returnSet = this.addedElementSet;
            this.addedElementSet = new HashSet<T>();
            return Collections.unmodifiableSet(returnSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> resetReturningAll() {
        Object object = this.lock;
        synchronized (object) {
            this.addedElementSet = new HashSet<T>();
            return Collections.unmodifiableSet(new HashSet<T>(this.fullSet));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(T element) {
        Object object = this.lock;
        synchronized (object) {
            if (element != null && this.fullSet.size() < this.maxSize && this.fullSet.add(element)) {
                this.addedElementSet.add(element);
            }
        }
    }
}

