/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.AgentCommandLineParser;
import com.newrelic.agent.ForceDisconnectException;
import com.newrelic.agent.InitProblemClasses;
import com.newrelic.agent.LifecycleObserver;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.config.ConfigServiceFactory;
import com.newrelic.agent.config.JarResource;
import com.newrelic.agent.config.JavaVersionUtils;
import com.newrelic.agent.core.CoreServiceImpl;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.logging.AgentLogManager;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.ServiceManager;
import com.newrelic.agent.service.ServiceManagerImpl;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.util.asm.ClassStructure;
import com.newrelic.bootstrap.BootstrapLoader;
import com.newrelic.weave.utils.Streams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;

public final class Agent {
    public static final IAgentLogger LOG = AgentLogManager.getLogger();
    private static final String NEWRELIC_BOOTSTRAP = "newrelic-bootstrap";
    private static final String AGENT_ENABLED_PROPERTY = "newrelic.config.agent_enabled";
    private static final boolean DEBUG = Boolean.getBoolean("newrelic.debug");
    private static final String VERSION = Agent.initVersion();
    private static long agentPremainTime;
    private static volatile boolean canFastPath;

    public static String getVersion() {
        return VERSION;
    }

    private static String initVersion() {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(Agent.class.getName());
            return bundle.getString("version");
        }
        catch (Throwable throwable) {
            return "0.0";
        }
    }

    public static boolean isDebugEnabled() {
        return DEBUG;
    }

    public static boolean canFastPath() {
        return canFastPath;
    }

    public static void disableFastPath() {
        if (canFastPath) {
            canFastPath = false;
        }
    }

    public static void continuePremain(String agentArgs, Instrumentation inst, long startTime) {
        LifecycleObserver lifecycleObserver = LifecycleObserver.createLifecycleObserver(agentArgs);
        if (!lifecycleObserver.isAgentSafe()) {
            return;
        }
        Agent.addMixinInterfacesToBootstrap(inst);
        if (ServiceFactory.getServiceManager() != null) {
            LOG.warning("New Relic Agent is already running! Check if more than one -javaagent switch is used on the command line.");
            lifecycleObserver.agentAlreadyRunning();
            return;
        }
        String enabled = System.getProperty(AGENT_ENABLED_PROPERTY);
        if (enabled != null && !Boolean.parseBoolean(enabled)) {
            LOG.warning("New Relic Agent is disabled by a system property.");
            return;
        }
        String jvmName = System.getProperty("java.vm.name");
        if (jvmName.contains("Oracle JRockit")) {
            String msg = MessageFormat.format("New Relic Agent {0} does not support the Oracle JRockit JVM (\"{1}\").", Agent.getVersion(), jvmName);
            LOG.warning(msg);
        }
        if (!Agent.tryToInitializeServiceManager(inst)) {
            return;
        }
        try {
            ServiceManager serviceManager = ServiceFactory.getServiceManager();
            serviceManager.start();
            lifecycleObserver.serviceManagerStarted(serviceManager);
            LOG.info(MessageFormat.format("New Relic Agent v{0} has started", Agent.getVersion()));
            if (System.getProperty("newrelic.bootstrap_classpath") != null) {
                LOG.info("The \"newrelic.bootstrap_classpath\" property is no longer used. Please remove it from your configuration.");
            }
            LOG.info("Agent class loader: " + AgentBridge.getAgent().getClass().getClassLoader());
            Agent.logAnyFilesFoundInEndorsedDirs();
            if (serviceManager.getConfigService().getDefaultAgentConfig().isStartupTimingEnabled()) {
                Agent.recordPremainTime(serviceManager.getStatsService(), startTime);
            }
            Agent.recordAgentVersion(serviceManager.getStatsService());
        }
        catch (Throwable t) {
            String msg = "Unable to start New Relic Agent. Please remove -javaagent from your startup arguments and contact New Relic support.";
            try {
                LOG.log(Level.SEVERE, t, msg);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.err.println(msg);
            if (t instanceof NoClassDefFoundError) {
                String version = System.getProperty("java.version");
                if (version.startsWith("9") || version.startsWith("10")) {
                    String message = "We currently do not support Java 9 or 10 in modular mode. If you are running with it and want to use the agent, use command line flag '--add-modules' to add appropriate modules";
                    System.err.println(message);
                } else if (version.startsWith("11") || version.startsWith("12")) {
                    String message = "Applications that previously relied on the command line flag '--add-modules' will no longer work with Java EE dependencies. You must add all Java EE dependencies to your build file manually, and then remove the --add-modules flag for them.";
                    System.err.println(message);
                }
            }
            t.printStackTrace();
            System.exit(1);
        }
        lifecycleObserver.agentStarted();
    }

    private static boolean tryToInitializeServiceManager(Instrumentation inst) {
        try {
            CoreServiceImpl coreService = new CoreServiceImpl(inst);
            ConfigService configService = ConfigServiceFactory.createConfigService(LOG, System.getProperty("newrelic.checkconfig") != null);
            ServiceManagerImpl serviceManager = new ServiceManagerImpl(coreService, configService);
            ServiceFactory.setServiceManager(serviceManager);
            if (Agent.isLicenseKeyEmpty(serviceManager.getConfigService().getDefaultAgentConfig().getLicenseKey())) {
                LOG.error("license_key is empty in the config. Not starting New Relic Agent.");
                return false;
            }
            if (!serviceManager.getConfigService().getDefaultAgentConfig().isAgentEnabled()) {
                LOG.warning("agent_enabled is false in the config. Not starting New Relic Agent.");
                return false;
            }
            BootstrapLoader.forceCorrectNewRelicApi(inst);
            InitProblemClasses.loadInitialClasses();
        }
        catch (ForceDisconnectException e) {
            LOG.log(Level.SEVERE, e.getMessage());
            return false;
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, t, "Unable to start the New Relic Agent. Your application will continue to run but it will not be monitored.");
            return false;
        }
        return true;
    }

    private static void logAnyFilesFoundInEndorsedDirs() {
        String javaEndorsedDirs = System.getProperty("java.endorsed.dirs");
        if (javaEndorsedDirs == null || javaEndorsedDirs.isEmpty()) {
            return;
        }
        try {
            String[] endorsedDirs;
            for (String endorsedDir : endorsedDirs = javaEndorsedDirs.split(String.valueOf(File.pathSeparatorChar))) {
                File[] files;
                File endorsedDirFile = new File(endorsedDir);
                if (!endorsedDirFile.exists() || !endorsedDirFile.isDirectory() || (files = endorsedDirFile.listFiles()) == null || files.length == 0) continue;
                LOG.log(Level.WARNING, "The 'java.endorsed.dirs' system property is set to {0} and that directory is not empty for this jvm. This may cause unexpected behavior.", endorsedDir);
                StringBuilder endorsedDirContent = new StringBuilder();
                for (File file : files) {
                    if (endorsedDirContent.length() > 0) {
                        endorsedDirContent.append(", ");
                    }
                    endorsedDirContent.append(file.getName());
                }
                LOG.log(Level.FINER, "The endorsed directory {0} contains the following items: {1}", endorsedDir, endorsedDirContent.toString());
            }
        }
        catch (Throwable t) {
            LOG.log(Level.FINE, t, "An unexpected error occurred while checking for java.endorsed.dirs property");
        }
    }

    private static boolean isLicenseKeyEmpty(String licenseKey) {
        return licenseKey == null || licenseKey.isEmpty() || licenseKey.equals("<%= license_key %>");
    }

    public static void main(String[] args2) {
        String javaSpecVersion = JavaVersionUtils.getJavaSpecificationVersion();
        if (!JavaVersionUtils.isAgentSupportedJavaSpecVersion(javaSpecVersion)) {
            System.err.println("----------");
            System.err.println(JavaVersionUtils.getUnsupportedAgentJavaSpecVersionMessage(javaSpecVersion));
            System.err.println("----------");
            return;
        }
        new AgentCommandLineParser().parseCommand(args2);
    }

    public static long getAgentPremainTimeInMillis() {
        return agentPremainTime;
    }

    private static void recordPremainTime(StatsService statsService, long startTime) {
        agentPremainTime = System.currentTimeMillis() - startTime;
        LOG.log(Level.INFO, "Premain startup complete in {0}ms", agentPremainTime);
        statsService.doStatsWork(StatsWorks.getRecordResponseTimeWork("Supportability/Timing/Premain", agentPremainTime));
        ImmutableMap<String, Long> environmentInfo = ImmutableMap.builder().put("Duration", agentPremainTime).put("Version", (Long)((Object)Agent.getVersion())).put("JRE Vendor", (Long)((Object)System.getProperty("java.vendor"))).put("JRE Version", (Long)((Object)System.getProperty("java.version"))).put("JVM Vendor", (Long)((Object)System.getProperty("java.vm.vendor"))).put("JVM Version", (Long)((Object)System.getProperty("java.vm.version"))).put("JVM Runtime Version", (Long)((Object)System.getProperty("java.runtime.version"))).put("OS Name", (Long)((Object)System.getProperty("os.name"))).put("OS Version", (Long)((Object)System.getProperty("os.version"))).put("OS Arch", (Long)((Object)System.getProperty("os.arch"))).put("Processors", (Long)Runtime.getRuntime().availableProcessors()).put("Free Memory", Runtime.getRuntime().freeMemory()).put("Total Memory", Runtime.getRuntime().totalMemory()).put("Max Memory", Runtime.getRuntime().maxMemory()).build();
        LOG.log(Level.FINE, "Premain environment info: {0}", ((Object)environmentInfo).toString());
    }

    private static void recordAgentVersion(StatsService statsService) {
        statsService.doStatsWork(StatsWorks.getIncrementCounterWork(MessageFormat.format("Supportability/Java/AgentVersion/{0}", Agent.getVersion()), 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addMixinInterfacesToBootstrap(Instrumentation inst) {
        if (Agent.isDisableMixinsOnBootstrap()) {
            System.out.println("New Relic Agent: mixin interfaces not moved to bootstrap");
            return;
        }
        JarResource agentJarResource = null;
        try {
            agentJarResource = AgentJarHelper.getAgentJarResource();
            URL agentJarUrl = AgentJarHelper.getAgentJarUrl();
            Agent.addMixinInterfacesToBootstrap(agentJarResource, agentJarUrl, inst);
        }
        finally {
            try {
                agentJarResource.close();
            }
            catch (Throwable th) {
                Agent.logIfNRDebug("closing Agent jar resource", th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMixinInterfacesToBootstrap(JarResource agentJarResource, URL agentJarUrl, Instrumentation inst) {
        boolean succeeded = false;
        Pattern packageSearchPattern = Pattern.compile("com/newrelic/agent/instrumentation/pointcuts/(.*).class");
        String interfaceMixinAnnotation = "Lcom/newrelic/agent/instrumentation/pointcuts/InterfaceMixin;";
        String loadOnBootstrapAnnotation = "Lcom/newrelic/agent/instrumentation/pointcuts/LoadOnBootstrap;";
        String interfaceMapperAnnotation = "Lcom/newrelic/agent/instrumentation/pointcuts/InterfaceMapper;";
        String methodMapperAnnotation = "Lcom/newrelic/agent/instrumentation/pointcuts/MethodMapper;";
        String fieldAccessorAnnotation = "Lcom/newrelic/agent/instrumentation/pointcuts/FieldAccessor;";
        List<String> bootstrapAnnotations = Arrays.asList("Lcom/newrelic/agent/instrumentation/pointcuts/InterfaceMixin;", "Lcom/newrelic/agent/instrumentation/pointcuts/InterfaceMapper;", "Lcom/newrelic/agent/instrumentation/pointcuts/MethodMapper;", "Lcom/newrelic/agent/instrumentation/pointcuts/FieldAccessor;", "Lcom/newrelic/agent/instrumentation/pointcuts/LoadOnBootstrap;");
        File generatedFile = null;
        ZipOutputStream outputJarStream = null;
        try {
            generatedFile = File.createTempFile(NEWRELIC_BOOTSTRAP, ".jar", BootstrapLoader.getTempDir());
            Manifest manifest = Agent.createManifest();
            outputJarStream = Agent.createJarOutputStream(generatedFile, manifest);
            long modTime = System.currentTimeMillis();
            Collection<String> fileNames = AgentJarHelper.findJarFileNames(agentJarUrl, packageSearchPattern);
            for (String fileName : fileNames) {
                int size = (int)agentJarResource.getSize(fileName);
                ByteArrayOutputStream out = new ByteArrayOutputStream(size);
                Streams.copy(agentJarResource.getInputStream(fileName), out, size, true);
                byte[] classBytes = out.toByteArray();
                ClassReader cr = new ClassReader(classBytes);
                ClassStructure structure = ClassStructure.getClassStructure(cr, 4);
                Set<String> annotations = structure.getClassAnnotations().keySet();
                if (!Agent.containsAnyOf(bootstrapAnnotations, annotations)) continue;
                JarEntry entry = new JarEntry(fileName);
                entry.setTime(modTime);
                ((JarOutputStream)outputJarStream).putNextEntry(entry);
                outputJarStream.write(classBytes);
            }
            outputJarStream.closeEntry();
            succeeded = true;
        }
        catch (IOException iox) {
            Agent.logIfNRDebug("generating mixin jar file", iox);
        }
        finally {
            try {
                outputJarStream.close();
            }
            catch (Throwable th) {
                Agent.logIfNRDebug("closing outputJarStream", th);
            }
        }
        if (succeeded) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(generatedFile);
                inst.appendToBootstrapClassLoaderSearch(jarFile);
                generatedFile.deleteOnExit();
            }
            catch (IOException iox) {
                Agent.logIfNRDebug("adding dynamic mixin jar to bootstrap", iox);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Throwable th) {
                    Agent.logIfNRDebug("closing generated jar file", th);
                }
            }
        }
    }

    private static final boolean containsAnyOf(Collection<?> searchFor, Collection<?> searchIn) {
        for (Object key : searchFor) {
            if (!searchIn.contains(key)) continue;
            return true;
        }
        return false;
    }

    private static final boolean isDisableMixinsOnBootstrap() {
        String newrelicDisableMixinsOnBootstrap = "newrelic.disable.mixins.on.bootstrap";
        return System.getProperty(newrelicDisableMixinsOnBootstrap) != null && Boolean.getBoolean(newrelicDisableMixinsOnBootstrap);
    }

    private static final void logIfNRDebug(String msg, Throwable th) {
        if (Agent.isDebugEnabled()) {
            System.out.println("While bootstrapping the Agent: " + msg + ": " + th.getStackTrace());
        }
    }

    private static final JarOutputStream createJarOutputStream(File jarFile, Manifest manifest) throws IOException {
        FileOutputStream outStream = new FileOutputStream(jarFile);
        return new JarOutputStream((OutputStream)outStream, manifest);
    }

    private static final Manifest createManifest() {
        Manifest manifest = new Manifest();
        Attributes a = manifest.getMainAttributes();
        a.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        a.put(Attributes.Name.IMPLEMENTATION_TITLE, "Interface Mixins");
        a.put(Attributes.Name.IMPLEMENTATION_VERSION, "1.0");
        a.put(Attributes.Name.IMPLEMENTATION_VENDOR, "New Relic");
        return manifest;
    }

    static {
        canFastPath = true;
    }
}

