/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.io.grpc.internal;

import com.newrelic.agent.deps.com.google.common.base.Preconditions;
import com.newrelic.agent.deps.com.google.common.base.Throwables;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LogExceptionRunnable
implements Runnable {
    private static final Logger log;
    private final Runnable task;

    public LogExceptionRunnable(Runnable task) {
        this.task = Preconditions.checkNotNull(task, "task");
    }

    @Override
    public void run() {
        try {
            this.task.run();
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Exception while executing runnable " + this.task, t);
            Throwables.throwIfUnchecked(t);
            throw new AssertionError((Object)t);
        }
    }

    public String toString() {
        return "LogExceptionRunnable(" + this.task + ")";
    }

    static {
        LogExceptionRunnable.class.getName();
        log = Logger.global;
    }
}

