/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr;

import com.newrelic.jfr.ThreadNameNormalizer;
import com.newrelic.jfr.profiler.EventToEventSummary;
import com.newrelic.jfr.profiler.ProfileSummarizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProfilerRegistry {
    private final List<EventToEventSummary> mappers;

    private static List<EventToEventSummary> allMappers(ThreadNameNormalizer nameNormalizer) {
        return Arrays.asList(ProfileSummarizer.forExecutionSample(nameNormalizer), ProfileSummarizer.forNativeMethodSample(nameNormalizer));
    }

    private ProfilerRegistry(List<EventToEventSummary> mappers) {
        this.mappers = mappers;
    }

    public static ProfilerRegistry createDefault(ThreadNameNormalizer nameNormalizer) {
        return new ProfilerRegistry(ProfilerRegistry.allMappers(nameNormalizer));
    }

    static ProfilerRegistry create(Collection<String> eventNames) {
        List<EventToEventSummary> filtered = ProfilerRegistry.allMappers(null).stream().filter(mapper -> eventNames.contains(mapper.getEventName())).collect(Collectors.toList());
        return new ProfilerRegistry(filtered);
    }

    public Stream<EventToEventSummary> all() {
        return this.mappers.stream();
    }

    public Optional<EventToEventSummary> get(String eventName) {
        return this.mappers.stream().filter(m3 -> m3.getEventName().equals(eventName)).findFirst();
    }
}

