/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic;

import com.newrelic.BackoffPolicy;
import com.newrelic.ChannelClosingException;
import com.newrelic.ChannelManager;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.io.grpc.Status;
import com.newrelic.agent.deps.io.grpc.stub.StreamObserver;
import com.newrelic.api.agent.Logger;
import com.newrelic.api.agent.MetricAggregator;
import com.newrelic.trace.v1.V1;
import java.util.logging.Level;

class ResponseObserver
implements StreamObserver<V1.RecordStatus> {
    private final Logger logger;
    private final ChannelManager channelManager;
    private final MetricAggregator aggregator;
    private final BackoffPolicy backoffManager;

    ResponseObserver(Logger logger, ChannelManager channelManager, MetricAggregator aggregator, BackoffPolicy backoffPolicy) {
        this.logger = logger;
        this.channelManager = channelManager;
        this.aggregator = aggregator;
        this.backoffManager = backoffPolicy;
    }

    @Override
    public void onNext(V1.RecordStatus value) {
        this.aggregator.incrementCounter("Supportability/InfiniteTracing/Response");
        this.backoffManager.reset();
    }

    @Override
    public void onError(Throwable t2) {
        Status status = Status.fromThrowable(t2);
        if (status.getCause() instanceof ChannelClosingException) {
            this.logger.log(Level.FINE, "Stopping gRPC response observer because span observer was closed by another thread.");
            return;
        }
        if (ResponseObserver.isOkHttpALPNError(status)) {
            this.logger.log(Level.SEVERE, t2, "ALPN does not appear to be supported on this JVM. Please install a supported JCE provider or update Java to use Infinite Tracing.");
            this.aggregator.incrementCounter("Supportability/InfiniteTracing/NoALPNSupport");
            this.channelManager.shutdownChannelForever();
            return;
        }
        this.aggregator.incrementCounter("Supportability/InfiniteTracing/Span/gRPC/" + (Object)((Object)status.getCode()));
        this.aggregator.incrementCounter("Supportability/InfiniteTracing/Response/Error");
        if (status.getCode() == Status.Code.UNIMPLEMENTED) {
            this.logger.log(Level.WARNING, "Received gRPC status {0}, no longer permitting connections.", (Object)status.getCode().toString());
            this.channelManager.shutdownChannelForever();
            return;
        }
        this.shutdownChannelAndBackoff(status);
    }

    private static boolean isOkHttpALPNError(Status status) {
        return status.getCause() instanceof RuntimeException && status.getCause().getMessage().startsWith("TLS ALPN negotiation failed with protocols");
    }

    @VisibleForTesting
    void shutdownChannelAndBackoff(Status status) {
        int backoffSeconds;
        Level logLevel = Level.WARNING;
        if (ResponseObserver.isConnectTimeoutError(status)) {
            backoffSeconds = 0;
            logLevel = Level.FINE;
        } else {
            backoffSeconds = status.getCode() == Status.Code.FAILED_PRECONDITION ? this.backoffManager.getNextBackoffSeconds() : this.backoffManager.getDefaultBackoffSeconds();
        }
        this.logger.log(logLevel, (Throwable)status.asException(), "Received gRPC status {0}.", (Object)status.getCode().toString());
        this.channelManager.shutdownChannelAndBackoff(backoffSeconds);
    }

    private static boolean isConnectTimeoutError(Status status) {
        return status.getCode() == Status.Code.INTERNAL && status.getDescription() != null && status.getDescription().startsWith("No error: A GRPC status of OK should have been sent");
    }

    @Override
    public void onCompleted() {
        this.logger.log(Level.FINE, "Completing gRPC response observer.");
        this.aggregator.incrementCounter("Supportability/InfiniteTracing/Response/Completed");
        this.channelManager.recreateSpanObserver();
    }
}

