/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jfr;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.config.JfrConfig;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.jfr.daemon.DaemonConfig;
import com.newrelic.jfr.daemon.EventConverter;
import com.newrelic.jfr.daemon.JFRUploader;
import com.newrelic.jfr.daemon.JfrController;
import com.newrelic.jfr.daemon.JfrRecorderException;
import com.newrelic.jfr.daemon.SetupUtils;
import com.newrelic.jfr.daemon.VersionFinder;
import com.newrelic.telemetry.Attributes;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;

public class JfrService
extends AbstractService
implements AgentConfigListener {
    private final JfrConfig jfrConfig;
    private final AgentConfig defaultAgentConfig;
    private JfrController jfrController;

    public JfrService(JfrConfig jfrConfig, AgentConfig defaultAgentConfig) {
        super(JfrService.class.getSimpleName());
        this.jfrConfig = jfrConfig;
        this.defaultAgentConfig = defaultAgentConfig;
        ServiceFactory.getConfigService().addIAgentConfigListener(this);
    }

    @Override
    protected void doStart() {
        if (this.coreApisExist() && this.isEnabled()) {
            Agent.LOG.log(Level.INFO, "Attaching New Relic JFR Monitor");
            NewRelic.getAgent().getMetricAggregator().incrementCounter("Supportability/JfrService/Started/Success");
            try {
                DaemonConfig daemonConfig = this.buildDaemonConfig();
                Attributes commonAttrs = SetupUtils.buildCommonAttributes(daemonConfig);
                String entityGuid = ServiceFactory.getRPMService().getEntityGuid();
                Agent.LOG.log(Level.INFO, "JFR Monitor obtained entity guid from agent: " + entityGuid);
                commonAttrs.put("entity.guid", entityGuid);
                JFRUploader uploader = SetupUtils.buildUploader(daemonConfig);
                String pattern = (String)this.defaultAgentConfig.getValue("thread_sampler.name_pattern", "((?<=[\\W_]|^)([0-9a-fA-F]){4,}(?=[\\W_]|$))|\\d+");
                uploader.readyToSend(new EventConverter(commonAttrs, pattern));
                this.jfrController = SetupUtils.buildJfrController(daemonConfig, uploader);
                ExecutorService jfrMonitorService = Executors.newSingleThreadExecutor();
                jfrMonitorService.submit(() -> {
                    try {
                        this.startJfrLoop();
                    }
                    catch (JfrRecorderException e) {
                        Agent.LOG.log(Level.INFO, "Error in JFR Monitor, shutting down", e);
                        this.jfrController.shutdown();
                    }
                });
            }
            catch (Throwable t2) {
                Agent.LOG.log(Level.INFO, "Unable to attach JFR Monitor", t2);
            }
        } else {
            NewRelic.getAgent().getMetricAggregator().incrementCounter("Supportability/JfrService/Started/Fail");
        }
    }

    void startJfrLoop() throws JfrRecorderException {
        this.jfrController.loop();
    }

    @Override
    public final boolean isEnabled() {
        boolean enabled = this.jfrConfig.isEnabled();
        boolean isHighSecurity = this.defaultAgentConfig.isHighSecurity();
        if (!enabled) {
            Agent.LOG.log(Level.INFO, "New Relic JFR Monitor is disabled: JFR config has not been enabled in the Java agent.");
        } else if (isHighSecurity) {
            Agent.LOG.log(Level.INFO, "New Relic JFR Monitor is enabled but High Security mode is also enabled; JFR will not be activated.");
        }
        return enabled && !isHighSecurity;
    }

    @Override
    protected void doStop() {
        NewRelic.getAgent().getMetricAggregator().incrementCounter("Supportability/JfrService/Stopped/Success");
        if (this.jfrController != null) {
            this.jfrController.shutdown();
        }
    }

    @VisibleForTesting
    boolean coreApisExist() {
        try {
            Class.forName("jdk.jfr.Recording");
            Class.forName("jdk.jfr.FlightRecorder");
        }
        catch (ClassNotFoundException __) {
            Agent.LOG.log(Level.WARNING, "Not starting JFR Service. Core JFR APIs do not exist in this JVM.");
            return false;
        }
        return true;
    }

    @VisibleForTesting
    DaemonConfig buildDaemonConfig() {
        DaemonConfig.Builder builder = DaemonConfig.builder().daemonVersion(VersionFinder.getVersion()).useLicenseKey(this.jfrConfig.useLicenseKey()).apiKey(this.defaultAgentConfig.getLicenseKey()).monitoredAppName(this.defaultAgentConfig.getApplicationName()).auditLogging(this.jfrConfig.auditLoggingEnabled()).metricsUri(URI.create(this.defaultAgentConfig.getMetricIngestUri())).eventsUri(URI.create(this.defaultAgentConfig.getEventIngestUri())).proxyHost(this.defaultAgentConfig.getProxyHost()).proxyScheme(this.defaultAgentConfig.getProxyScheme()).proxyPort(this.defaultAgentConfig.getProxyPort()).proxyUser(this.defaultAgentConfig.getProxyUser()).proxyPassword(this.defaultAgentConfig.getProxyPassword());
        return builder.build();
    }

    @Override
    public void configChanged(String appName, AgentConfig agentConfig) {
        boolean newJfrEnabledVal = agentConfig.getJfrConfig().isEnabled();
        if (newJfrEnabledVal != this.jfrConfig.isEnabled()) {
            Agent.LOG.log(Level.INFO, "JFR enabled flag changed to {0}", newJfrEnabledVal);
            this.jfrConfig.setEnabled(newJfrEnabledVal);
            if (newJfrEnabledVal) {
                this.doStart();
            } else {
                this.doStop();
            }
        }
    }
}

