/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.ApplicationLoggingConfig;
import com.newrelic.agent.config.ApplicationLoggingForwardingConfig;
import com.newrelic.agent.config.ApplicationLoggingLocalDecoratingConfig;
import com.newrelic.agent.config.ApplicationLoggingMetricsConfig;
import com.newrelic.agent.config.BaseConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ApplicationLoggingConfigImpl
extends BaseConfig
implements ApplicationLoggingConfig {
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.application_logging.";
    public static final String METRICS = "metrics";
    public static final String FORWARDING = "forwarding";
    public static final String LOCAL_DECORATING = "local_decorating";
    public static final boolean DEFAULT_ENABLED = true;
    public static final String ENABLED = "enabled";
    private final ApplicationLoggingMetricsConfig applicationLoggingMetricsConfig;
    private final ApplicationLoggingLocalDecoratingConfig applicationLoggingLocalDecoratingConfig;
    private final ApplicationLoggingForwardingConfig applicationLoggingForwardingConfig;
    private final boolean applicationLoggingEnabled = this.getProperty("enabled", true);

    public ApplicationLoggingConfigImpl(Map<String, Object> pProps, boolean highSecurity) {
        super(pProps, SYSTEM_PROPERTY_ROOT);
        this.applicationLoggingMetricsConfig = this.createApplicationLoggingMetricsConfig();
        this.applicationLoggingLocalDecoratingConfig = this.createApplicationLoggingLocalDecoratingConfig();
        this.applicationLoggingForwardingConfig = this.createApplicationLoggingForwardingConfig(highSecurity);
    }

    private ApplicationLoggingMetricsConfig createApplicationLoggingMetricsConfig() {
        Map<String, Object> metricsProps = this.getProperty(METRICS, Collections.emptyMap());
        return new ApplicationLoggingMetricsConfig(metricsProps, SYSTEM_PROPERTY_ROOT);
    }

    private ApplicationLoggingLocalDecoratingConfig createApplicationLoggingLocalDecoratingConfig() {
        Map<String, Object> localDecoratingProps = this.getProperty(LOCAL_DECORATING, Collections.emptyMap());
        return new ApplicationLoggingLocalDecoratingConfig(localDecoratingProps, SYSTEM_PROPERTY_ROOT);
    }

    private ApplicationLoggingForwardingConfig createApplicationLoggingForwardingConfig(boolean highSecurity) {
        Map<String, Object> forwardingProps = this.getProperty(FORWARDING, Collections.emptyMap());
        return new ApplicationLoggingForwardingConfig(forwardingProps, SYSTEM_PROPERTY_ROOT, highSecurity);
    }

    static ApplicationLoggingConfigImpl createApplicationLoggingConfig(Map<String, Object> settings, boolean highSecurity) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new ApplicationLoggingConfigImpl(settings, highSecurity);
    }

    @Override
    public boolean isEnabled() {
        return this.applicationLoggingEnabled;
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.applicationLoggingEnabled && this.applicationLoggingMetricsConfig.getEnabled();
    }

    @Override
    public boolean isLocalDecoratingEnabled() {
        return this.applicationLoggingEnabled && this.applicationLoggingLocalDecoratingConfig.getEnabled();
    }

    @Override
    public boolean isForwardingEnabled() {
        return this.applicationLoggingEnabled && this.applicationLoggingForwardingConfig.getEnabled();
    }

    @Override
    public int getMaxSamplesStored() {
        return this.applicationLoggingForwardingConfig.getMaxSamplesStored();
    }

    @Override
    public boolean isForwardingContextDataEnabled() {
        return this.applicationLoggingEnabled && this.applicationLoggingForwardingConfig.isContextDataEnabled();
    }

    @Override
    public List<String> getForwardingContextDataInclude() {
        return this.applicationLoggingForwardingConfig.contextDataInclude();
    }

    @Override
    public List<String> getForwardingContextDataExclude() {
        return this.applicationLoggingForwardingConfig.contextDataExclude();
    }
}

