/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.DebugFlag;
import com.newrelic.agent.config.AgentJarHelper;
import java.io.File;
import java.text.MessageFormat;

public class ConfigFileHelper {
    public static final String NEW_RELIC_YAML_FILE = "newrelic.yml";
    private static final String CONFIG_FILE_PROPERTY = "newrelic.config.file";
    private static final String NEW_RELIC_HOME_DIRECTORY_PROPERTY = "newrelic.home";
    private static final String NEW_RELIC_HOME_DIRECTORY_ENVIRONMENT_VARIABLE = "NEWRELIC_HOME";
    private static final String[] SEARCH_DIRECTORIES = new String[]{".", "conf", "config", "etc"};

    public static File findConfigFile() {
        File configFile = ConfigFileHelper.findFromProperty();
        if (configFile != null) {
            return configFile;
        }
        File parentDir = ConfigFileHelper.getNewRelicDirectory();
        if (parentDir != null && DebugFlag.DEBUG) {
            System.err.println(MessageFormat.format("New Relic home directory: {0}", parentDir));
        }
        if (parentDir != null && (configFile = ConfigFileHelper.findConfigFile(parentDir)) != null) {
            return configFile;
        }
        return ConfigFileHelper.findConfigFileInWorkingDirectory();
    }

    public static File getNewRelicDirectory() {
        File newRelicDir = ConfigFileHelper.findHomeDirectory();
        if (newRelicDir == null) {
            newRelicDir = AgentJarHelper.getAgentJarDirectory();
        }
        return newRelicDir;
    }

    private static File findFromProperty() {
        String filePath = System.getProperty(CONFIG_FILE_PROPERTY);
        if (filePath != null) {
            File configFile = new File(filePath);
            if (configFile.exists()) {
                return configFile;
            }
            System.err.println(MessageFormat.format("The configuration file {0} specified with the {1} property does not exist", configFile.getAbsolutePath(), CONFIG_FILE_PROPERTY));
        }
        return null;
    }

    private static File findHomeDirectory() {
        File homeDir = ConfigFileHelper.findHomeDirectoryFromProperty();
        if (homeDir != null) {
            return homeDir;
        }
        homeDir = ConfigFileHelper.findHomeDirectoryFromEnvironmentVariable();
        if (homeDir != null) {
            return homeDir;
        }
        return null;
    }

    private static File findHomeDirectoryFromProperty() {
        String filePath = System.getProperty(NEW_RELIC_HOME_DIRECTORY_PROPERTY);
        if (filePath != null) {
            File homeDir = new File(filePath);
            if (homeDir.exists()) {
                return homeDir;
            }
            System.err.println(MessageFormat.format("The directory {0} specified with the {1} property does not exist", homeDir.getAbsolutePath(), NEW_RELIC_HOME_DIRECTORY_PROPERTY));
        }
        return null;
    }

    private static File findHomeDirectoryFromEnvironmentVariable() {
        String filePath = System.getenv(NEW_RELIC_HOME_DIRECTORY_ENVIRONMENT_VARIABLE);
        if (filePath != null) {
            File homeDir = new File(filePath);
            if (homeDir.exists()) {
                return homeDir;
            }
            System.err.println(MessageFormat.format("The directory {0} specified with the {1} environment variable does not exist", homeDir.getAbsolutePath(), NEW_RELIC_HOME_DIRECTORY_ENVIRONMENT_VARIABLE));
        }
        return null;
    }

    private static File findConfigFile(File parentDirectory) {
        for (String searchDir : SEARCH_DIRECTORIES) {
            File configFile;
            File configDir = new File(parentDirectory, searchDir);
            if (DebugFlag.DEBUG) {
                System.err.println(MessageFormat.format("Searching for New Relic configuration in directory {0}", configDir));
            }
            if (!configDir.exists() || !(configFile = new File(configDir, NEW_RELIC_YAML_FILE)).exists()) continue;
            return configFile;
        }
        return null;
    }

    private static File findConfigFileInWorkingDirectory() {
        File configFile = new File(NEW_RELIC_YAML_FILE);
        if (configFile.exists()) {
            return configFile;
        }
        return null;
    }
}

