/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.attributes.AttributeValidator;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AttributesConfig;
import com.newrelic.agent.deps.com.google.common.base.Joiner;
import com.newrelic.agent.json.AttributeFilters;
import com.newrelic.agent.model.AttributeFilter;
import com.newrelic.agent.model.SpanCategory;
import com.newrelic.agent.model.SpanError;
import com.newrelic.agent.model.SpanEvent;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.ExternalsUtil;
import com.newrelic.agent.util.StackTraces;
import com.newrelic.api.agent.DatastoreParameters;
import com.newrelic.api.agent.ExternalParameters;
import com.newrelic.api.agent.HttpParameters;
import com.newrelic.api.agent.MessageConsumeParameters;
import com.newrelic.api.agent.MessageProduceParameters;
import com.newrelic.api.agent.SlowQueryDatastoreParameters;
import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class SpanEventFactory {
    private static final Joiner TRACE_STATE_VENDOR_JOINER = Joiner.on(",");
    private static final int DB_STATEMENT_TRUNCATE_LENGTH = 4095;
    private static final int MAX_EVENT_ATTRIBUTE_STRING_LENGTH = 4095;
    public static final Supplier<Long> DEFAULT_SYSTEM_TIMESTAMP_SUPPLIER = System::currentTimeMillis;
    private final SpanEvent.Builder builder = SpanEvent.builder();
    private final String appName;
    private final AttributeFilter filter;
    private final Supplier<Long> timestampSupplier;

    public SpanEventFactory(String appName, AttributeFilter filter, Supplier<Long> timestampSupplier) {
        this.filter = filter;
        this.builder.putIntrinsic("type", "Span");
        this.builder.putIntrinsic("category", SpanCategory.generic.name());
        this.appName = appName;
        this.timestampSupplier = timestampSupplier;
        this.builder.appName(appName);
    }

    public SpanEventFactory(String appName) {
        this(appName, AttributeFilters.SPAN_EVENTS_ATTRIBUTE_FILTER, DEFAULT_SYSTEM_TIMESTAMP_SUPPLIER);
    }

    public SpanEventFactory setPriority(float priority) {
        this.builder.priority(priority);
        this.builder.putIntrinsic("priority", Float.valueOf(priority));
        return this;
    }

    public SpanEventFactory setParentType(String parentType) {
        this.builder.putIntrinsic("parent.type", parentType);
        return this;
    }

    public SpanEventFactory setParentId(String parentId) {
        this.builder.putIntrinsic("parentId", parentId);
        return this;
    }

    public SpanEventFactory setGuid(String guid) {
        this.builder.putIntrinsic("guid", guid);
        return this;
    }

    public SpanEventFactory setTraceId(String traceId) {
        this.builder.putIntrinsic("traceId", traceId);
        return this;
    }

    public SpanEventFactory setSampled(boolean sampled) {
        this.builder.putIntrinsic("sampled", sampled);
        return this;
    }

    public SpanEventFactory setDurationInSeconds(float duration) {
        this.builder.putIntrinsic("duration", Float.valueOf(duration));
        return this;
    }

    public SpanEventFactory setName(String name) {
        this.builder.putIntrinsic("name", name);
        return this;
    }

    public SpanEventFactory setUserAttributes(Map<String, ?> userAttributes) {
        this.builder.putAllUserAttributes(this.filter.filterUserAttributes(this.appName, userAttributes));
        return this;
    }

    public SpanEventFactory putAllAgentAttributes(Map<String, ?> agentAttributes) {
        if (agentAttributes == null || agentAttributes.isEmpty()) {
            return this;
        }
        this.builder.putAllAgentAttributes(this.filter.filterAgentAttributes(this.appName, agentAttributes));
        return this;
    }

    public SpanEventFactory setStackTraceAttributes(Map<String, Object> agentAttributes) {
        List stackTraceList;
        if (this.builder.isClientSpan() && (stackTraceList = (List)agentAttributes.get("backtrace")) != null) {
            List<StackTraceElement> preStackTraces = StackTraces.scrubAndTruncate(stackTraceList);
            List<String> postParentRemovalTrace = StackTraces.toStringList(preStackTraces);
            this.putAgentAttribute("code.stacktrace", this.truncateWithEllipsis(Joiner.on(',').join(postParentRemovalTrace), 4095));
        }
        return this;
    }

    public SpanEventFactory setClmAttributes(Map<String, Object> agentAttributes) {
        if (agentAttributes == null || agentAttributes.isEmpty()) {
            return this;
        }
        Object threadId = agentAttributes.get("thread.id");
        if (threadId != null) {
            this.builder.putIntrinsic("thread.id", threadId);
        }
        if (agentAttributes.containsKey("code.namespace") && agentAttributes.containsKey("code.function")) {
            this.builder.putAgentAttribute("code.namespace", agentAttributes.get("code.namespace"));
            this.builder.putAgentAttribute("code.function", agentAttributes.get("code.function"));
        }
        return this;
    }

    public SpanEventFactory putAllUserAttributes(Map<String, ?> userAttributes) {
        userAttributes = this.filter.filterUserAttributes(this.appName, userAttributes);
        this.builder.putAllUserAttributes(userAttributes);
        return this;
    }

    public SpanEventFactory putAllUserAttributesIfAbsent(Map<String, ?> userAttributes) {
        this.builder.putAllUserAttributesIfAbsent(this.filter.filterUserAttributes(this.appName, userAttributes));
        return this;
    }

    public SpanEventFactory putAgentAttribute(String key, Object value) {
        this.builder.putAgentAttribute(key, value);
        return this;
    }

    public SpanEventFactory putIntrinsicAttribute(String key, Object value) {
        this.builder.putIntrinsic(key, value);
        return this;
    }

    public SpanEventFactory setTransactionId(String rootId) {
        this.builder.putIntrinsic("transactionId", rootId);
        return this;
    }

    public SpanEventFactory setTimestamp(long startTime) {
        this.builder.putIntrinsic("timestamp", startTime);
        return this;
    }

    public SpanEventFactory setCategory(SpanCategory category) {
        if (category != null) {
            this.builder.putIntrinsic("category", category.name());
        }
        return this;
    }

    public SpanEventFactory setKindFromUserAttributes() {
        this.builder.spanKind(this.builder.getSpanKindFromUserAttributes());
        return this;
    }

    public SpanEventFactory setUri(URI uri) {
        URI sanitizedURI;
        if (uri == null) {
            return this;
        }
        if (this.filter.shouldIncludeAgentAttribute(this.appName, "http.url") && (sanitizedURI = ExternalsUtil.sanitizeURI(uri)) != null) {
            this.builder.putAgentAttribute("http.url", sanitizedURI.toString());
            this.setServerAddress(sanitizedURI.getHost());
            if (sanitizedURI.getPort() > 0) {
                this.setServerPort(sanitizedURI.getPort());
            }
        }
        return this;
    }

    public SpanEventFactory setHttpMethod(String method) {
        if (this.filter.shouldIncludeAgentAttribute(this.appName, "http.method")) {
            this.builder.putAgentAttribute("http.method", method);
        }
        return this;
    }

    public SpanEventFactory setHttpComponent(String component) {
        this.builder.putIntrinsic("component", component);
        return this;
    }

    public SpanEventFactory setHttpStatusCode(Integer statusCode) {
        AttributesConfig attributesConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getAttributesConfig();
        if (attributesConfig.isStandardHttpAttr() && this.filter.shouldIncludeAgentAttribute(this.appName, "http.statusCode")) {
            this.builder.putAgentAttribute("http.statusCode", statusCode);
        }
        if (attributesConfig.isLegacyHttpAttr() && this.filter.shouldIncludeAgentAttribute(this.appName, "httpResponseCode")) {
            this.builder.putAgentAttribute("httpResponseCode", statusCode);
        }
        return this;
    }

    public SpanEventFactory setHttpStatusText(String statusText) {
        AttributesConfig attributesConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getAttributesConfig();
        if (attributesConfig.isStandardHttpAttr() && this.filter.shouldIncludeAgentAttribute(this.appName, "http.statusText")) {
            this.builder.putAgentAttribute("http.statusText", statusText);
        }
        if (attributesConfig.isLegacyHttpAttr() && this.filter.shouldIncludeAgentAttribute(this.appName, "httpResponseMessage")) {
            this.builder.putAgentAttribute("httpResponseMessage", statusText);
        }
        return this;
    }

    public SpanEventFactory setDatabaseName(String databaseName) {
        this.builder.putAgentAttribute("db.instance", databaseName);
        return this;
    }

    public SpanEventFactory setDatastoreComponent(String component) {
        this.builder.putAgentAttribute("db.system", component);
        return this;
    }

    public SpanEventFactory setAddress(String hostName, String portPathOrId) {
        if (portPathOrId != null && hostName != null) {
            String address = MessageFormat.format("{0}:{1}", hostName, portPathOrId);
            this.builder.putAgentAttribute("peer.address", address);
        }
        return this;
    }

    public SpanEventFactory setServerAddress(String host) {
        this.builder.putAgentAttribute("server.address", host);
        this.builder.putAgentAttribute("peer.hostname", host);
        return this;
    }

    public SpanEventFactory setCloudAccountId(String cloudAccountId) {
        this.builder.putAgentAttribute("cloud.account.id", cloudAccountId);
        return this;
    }

    public SpanEventFactory setCloudRegion(String region) {
        this.builder.putAgentAttribute("cloud.region", region);
        return this;
    }

    public SpanEventFactory setMessagingSystem(String messagingSystem) {
        this.builder.putAgentAttribute("messaging.system", messagingSystem);
        return this;
    }

    public SpanEventFactory setMessagingDestination(String messagingDestination) {
        this.builder.putAgentAttribute("messaging.destination.name", messagingDestination);
        return this;
    }

    public SpanEventFactory setServerPort(int port) {
        this.builder.putAgentAttribute("server.port", port);
        return this;
    }

    public SpanEventFactory setDatabaseStatement(String query) {
        if (query != null) {
            this.builder.putAgentAttribute("db.statement", this.truncateWithEllipsis(query, 4095));
        }
        return this;
    }

    private SpanEventFactory setDatabaseCollection(String collection) {
        this.builder.putAgentAttribute("db.collection", collection);
        return this;
    }

    private SpanEventFactory setDatabaseOperation(String operation) {
        this.builder.putAgentAttribute("db.operation", operation);
        return this;
    }

    private String truncateWithEllipsis(String value, int maxLengthWithEllipsis) {
        if (value.length() > maxLengthWithEllipsis) {
            int maxLengthWithoutEllipsis = maxLengthWithEllipsis - 3;
            return AttributeValidator.truncateString(value, maxLengthWithoutEllipsis) + "...";
        }
        return value;
    }

    public SpanEventFactory setDecider(boolean decider) {
        this.builder.decider(decider);
        return this;
    }

    private void setErrorClass(Class<?> throwableClass, Integer errorStatus) {
        if (this.filter.shouldIncludeAgentAttribute(this.appName, "error.class")) {
            if (throwableClass != null) {
                this.builder.putAgentAttribute("error.class", throwableClass.getName());
            } else if (errorStatus != null) {
                this.builder.putAgentAttribute("error.class", errorStatus.toString());
            }
        }
    }

    private void setErrorMessage(String message) {
        if (this.filter.shouldIncludeAgentAttribute(this.appName, "error.message") && message != null && message.length() > 0) {
            this.builder.putAgentAttribute("error.message", message);
        }
    }

    private void setExpectedError(boolean expectedError) {
        if (this.filter.shouldIncludeAgentAttribute(this.appName, "error.expected") && expectedError) {
            this.builder.putAgentAttribute("error.expected", true);
        }
    }

    public SpanEventFactory setSpanError(SpanError spanError) {
        this.setExpectedError(spanError.isExpectedError());
        this.setErrorMessage(spanError.getErrorMessage());
        this.setErrorClass(spanError.getErrorClass(), spanError.getErrorStatus());
        return this;
    }

    public SpanEventFactory setIsRootSpanEvent(boolean isRoot) {
        if (isRoot) {
            this.builder.putIntrinsic("nr.entryPoint", true);
        }
        return this;
    }

    public SpanEventFactory setTrustedParent(String closestParent) {
        this.builder.putIntrinsic("trustedParentId", closestParent);
        return this;
    }

    public SpanEventFactory setTracingVendors(Set<String> stateVendorKeys) {
        if (stateVendorKeys != null && !stateVendorKeys.isEmpty()) {
            this.builder.putIntrinsic("tracingVendors", TRACE_STATE_VENDOR_JOINER.join(stateVendorKeys));
        }
        return this;
    }

    public SpanEventFactory setExternalParameterAttributes(ExternalParameters parameters) {
        if (parameters instanceof HttpParameters) {
            HttpParameters httpParameters = (HttpParameters)parameters;
            this.setCategory(SpanCategory.http);
            this.setUri(httpParameters.getUri());
            this.setHttpMethod(httpParameters.getProcedure());
            this.setHttpStatusCode(httpParameters.getStatusCode());
            this.setHttpStatusText(httpParameters.getStatusText());
            this.setHttpComponent(httpParameters.getLibrary());
            this.setKindFromUserAttributes();
        } else if (parameters instanceof DatastoreParameters) {
            DatastoreParameters datastoreParameters = (DatastoreParameters)parameters;
            this.setCategory(SpanCategory.datastore);
            this.setDatastoreComponent(datastoreParameters.getProduct());
            this.setDatabaseName(datastoreParameters.getDatabaseName());
            this.setDatabaseCollection(datastoreParameters.getCollection());
            this.setDatabaseOperation(datastoreParameters.getOperation());
            this.setServerAddress(datastoreParameters.getHost());
            this.setKindFromUserAttributes();
            if (datastoreParameters.getPort() != null) {
                this.setServerPort(datastoreParameters.getPort());
            }
            if (datastoreParameters instanceof SlowQueryDatastoreParameters) {
                SlowQueryDatastoreParameters queryDatastoreParameters = (SlowQueryDatastoreParameters)datastoreParameters;
                this.setDatabaseStatement(this.determineObfuscationLevel(queryDatastoreParameters));
            }
            if (datastoreParameters.getPort() != null) {
                this.setAddress(datastoreParameters.getHost(), String.valueOf(datastoreParameters.getPort()));
            } else {
                this.setAddress(datastoreParameters.getHost(), datastoreParameters.getPathOrId());
            }
        } else if (parameters instanceof MessageProduceParameters) {
            MessageProduceParameters messageProduceParameters = (MessageProduceParameters)parameters;
            this.setCategory(SpanCategory.generic);
            this.setCloudAccountId(messageProduceParameters.getCloudAccountId());
            this.setCloudRegion(messageProduceParameters.getCloudRegion());
            this.setMessagingSystem(messageProduceParameters.getOtelLibrary());
            this.setMessagingDestination(messageProduceParameters.getDestinationName());
        } else if (parameters instanceof MessageConsumeParameters) {
            MessageConsumeParameters messageConsumeParameters = (MessageConsumeParameters)parameters;
            this.setCategory(SpanCategory.generic);
            this.setCloudAccountId(messageConsumeParameters.getCloudAccountId());
            this.setCloudRegion(messageConsumeParameters.getCloudRegion());
            this.setMessagingSystem(messageConsumeParameters.getOtelLibrary());
            this.setMessagingDestination(messageConsumeParameters.getDestinationName());
        } else {
            this.setCategory(SpanCategory.generic);
        }
        return this;
    }

    private <T> String determineObfuscationLevel(SlowQueryDatastoreParameters<T> slowQueryDatastoreParameters) {
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        if (config.isHighSecurity() || config.getTransactionTracerConfig().getRecordSql().equals("off")) {
            return null;
        }
        if (config.getTransactionTracerConfig().getRecordSql().equals("raw")) {
            return slowQueryDatastoreParameters.getQueryConverter().toRawQueryString(slowQueryDatastoreParameters.getRawQuery());
        }
        return slowQueryDatastoreParameters.getQueryConverter().toObfuscatedQueryString(slowQueryDatastoreParameters.getRawQuery());
    }

    public SpanEvent build() {
        this.builder.timestamp(this.timestampSupplier.get());
        return this.builder.build();
    }
}

