/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracing;

import com.newrelic.agent.Agent;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracing.W3CTraceParent;
import com.newrelic.agent.tracing.W3CTraceParentValidator;
import java.util.List;
import java.util.logging.Level;

public class W3CTraceParentParser {
    static W3CTraceParent parseHeaders(List<String> traceParentHeaders) {
        if (traceParentHeaders.isEmpty()) {
            return null;
        }
        if (traceParentHeaders.size() > 1) {
            ServiceFactory.getStatsService().getMetricAggregator().incrementCounter("Supportability/TraceContext/TraceParent/Ignored/Multiple");
            Agent.LOG.log(Level.WARNING, "Multiple traceparent headers found on inbound request.");
            String first = traceParentHeaders.get(0);
            for (String header : traceParentHeaders) {
                if (header.equals(first)) continue;
                return null;
            }
        }
        String traceParentHeader = traceParentHeaders.get(0);
        return W3CTraceParentParser.parseHeader(traceParentHeader);
    }

    static W3CTraceParent parseHeader(String traceParentHeader) {
        String[] traceParentFields = traceParentHeader.split("-");
        if (traceParentFields.length < 4) {
            ServiceFactory.getStatsService().getMetricAggregator().incrementCounter("Supportability/TraceContext/TraceParent/Ignored/InvalidFieldCount");
            return null;
        }
        String version = traceParentFields[0];
        String traceId = traceParentFields[1];
        String parentId = traceParentFields[2];
        String unparsedFlags = traceParentFields[3];
        boolean valid = W3CTraceParentValidator.forHeader(traceParentHeader).version(version).traceId(traceId).parentId(parentId).flags(unparsedFlags).isValid();
        if (!valid) {
            ServiceFactory.getStatsService().getMetricAggregator().incrementCounter("Supportability/TraceContext/TraceParent/Ignored/Invalid");
            return null;
        }
        int flags = Integer.parseInt(unparsedFlags, 16);
        return new W3CTraceParent(version, traceId, parentId, flags);
    }
}

