/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.config.UtilizationDataConfig;
import com.newrelic.agent.service.ServiceFactory;

public class UtilizationConfig {
    public static final UtilizationConfig EMPTY_DATA = new UtilizationConfig(null, null, null);
    private final String hostname;
    private final Integer logicalProcessors;
    private final Long totalRamMib;

    public static UtilizationConfig createFromConfigService() {
        UtilizationDataConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getUtilizationDataConfig();
        return new UtilizationConfig(agentConfig.getBillingHostname(), agentConfig.getLogicalProcessorsConfig(), agentConfig.getTotalRamMibConfig());
    }

    protected UtilizationConfig(String name, Integer processorCt, Long ram) {
        this.hostname = name;
        this.logicalProcessors = processorCt;
        this.totalRamMib = ram;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getLogicalProcessors() {
        return this.logicalProcessors;
    }

    public Long getTotalRamMib() {
        return this.totalRamMib;
    }
}

