/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.bootstrap;

import com.newrelic.agent.config.IBMUtils;
import com.newrelic.agent.config.JavaVersionUtils;
import com.newrelic.agent.config.JbossUtils;
import com.newrelic.agent.modules.ClassLoaderUtilImpl;
import com.newrelic.agent.modules.HttpModuleUtilImpl;
import com.newrelic.agent.modules.ModuleUtilImpl;
import com.newrelic.bootstrap.BootstrapLoader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.Collection;
import java.util.zip.InflaterInputStream;

public class BootstrapAgent {
    public static final String TRY_IBM_ATTACH_SYSTEM_PROPERTY = "newrelic.try_ibm_attach";
    public static final String NR_AGENT_ARGS_SYSTEM_PROPERTY = "nr-internal-agent-args";
    private static final String AGENT_CLASS_NAME = "com.newrelic.agent.Agent";
    private static final String JAVA_LOG_MANAGER = "java.util.logging.manager";
    private static final String WS_SERVER_JAR = "ws-server.jar";
    private static final String WS_LOG_MANAGER = "com.ibm.ws.kernel.boot.logging.WsLogManager";
    private static final String AGENT_ENABLED_ENV_VAR = "NEW_RELIC_AGENT_ENABLED";
    private static final String AGENT_ENABLED_SYS_PROP = "newrelic.config.agent_enabled";

    public static URL getAgentJarUrl() {
        return BootstrapAgent.class.getProtectionDomain().getCodeSource().getLocation();
    }

    public static void main(String[] args2) {
        try {
            Collection<URL> urls2 = BootstrapLoader.getJarURLs();
            urls2.add(BootstrapAgent.getAgentJarUrl());
            URLClassLoader classLoader = new URLClassLoader(urls2.toArray(new URL[0]), null);
            Class<?> agentClass = classLoader.loadClass(AGENT_CLASS_NAME);
            Method main = agentClass.getDeclaredMethod("main", String[].class);
            main.invoke(null, new Object[]{args2});
        }
        catch (Throwable t2) {
            System.err.println(MessageFormat.format("Error invoking the New Relic command: {0}", t2));
            t2.printStackTrace();
        }
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        if (agentArgs == null || agentArgs.isEmpty()) {
            throw new IllegalArgumentException("Unable to attach. The license key was not specified");
        }
        System.out.println("Attaching the New Relic java agent");
        MessageFormat.format("{0}", 1.0);
        try {
            agentArgs = BootstrapAgent.decodeAndDecompressAgentArguments(agentArgs);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        System.setProperty(NR_AGENT_ARGS_SYSTEM_PROPERTY, agentArgs);
        BootstrapAgent.premain(agentArgs, inst);
    }

    static String decodeAndDecompressAgentArguments(String agentArgs) throws IOException {
        byte[] decodeBase64 = Base64.getDecoder().decode(agentArgs);
        InflaterInputStream zipStream = new InflaterInputStream(new ByteArrayInputStream(decodeBase64));
        return new BufferedReader(new InputStreamReader(zipStream)).readLine();
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        String javaSpecVersion = JavaVersionUtils.getJavaSpecificationVersion();
        if (BootstrapAgent.useExperimentalRuntime()) {
            BootstrapAgent.printExperimentalRuntimeModeInUseMessage(javaSpecVersion);
        }
        if (!JavaVersionUtils.isAgentSupportedJavaSpecVersion(javaSpecVersion) && !BootstrapAgent.useExperimentalRuntime()) {
            BootstrapAgent.printUnsupportedJavaVersionMessage(javaSpecVersion);
            return;
        }
        if (BootstrapAgent.agentIsDisabledBySystemPropertyOrEnvVar()) {
            BootstrapAgent.printAgentIsDisabledBySysPropOrEnvVar();
            return;
        }
        BootstrapAgent.checkAndApplyIBMLibertyProfileLogManagerWorkaround();
        new JbossUtils().checkAndApplyJbossAdjustments(inst);
        BootstrapAgent.startAgent(agentArgs, inst);
    }

    private static void checkAndApplyIBMLibertyProfileLogManagerWorkaround() {
        String javaClassPath;
        if (IBMUtils.isIbmJVM() && (javaClassPath = System.getProperty("java.class.path")) != null && javaClassPath.contains(WS_SERVER_JAR) && System.getProperty(JAVA_LOG_MANAGER) == null) {
            try {
                Class.forName(WS_LOG_MANAGER, false, BootstrapAgent.class.getClassLoader());
                System.setProperty(JAVA_LOG_MANAGER, WS_LOG_MANAGER);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void startAgent(String agentArgs, Instrumentation inst) {
        try {
            URL[] codeSource;
            long startTime = System.currentTimeMillis();
            String javaVersion = System.getProperty("java.version", "");
            BootstrapLoader.load(inst, BootstrapAgent.isJavaSqlLoadedOnPlatformClassLoader(javaVersion));
            ClassLoader agentClassLoaderParent = BootstrapAgent.getPlatformClassLoaderOrNull();
            if (BootstrapAgent.isJavaSqlLoadedOnPlatformClassLoader(javaVersion)) {
                URL url = BootstrapLoader.getDatastoreJarURL();
                codeSource = new URL[]{BootstrapAgent.getAgentJarUrl(), url};
            } else {
                codeSource = new URL[]{BootstrapAgent.getAgentJarUrl()};
            }
            JVMAgentClassLoader classLoader = new JVMAgentClassLoader(codeSource, agentClassLoaderParent);
            BootstrapAgent.redefineJavaBaseModule(inst, classLoader);
            BootstrapAgent.addReadUnnamedModuleToHttpModule(inst, agentClassLoaderParent);
            Class<?> agentClass = classLoader.loadClass(AGENT_CLASS_NAME);
            Method continuePremain = agentClass.getDeclaredMethod("continuePremain", String.class, Instrumentation.class, Long.TYPE);
            continuePremain.invoke(null, agentArgs, inst, startTime);
        }
        catch (Throwable t2) {
            System.err.println(MessageFormat.format("Error bootstrapping New Relic agent: {0}", t2));
            t2.printStackTrace();
        }
    }

    private static ClassLoader getPlatformClassLoaderOrNull() {
        try {
            ClassLoaderUtilImpl util = new ClassLoaderUtilImpl();
            return util.getPlatformClassLoaderOrNull();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static void redefineJavaBaseModule(Instrumentation inst, ClassLoader agentClassLoader) {
        try {
            ModuleUtilImpl util = new ModuleUtilImpl();
            util.redefineJavaBaseModule(inst, agentClassLoader);
        }
        catch (Throwable t2) {
            System.err.println("The agent failed to redefine modules as necessary. " + t2);
        }
    }

    private static void addReadUnnamedModuleToHttpModule(Instrumentation inst, ClassLoader platformClassLoader) {
        try {
            HttpModuleUtilImpl util = new HttpModuleUtilImpl();
            util.addReadHttpModule(inst, platformClassLoader);
        }
        catch (Throwable t2) {
            System.err.println("The agent failed to redefine modules as necessary. " + t2);
        }
    }

    private static boolean isJavaSqlLoadedOnPlatformClassLoader(String javaVersion) {
        return !javaVersion.startsWith("1.");
    }

    private static boolean agentIsDisabledBySystemPropertyOrEnvVar() {
        String sysVal = System.getProperty(AGENT_ENABLED_SYS_PROP);
        String envVal = System.getenv(AGENT_ENABLED_ENV_VAR);
        return sysVal != null && !Boolean.parseBoolean(sysVal) || envVal != null && !Boolean.parseBoolean(envVal);
    }

    private static void printAgentIsDisabledBySysPropOrEnvVar() {
        System.err.println("----------");
        System.err.println(MessageFormat.format("New Relic Agent is disabled by {0} system property or {1} environment variable.", AGENT_ENABLED_SYS_PROP, AGENT_ENABLED_ENV_VAR));
        System.err.println("----------");
    }

    private static boolean useExperimentalRuntime() {
        return Boolean.parseBoolean(System.getProperty("newrelic.config.experimental_runtime")) || Boolean.parseBoolean(System.getenv("NEW_RELIC_EXPERIMENTAL_RUNTIME"));
    }

    private static void printExperimentalRuntimeModeInUseMessage(String javaSpecVersion) {
        System.out.println("----------");
        System.out.println(JavaVersionUtils.getUnsupportedAgentJavaSpecVersionMessage(javaSpecVersion));
        System.out.println("Experimental runtime mode is enabled. Usage of the agent in this mode is for experimenting with early access or upcoming Java releases at your own risk.");
        System.out.println("----------");
    }

    private static void printUnsupportedJavaVersionMessage(String javaSpecVersion) {
        System.err.println("----------");
        System.err.println(JavaVersionUtils.getUnsupportedAgentJavaSpecVersionMessage(javaSpecVersion));
        System.err.println("----------");
    }

    private static class JVMAgentClassLoader
    extends URLClassLoader {
        public JVMAgentClassLoader(URL[] urls2, ClassLoader parent) {
            super(urls2, parent);
        }

        static {
            try {
                JVMAgentClassLoader.registerAsParallelCapable();
            }
            catch (Throwable t2) {
                System.err.println(MessageFormat.format("Unable to register as parallel-capable: {0}", t2));
            }
        }
    }
}

