/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.config.Hostname;
import com.newrelic.api.agent.TraceMetadata;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class AgentLinkingMetadata {
    public static final String ENTITY_TYPE_DEFAULT = "SERVICE";
    public static final String LOCALHOST = "localhost";
    public static final String TRACE_ID = "trace.id";
    public static final String SPAN_ID = "span.id";
    public static final String HOSTNAME = "hostname";
    public static final String ENTITY_GUID = "entity.guid";
    public static final String ENTITY_NAME = "entity.name";
    public static final String ENTITY_TYPE = "entity.type";

    public static Map<String, String> getLinkingMetadata(TraceMetadata traceMetadata, ConfigService configService, IRPMService rpmService) {
        AgentConfig agentConfig = configService.getDefaultAgentConfig();
        ConcurrentHashMap<String, String> linkingMetadata = new ConcurrentHashMap<String, String>();
        linkingMetadata.put(TRACE_ID, AgentLinkingMetadata.getTraceId(traceMetadata));
        linkingMetadata.put(SPAN_ID, AgentLinkingMetadata.getSpanId(traceMetadata));
        linkingMetadata.put(HOSTNAME, AgentLinkingMetadata.getHostname(agentConfig));
        linkingMetadata.put(ENTITY_NAME, AgentLinkingMetadata.getEntityName(agentConfig));
        linkingMetadata.put(ENTITY_TYPE, AgentLinkingMetadata.getEntityType());
        try {
            String entityGuid = AgentLinkingMetadata.getEntityGuid(rpmService);
            if (!entityGuid.isEmpty()) {
                linkingMetadata.put(ENTITY_GUID, entityGuid);
            }
        }
        catch (NullPointerException ignored) {
            AgentLinkingMetadata.logWarning();
        }
        return linkingMetadata;
    }

    public static Map<String, String> getLogEventLinkingMetadata(TraceMetadata traceMetadata, ConfigService configService, IRPMService rpmService) {
        String entityName;
        String hostname;
        String spanId;
        AgentConfig agentConfig = configService.getDefaultAgentConfig();
        ConcurrentHashMap<String, String> logEventLinkingMetadata = new ConcurrentHashMap<String, String>();
        String traceId = AgentLinkingMetadata.getTraceId(traceMetadata);
        if (!traceId.isEmpty()) {
            logEventLinkingMetadata.put(TRACE_ID, traceId);
        }
        if (!(spanId = AgentLinkingMetadata.getSpanId(traceMetadata)).isEmpty()) {
            logEventLinkingMetadata.put(SPAN_ID, spanId);
        }
        if (!(hostname = AgentLinkingMetadata.getHostname(agentConfig)).isEmpty()) {
            logEventLinkingMetadata.put(HOSTNAME, hostname);
        }
        if (!(entityName = AgentLinkingMetadata.getEntityName(agentConfig)).isEmpty()) {
            logEventLinkingMetadata.put(ENTITY_NAME, entityName);
        }
        try {
            String entityGuid = rpmService.getEntityGuid();
            if (!entityGuid.isEmpty()) {
                logEventLinkingMetadata.put(ENTITY_GUID, entityGuid);
            }
        }
        catch (NullPointerException ignored) {
            AgentLinkingMetadata.logWarning();
        }
        return logEventLinkingMetadata;
    }

    public static String getTraceId(TraceMetadata traceMetadata) {
        return traceMetadata.getTraceId();
    }

    public static String getSpanId(TraceMetadata traceMetadata) {
        return traceMetadata.getSpanId();
    }

    private static String getHostname(AgentConfig agentConfig) {
        String fullHostname = Hostname.getFullHostname(agentConfig);
        if (fullHostname == null || fullHostname.isEmpty() || fullHostname.equals(LOCALHOST)) {
            return Hostname.getHostname(agentConfig);
        }
        return fullHostname;
    }

    public static String getEntityName(AgentConfig agentConfig) {
        return agentConfig.getApplicationName();
    }

    public static String getEntityType() {
        return ENTITY_TYPE_DEFAULT;
    }

    public static String getEntityGuid(IRPMService rpmService) {
        return rpmService.getEntityGuid();
    }

    private static void logWarning() {
        Agent.LOG.log(Level.WARNING, "Cannot get entity.guid from getLinkingMetadata() until RPMService has initialized.");
    }
}

