/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.ObscuredYamlPropertyWrapper;
import com.newrelic.agent.config.ObscuringKeyConfig;
import com.newrelic.agent.config.internal.DeepMapClone;
import com.newrelic.agent.deps.com.google.common.base.Function;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class ObscuringConfig
extends BaseConfig {
    public static final String OBSCURING_CONFIG = "config";
    static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.config.";
    private final ObscuringKeyConfig obscuringKeyConfig;
    private final Map<String, Object> obscureConfigProps = (Map)this.getProperty("config");

    public ObscuringConfig(Map<String, Object> props, String systemPropertyRoot) {
        super(props, systemPropertyRoot);
        this.obscuringKeyConfig = this.createObscuringKeyConfig();
    }

    public ObscuringKeyConfig createObscuringKeyConfig() {
        return new ObscuringKeyConfig(this.obscureConfigProps, SYSTEM_PROPERTY_ROOT);
    }

    public Map<String, Object> getDeobscuredProperties() {
        return DeepMapClone.deepCopy(Maps.transformValues(this.getProperties(), new Deobscurer()));
    }

    private class Deobscurer
    implements Function<Object, Object> {
        private Deobscurer() {
        }

        @Override
        public Object apply(Object input) {
            if (input instanceof ObscuredYamlPropertyWrapper) {
                String obscuringKey = ObscuringConfig.this.obscuringKeyConfig.getObscuringKey();
                if (obscuringKey != null) {
                    return ((ObscuredYamlPropertyWrapper)input).getValue(obscuringKey);
                }
                throw new RuntimeException("Unable to deobfuscate value. Missing a obscuring key");
            }
            if (input instanceof Map) {
                return Maps.transformValues((Map)input, this);
            }
            if (input instanceof List) {
                return Lists.transform((List)input, this);
            }
            return input;
        }
    }
}

