/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.io.grpc.okhttp;

import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.com.google.common.base.Preconditions;
import com.newrelic.agent.deps.io.grpc.CallCredentials;
import com.newrelic.agent.deps.io.grpc.ChannelCredentials;
import com.newrelic.agent.deps.io.grpc.ChannelLogger;
import com.newrelic.agent.deps.io.grpc.ChoiceChannelCredentials;
import com.newrelic.agent.deps.io.grpc.CompositeCallCredentials;
import com.newrelic.agent.deps.io.grpc.CompositeChannelCredentials;
import com.newrelic.agent.deps.io.grpc.ExperimentalApi;
import com.newrelic.agent.deps.io.grpc.InsecureChannelCredentials;
import com.newrelic.agent.deps.io.grpc.Internal;
import com.newrelic.agent.deps.io.grpc.ManagedChannelBuilder;
import com.newrelic.agent.deps.io.grpc.TlsChannelCredentials;
import com.newrelic.agent.deps.io.grpc.internal.AbstractManagedChannelImplBuilder;
import com.newrelic.agent.deps.io.grpc.internal.AtomicBackoff;
import com.newrelic.agent.deps.io.grpc.internal.ClientTransportFactory;
import com.newrelic.agent.deps.io.grpc.internal.ConnectionClientTransport;
import com.newrelic.agent.deps.io.grpc.internal.FixedObjectPool;
import com.newrelic.agent.deps.io.grpc.internal.GrpcUtil;
import com.newrelic.agent.deps.io.grpc.internal.KeepAliveManager;
import com.newrelic.agent.deps.io.grpc.internal.ManagedChannelImplBuilder;
import com.newrelic.agent.deps.io.grpc.internal.ObjectPool;
import com.newrelic.agent.deps.io.grpc.internal.SharedResourceHolder;
import com.newrelic.agent.deps.io.grpc.internal.SharedResourcePool;
import com.newrelic.agent.deps.io.grpc.internal.TransportTracer;
import com.newrelic.agent.deps.io.grpc.okhttp.OkHttpClientTransport;
import com.newrelic.agent.deps.io.grpc.okhttp.SslSocketFactoryChannelCredentials;
import com.newrelic.agent.deps.io.grpc.okhttp.Utils;
import com.newrelic.agent.deps.io.grpc.okhttp.internal.CipherSuite;
import com.newrelic.agent.deps.io.grpc.okhttp.internal.ConnectionSpec;
import com.newrelic.agent.deps.io.grpc.okhttp.internal.Platform;
import com.newrelic.agent.deps.io.grpc.okhttp.internal.TlsVersion;
import com.newrelic.agent.deps.io.grpc.util.CertificateUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1785")
public final class OkHttpChannelBuilder
extends AbstractManagedChannelImplBuilder<OkHttpChannelBuilder> {
    private static final Logger log;
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 65535;
    private final ManagedChannelImplBuilder managedChannelImplBuilder;
    private TransportTracer.Factory transportTracerFactory = TransportTracer.getDefaultFactory();
    static final ConnectionSpec INTERNAL_DEFAULT_CONNECTION_SPEC;
    private static final long AS_LARGE_AS_INFINITE;
    private static final SharedResourceHolder.Resource<Executor> SHARED_EXECUTOR;
    static final ObjectPool<Executor> DEFAULT_TRANSPORT_EXECUTOR_POOL;
    private ObjectPool<Executor> transportExecutorPool = DEFAULT_TRANSPORT_EXECUTOR_POOL;
    private ObjectPool<ScheduledExecutorService> scheduledExecutorServicePool = SharedResourcePool.forResource(GrpcUtil.TIMER_SERVICE);
    private SocketFactory socketFactory;
    private SSLSocketFactory sslSocketFactory;
    private final boolean freezeSecurityConfiguration;
    private HostnameVerifier hostnameVerifier;
    private ConnectionSpec connectionSpec = INTERNAL_DEFAULT_CONNECTION_SPEC;
    private NegotiationType negotiationType = NegotiationType.TLS;
    private long keepAliveTimeNanos = Long.MAX_VALUE;
    private long keepAliveTimeoutNanos = GrpcUtil.DEFAULT_KEEPALIVE_TIMEOUT_NANOS;
    private int flowControlWindow = 65535;
    private boolean keepAliveWithoutCalls;
    private int maxInboundMetadataSize = Integer.MAX_VALUE;
    private final boolean useGetForSafeMethods = false;
    private static final EnumSet<TlsChannelCredentials.Feature> understoodTlsFeatures;

    public static OkHttpChannelBuilder forAddress(String host, int port) {
        return new OkHttpChannelBuilder(host, port);
    }

    public static OkHttpChannelBuilder forAddress(String host, int port, ChannelCredentials creds) {
        return OkHttpChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort(host, port), creds);
    }

    public static OkHttpChannelBuilder forTarget(String target) {
        return new OkHttpChannelBuilder(target);
    }

    public static OkHttpChannelBuilder forTarget(String target, ChannelCredentials creds) {
        SslSocketFactoryResult result = OkHttpChannelBuilder.sslSocketFactoryFrom(creds);
        if (result.error != null) {
            throw new IllegalArgumentException(result.error);
        }
        return new OkHttpChannelBuilder(target, creds, result.callCredentials, result.factory);
    }

    private OkHttpChannelBuilder(String host, int port) {
        this(GrpcUtil.authorityFromHostAndPort(host, port));
    }

    private OkHttpChannelBuilder(String target) {
        this.managedChannelImplBuilder = new ManagedChannelImplBuilder(target, new OkHttpChannelTransportFactoryBuilder(), new OkHttpChannelDefaultPortProvider());
        this.freezeSecurityConfiguration = false;
    }

    OkHttpChannelBuilder(String target, ChannelCredentials channelCreds, CallCredentials callCreds, SSLSocketFactory factory2) {
        this.managedChannelImplBuilder = new ManagedChannelImplBuilder(target, channelCreds, callCreds, new OkHttpChannelTransportFactoryBuilder(), new OkHttpChannelDefaultPortProvider());
        this.sslSocketFactory = factory2;
        this.negotiationType = factory2 == null ? NegotiationType.PLAINTEXT : NegotiationType.TLS;
        this.freezeSecurityConfiguration = true;
    }

    @Override
    @Internal
    protected ManagedChannelBuilder<?> delegate() {
        return this.managedChannelImplBuilder;
    }

    @VisibleForTesting
    OkHttpChannelBuilder setTransportTracerFactory(TransportTracer.Factory transportTracerFactory) {
        this.transportTracerFactory = transportTracerFactory;
        return this;
    }

    public OkHttpChannelBuilder transportExecutor(@Nullable Executor transportExecutor) {
        this.transportExecutorPool = transportExecutor == null ? DEFAULT_TRANSPORT_EXECUTOR_POOL : new FixedObjectPool<Executor>(transportExecutor);
        return this;
    }

    public OkHttpChannelBuilder socketFactory(@Nullable SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
        return this;
    }

    @Deprecated
    public OkHttpChannelBuilder negotiationType(com.newrelic.agent.deps.io.grpc.okhttp.NegotiationType type) {
        Preconditions.checkState(!this.freezeSecurityConfiguration, "Cannot change security when using ChannelCredentials");
        Preconditions.checkNotNull(type, "type");
        switch (type) {
            case TLS: {
                this.negotiationType = NegotiationType.TLS;
                break;
            }
            case PLAINTEXT: {
                this.negotiationType = NegotiationType.PLAINTEXT;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown negotiation type: " + (Object)((Object)type)));
            }
        }
        return this;
    }

    @Override
    public OkHttpChannelBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument(keepAliveTime > 0L, "keepalive time must be positive");
        this.keepAliveTimeNanos = timeUnit.toNanos(keepAliveTime);
        this.keepAliveTimeNanos = KeepAliveManager.clampKeepAliveTimeInNanos(this.keepAliveTimeNanos);
        if (this.keepAliveTimeNanos >= AS_LARGE_AS_INFINITE) {
            this.keepAliveTimeNanos = Long.MAX_VALUE;
        }
        return this;
    }

    @Override
    public OkHttpChannelBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        Preconditions.checkArgument(keepAliveTimeout > 0L, "keepalive timeout must be positive");
        this.keepAliveTimeoutNanos = timeUnit.toNanos(keepAliveTimeout);
        this.keepAliveTimeoutNanos = KeepAliveManager.clampKeepAliveTimeoutInNanos(this.keepAliveTimeoutNanos);
        return this;
    }

    public OkHttpChannelBuilder flowControlWindow(int flowControlWindow) {
        Preconditions.checkState(flowControlWindow > 0, "flowControlWindow must be positive");
        this.flowControlWindow = flowControlWindow;
        return this;
    }

    @Override
    public OkHttpChannelBuilder keepAliveWithoutCalls(boolean enable) {
        this.keepAliveWithoutCalls = enable;
        return this;
    }

    public OkHttpChannelBuilder sslSocketFactory(SSLSocketFactory factory2) {
        Preconditions.checkState(!this.freezeSecurityConfiguration, "Cannot change security when using ChannelCredentials");
        this.sslSocketFactory = factory2;
        this.negotiationType = NegotiationType.TLS;
        return this;
    }

    public OkHttpChannelBuilder hostnameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
        Preconditions.checkState(!this.freezeSecurityConfiguration, "Cannot change security when using ChannelCredentials");
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public OkHttpChannelBuilder connectionSpec(com.newrelic.agent.deps.com.squareup.okhttp.ConnectionSpec connectionSpec) {
        Preconditions.checkState(!this.freezeSecurityConfiguration, "Cannot change security when using ChannelCredentials");
        Preconditions.checkArgument(connectionSpec.isTls(), "plaintext ConnectionSpec is not accepted");
        this.connectionSpec = Utils.convertSpec(connectionSpec);
        return this;
    }

    public OkHttpChannelBuilder tlsConnectionSpec(String[] tlsVersions, String[] cipherSuites) {
        Preconditions.checkState(!this.freezeSecurityConfiguration, "Cannot change security when using ChannelCredentials");
        Preconditions.checkNotNull(tlsVersions, "tls versions must not null");
        Preconditions.checkNotNull(cipherSuites, "ciphers must not null");
        this.connectionSpec = new ConnectionSpec.Builder(true).supportsTlsExtensions(true).tlsVersions(tlsVersions).cipherSuites(cipherSuites).build();
        return this;
    }

    @Override
    public OkHttpChannelBuilder usePlaintext() {
        Preconditions.checkState(!this.freezeSecurityConfiguration, "Cannot change security when using ChannelCredentials");
        this.negotiationType = NegotiationType.PLAINTEXT;
        return this;
    }

    @Override
    public OkHttpChannelBuilder useTransportSecurity() {
        Preconditions.checkState(!this.freezeSecurityConfiguration, "Cannot change security when using ChannelCredentials");
        this.negotiationType = NegotiationType.TLS;
        return this;
    }

    public OkHttpChannelBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorServicePool = new FixedObjectPool<ScheduledExecutorService>(Preconditions.checkNotNull(scheduledExecutorService, "scheduledExecutorService"));
        return this;
    }

    @Override
    public OkHttpChannelBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument(bytes > 0, "maxInboundMetadataSize must be > 0");
        this.maxInboundMetadataSize = bytes;
        return this;
    }

    @Override
    public OkHttpChannelBuilder maxInboundMessageSize(int max) {
        Preconditions.checkArgument(max >= 0, "negative max");
        this.maxInboundMessageSize = max;
        return this;
    }

    OkHttpTransportFactory buildTransportFactory() {
        boolean enableKeepAlive = this.keepAliveTimeNanos != Long.MAX_VALUE;
        return new OkHttpTransportFactory(this.transportExecutorPool, this.scheduledExecutorServicePool, this.socketFactory, this.createSslSocketFactory(), this.hostnameVerifier, this.connectionSpec, this.maxInboundMessageSize, enableKeepAlive, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.flowControlWindow, this.keepAliveWithoutCalls, this.maxInboundMetadataSize, this.transportTracerFactory, false);
    }

    OkHttpChannelBuilder disableCheckAuthority() {
        this.managedChannelImplBuilder.disableCheckAuthority();
        return this;
    }

    OkHttpChannelBuilder enableCheckAuthority() {
        this.managedChannelImplBuilder.enableCheckAuthority();
        return this;
    }

    int getDefaultPort() {
        switch (this.negotiationType) {
            case PLAINTEXT: {
                return 80;
            }
            case TLS: {
                return 443;
            }
        }
        throw new AssertionError((Object)((Object)((Object)this.negotiationType) + " not handled"));
    }

    void setStatsEnabled(boolean value) {
        this.managedChannelImplBuilder.setStatsEnabled(value);
    }

    @Nullable
    @VisibleForTesting
    SSLSocketFactory createSslSocketFactory() {
        switch (this.negotiationType) {
            case TLS: {
                try {
                    if (this.sslSocketFactory == null) {
                        SSLContext sslContext = SSLContext.getInstance("Default", Platform.get().getProvider());
                        this.sslSocketFactory = sslContext.getSocketFactory();
                    }
                    return this.sslSocketFactory;
                }
                catch (GeneralSecurityException gse) {
                    throw new RuntimeException("TLS Provider failure", gse);
                }
            }
            case PLAINTEXT: {
                return null;
            }
        }
        throw new RuntimeException("Unknown negotiation type: " + (Object)((Object)this.negotiationType));
    }

    static SslSocketFactoryResult sslSocketFactoryFrom(ChannelCredentials creds) {
        if (creds instanceof TlsChannelCredentials) {
            SSLContext sslContext;
            TlsChannelCredentials tlsCreds = (TlsChannelCredentials)creds;
            Set<TlsChannelCredentials.Feature> incomprehensible = tlsCreds.incomprehensible(understoodTlsFeatures);
            if (!incomprehensible.isEmpty()) {
                return SslSocketFactoryResult.error("TLS features not understood: " + incomprehensible);
            }
            KeyManager[] km4 = null;
            if (tlsCreds.getKeyManagers() != null) {
                km4 = tlsCreds.getKeyManagers().toArray(new KeyManager[0]);
            } else if (tlsCreds.getPrivateKey() != null) {
                if (tlsCreds.getPrivateKeyPassword() != null) {
                    return SslSocketFactoryResult.error("byte[]-based private key with password unsupported. Use unencrypted file or KeyManager");
                }
                try {
                    km4 = OkHttpChannelBuilder.createKeyManager(tlsCreds.getCertificateChain(), tlsCreds.getPrivateKey());
                }
                catch (GeneralSecurityException gse) {
                    log.log(Level.FINE, "Exception loading private key from credential", gse);
                    return SslSocketFactoryResult.error("Unable to load private key: " + gse.getMessage());
                }
            }
            TrustManager[] tm = null;
            if (tlsCreds.getTrustManagers() != null) {
                tm = tlsCreds.getTrustManagers().toArray(new TrustManager[0]);
            } else if (tlsCreds.getRootCertificates() != null) {
                try {
                    tm = OkHttpChannelBuilder.createTrustManager(tlsCreds.getRootCertificates());
                }
                catch (GeneralSecurityException gse) {
                    log.log(Level.FINE, "Exception loading root certificates from credential", gse);
                    return SslSocketFactoryResult.error("Unable to load root certificates: " + gse.getMessage());
                }
            }
            try {
                sslContext = SSLContext.getInstance("TLS", Platform.get().getProvider());
                sslContext.init(km4, tm, null);
            }
            catch (GeneralSecurityException gse) {
                throw new RuntimeException("TLS Provider failure", gse);
            }
            return SslSocketFactoryResult.factory(sslContext.getSocketFactory());
        }
        if (creds instanceof InsecureChannelCredentials) {
            return SslSocketFactoryResult.plaintext();
        }
        if (creds instanceof CompositeChannelCredentials) {
            CompositeChannelCredentials compCreds = (CompositeChannelCredentials)creds;
            return OkHttpChannelBuilder.sslSocketFactoryFrom(compCreds.getChannelCredentials()).withCallCredentials(compCreds.getCallCredentials());
        }
        if (creds instanceof SslSocketFactoryChannelCredentials.ChannelCredentials) {
            SslSocketFactoryChannelCredentials.ChannelCredentials factoryCreds = (SslSocketFactoryChannelCredentials.ChannelCredentials)creds;
            return SslSocketFactoryResult.factory(factoryCreds.getFactory());
        }
        if (creds instanceof ChoiceChannelCredentials) {
            ChoiceChannelCredentials choiceCreds = (ChoiceChannelCredentials)creds;
            StringBuilder error = new StringBuilder();
            for (ChannelCredentials innerCreds : choiceCreds.getCredentialsList()) {
                SslSocketFactoryResult result = OkHttpChannelBuilder.sslSocketFactoryFrom(innerCreds);
                if (result.error == null) {
                    return result;
                }
                error.append(", ");
                error.append(result.error);
            }
            return SslSocketFactoryResult.error(error.substring(2));
        }
        return SslSocketFactoryResult.error("Unsupported credential type: " + creds.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeyManager[] createKeyManager(byte[] certChain, byte[] privateKey) throws GeneralSecurityException {
        PrivateKey key;
        Certificate[] chain;
        ByteArrayInputStream inCertChain = new ByteArrayInputStream(certChain);
        try {
            chain = CertificateUtils.getX509Certificates(inCertChain);
        }
        finally {
            GrpcUtil.closeQuietly(inCertChain);
        }
        ByteArrayInputStream inPrivateKey = new ByteArrayInputStream(privateKey);
        try {
            key = CertificateUtils.getPrivateKey(inPrivateKey);
        }
        catch (IOException uee) {
            throw new GeneralSecurityException("Unable to decode private key", uee);
        }
        finally {
            GrpcUtil.closeQuietly(inPrivateKey);
        }
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            ks.load(null, null);
        }
        catch (IOException ex) {
            throw new GeneralSecurityException(ex);
        }
        ks.setKeyEntry("key", key, new char[0], chain);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(ks, new char[0]);
        return keyManagerFactory.getKeyManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TrustManager[] createTrustManager(byte[] rootCerts) throws GeneralSecurityException {
        X509Certificate[] certs;
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            ks.load(null, null);
        }
        catch (IOException ex) {
            throw new GeneralSecurityException(ex);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(rootCerts);
        try {
            certs = CertificateUtils.getX509Certificates(in);
        }
        finally {
            GrpcUtil.closeQuietly(in);
        }
        for (X509Certificate cert : certs) {
            X500Principal principal = cert.getSubjectX500Principal();
            ks.setCertificateEntry(principal.getName("RFC2253"), cert);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(ks);
        return trustManagerFactory.getTrustManagers();
    }

    static {
        OkHttpChannelBuilder.class.getName();
        log = Logger.global;
        INTERNAL_DEFAULT_CONNECTION_SPEC = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).cipherSuites(CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256).tlsVersions(TlsVersion.TLS_1_2).supportsTlsExtensions(true).build();
        AS_LARGE_AS_INFINITE = TimeUnit.DAYS.toNanos(1000L);
        SHARED_EXECUTOR = new SharedResourceHolder.Resource<Executor>(){

            @Override
            public Executor create() {
                return Executors.newCachedThreadPool(GrpcUtil.getThreadFactory("grpc-okhttp-%d", true));
            }

            @Override
            public void close(Executor executor) {
                ((ExecutorService)executor).shutdown();
            }
        };
        DEFAULT_TRANSPORT_EXECUTOR_POOL = SharedResourcePool.forResource(SHARED_EXECUTOR);
        understoodTlsFeatures = EnumSet.of(TlsChannelCredentials.Feature.MTLS, TlsChannelCredentials.Feature.CUSTOM_MANAGERS);
    }

    @Internal
    static final class OkHttpTransportFactory
    implements ClientTransportFactory {
        private final ObjectPool<Executor> executorPool;
        final Executor executor;
        private final ObjectPool<ScheduledExecutorService> scheduledExecutorServicePool;
        final ScheduledExecutorService scheduledExecutorService;
        final TransportTracer.Factory transportTracerFactory;
        final SocketFactory socketFactory;
        @Nullable
        final SSLSocketFactory sslSocketFactory;
        @Nullable
        final HostnameVerifier hostnameVerifier;
        final ConnectionSpec connectionSpec;
        final int maxMessageSize;
        private final boolean enableKeepAlive;
        private final long keepAliveTimeNanos;
        private final AtomicBackoff keepAliveBackoff;
        private final long keepAliveTimeoutNanos;
        final int flowControlWindow;
        private final boolean keepAliveWithoutCalls;
        final int maxInboundMetadataSize;
        final boolean useGetForSafeMethods;
        private boolean closed;

        private OkHttpTransportFactory(ObjectPool<Executor> executorPool, ObjectPool<ScheduledExecutorService> scheduledExecutorServicePool, @Nullable SocketFactory socketFactory, @Nullable SSLSocketFactory sslSocketFactory, @Nullable HostnameVerifier hostnameVerifier, ConnectionSpec connectionSpec, int maxMessageSize, boolean enableKeepAlive, long keepAliveTimeNanos, long keepAliveTimeoutNanos, int flowControlWindow, boolean keepAliveWithoutCalls, int maxInboundMetadataSize, TransportTracer.Factory transportTracerFactory, boolean useGetForSafeMethods) {
            this.executorPool = executorPool;
            this.executor = executorPool.getObject();
            this.scheduledExecutorServicePool = scheduledExecutorServicePool;
            this.scheduledExecutorService = scheduledExecutorServicePool.getObject();
            this.socketFactory = socketFactory;
            this.sslSocketFactory = sslSocketFactory;
            this.hostnameVerifier = hostnameVerifier;
            this.connectionSpec = connectionSpec;
            this.maxMessageSize = maxMessageSize;
            this.enableKeepAlive = enableKeepAlive;
            this.keepAliveTimeNanos = keepAliveTimeNanos;
            this.keepAliveBackoff = new AtomicBackoff("keepalive time nanos", keepAliveTimeNanos);
            this.keepAliveTimeoutNanos = keepAliveTimeoutNanos;
            this.flowControlWindow = flowControlWindow;
            this.keepAliveWithoutCalls = keepAliveWithoutCalls;
            this.maxInboundMetadataSize = maxInboundMetadataSize;
            this.useGetForSafeMethods = useGetForSafeMethods;
            this.transportTracerFactory = Preconditions.checkNotNull(transportTracerFactory, "transportTracerFactory");
        }

        @Override
        public ConnectionClientTransport newClientTransport(SocketAddress addr, ClientTransportFactory.ClientTransportOptions options, ChannelLogger channelLogger) {
            if (this.closed) {
                throw new IllegalStateException("The transport factory is closed.");
            }
            final AtomicBackoff.State keepAliveTimeNanosState = this.keepAliveBackoff.getState();
            Runnable tooManyPingsRunnable = new Runnable(){

                @Override
                public void run() {
                    keepAliveTimeNanosState.backoff();
                }
            };
            InetSocketAddress inetSocketAddr = (InetSocketAddress)addr;
            OkHttpClientTransport transport = new OkHttpClientTransport(this, inetSocketAddr, options.getAuthority(), options.getUserAgent(), options.getEagAttributes(), options.getHttpConnectProxiedSocketAddress(), tooManyPingsRunnable);
            if (this.enableKeepAlive) {
                transport.enableKeepAlive(true, keepAliveTimeNanosState.get(), this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls);
            }
            return transport;
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService() {
            return this.scheduledExecutorService;
        }

        @Override
        @Nullable
        @CheckReturnValue
        public ClientTransportFactory.SwapChannelCredentialsResult swapChannelCredentials(ChannelCredentials channelCreds) {
            SslSocketFactoryResult result = OkHttpChannelBuilder.sslSocketFactoryFrom(channelCreds);
            if (result.error != null) {
                return null;
            }
            OkHttpTransportFactory factory2 = new OkHttpTransportFactory(this.executorPool, this.scheduledExecutorServicePool, this.socketFactory, result.factory, this.hostnameVerifier, this.connectionSpec, this.maxMessageSize, this.enableKeepAlive, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.flowControlWindow, this.keepAliveWithoutCalls, this.maxInboundMetadataSize, this.transportTracerFactory, this.useGetForSafeMethods);
            return new ClientTransportFactory.SwapChannelCredentialsResult(factory2, result.callCredentials);
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.executorPool.returnObject(this.executor);
            this.scheduledExecutorServicePool.returnObject(this.scheduledExecutorService);
        }
    }

    static final class SslSocketFactoryResult {
        public final SSLSocketFactory factory;
        public final CallCredentials callCredentials;
        public final String error;

        private SslSocketFactoryResult(SSLSocketFactory factory2, CallCredentials creds, String error) {
            this.factory = factory2;
            this.callCredentials = creds;
            this.error = error;
        }

        public static SslSocketFactoryResult error(String error) {
            return new SslSocketFactoryResult(null, null, Preconditions.checkNotNull(error, "error"));
        }

        public static SslSocketFactoryResult plaintext() {
            return new SslSocketFactoryResult(null, null, null);
        }

        public static SslSocketFactoryResult factory(SSLSocketFactory factory2) {
            return new SslSocketFactoryResult(Preconditions.checkNotNull(factory2, "factory"), null, null);
        }

        public SslSocketFactoryResult withCallCredentials(CallCredentials callCreds) {
            Preconditions.checkNotNull(callCreds, "callCreds");
            if (this.error != null) {
                return this;
            }
            if (this.callCredentials != null) {
                callCreds = new CompositeCallCredentials(this.callCredentials, callCreds);
            }
            return new SslSocketFactoryResult(this.factory, callCreds, null);
        }
    }

    private final class OkHttpChannelDefaultPortProvider
    implements ManagedChannelImplBuilder.ChannelBuilderDefaultPortProvider {
        private OkHttpChannelDefaultPortProvider() {
        }

        @Override
        public int getDefaultPort() {
            return OkHttpChannelBuilder.this.getDefaultPort();
        }
    }

    private final class OkHttpChannelTransportFactoryBuilder
    implements ManagedChannelImplBuilder.ClientTransportFactoryBuilder {
        private OkHttpChannelTransportFactoryBuilder() {
        }

        @Override
        public ClientTransportFactory buildClientTransportFactory() {
            return OkHttpChannelBuilder.this.buildTransportFactory();
        }
    }

    private static enum NegotiationType {
        TLS,
        PLAINTEXT;

    }
}

