/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.TransactionData;
import com.newrelic.agent.errors.ThrowableError;
import com.newrelic.agent.errors.TracedError;
import com.newrelic.api.agent.ErrorData;
import java.util.HashMap;
import java.util.Map;

public class ErrorDataImpl
implements ErrorData {
    private final TransactionData transactionData;
    private final TracedError tracedError;

    public ErrorDataImpl(TransactionData txData, TracedError tracedError) {
        this.transactionData = txData;
        this.tracedError = tracedError;
    }

    public Throwable getException() {
        if (this.isTransactionDataThrowableValid()) {
            return this.transactionData.getThrowable().throwable;
        }
        if (this.isTracedErrorInstanceOfThrowableError()) {
            return ((ThrowableError)this.tracedError).getThrowable();
        }
        return null;
    }

    public String getErrorClass() {
        if (this.isTransactionDataThrowableValid() && this.transactionData.getThrowable().throwable != null) {
            return this.transactionData.getThrowable().throwable.getClass().toString();
        }
        if (this.isTracedErrorInstanceOfThrowableError()) {
            return ((ThrowableError)this.tracedError).getThrowable().getClass().toString();
        }
        return "";
    }

    public String getErrorMessage() {
        if (this.isTransactionDataThrowableValid() && this.transactionData.getThrowable().throwable.getMessage() != null) {
            return this.transactionData.getThrowable().throwable.getMessage();
        }
        if (this.isTracedErrorInstanceOfThrowableError() && ((ThrowableError)this.tracedError).getThrowable() != null) {
            return ((ThrowableError)this.tracedError).getThrowable().getMessage();
        }
        return "";
    }

    public StackTraceElement[] getStackTraceElement() {
        if (this.isTransactionDataThrowableValid() && this.transactionData.getThrowable().throwable != null) {
            return this.transactionData.getThrowable().throwable.getStackTrace();
        }
        if (this.isTracedErrorInstanceOfThrowableError() && ((ThrowableError)this.tracedError).getThrowable() != null) {
            return ((ThrowableError)this.tracedError).getThrowable().getStackTrace();
        }
        return new StackTraceElement[0];
    }

    public Map<String, ?> getCustomAttributes() {
        HashMap<String, Object> combinedUserAttMap = new HashMap<String, Object>();
        if (this.transactionData != null) {
            if (this.transactionData.getUserAttributes() != null) {
                combinedUserAttMap.putAll(this.transactionData.getUserAttributes());
            }
            if (this.transactionData.getErrorAttributes() != null) {
                combinedUserAttMap.putAll(this.transactionData.getErrorAttributes());
            }
        }
        if (this.tracedError != null && this.tracedError.getErrorAtts() != null) {
            combinedUserAttMap.putAll(this.tracedError.getErrorAtts());
        }
        return combinedUserAttMap;
    }

    public String getTransactionName() {
        return this.transactionData != null ? this.transactionData.getTransaction().getPriorityTransactionName().getName() : "";
    }

    public String getTransactionUiName() {
        return this.getTransactionName();
    }

    public String getRequestUri() {
        return this.getAgentAttributeOrReturnEmptyString("request.uri");
    }

    public String getHttpStatusCode() {
        return this.getAgentAttributeOrReturnEmptyString("http.statusCode");
    }

    public String getHttpMethod() {
        return this.getAgentAttributeOrReturnEmptyString("request.method");
    }

    public boolean isErrorExpected() {
        if (this.isTransactionDataThrowableValid()) {
            return this.transactionData.getThrowable().expected;
        }
        if (this.tracedError != null) {
            return this.tracedError.isExpected();
        }
        return false;
    }

    private boolean isTransactionDataThrowableValid() {
        return this.transactionData != null && this.transactionData.getThrowable() != null;
    }

    private boolean isTracedErrorInstanceOfThrowableError() {
        return this.tracedError != null && this.tracedError instanceof ThrowableError;
    }

    private String getAgentAttributeOrReturnEmptyString(String key) {
        Object value = null;
        if (this.transactionData != null) {
            value = this.transactionData.getAgentAttributes().get(key);
        }
        return value == null ? "" : value.toString();
    }
}

