/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.normalization;

import com.newrelic.agent.deps.com.google.common.base.Joiner;
import com.newrelic.agent.normalization.NormalizationRule;
import com.newrelic.agent.normalization.Normalizer;
import com.newrelic.agent.normalization.NormalizerImpl;
import com.newrelic.agent.normalization.TransactionSegmentTerms;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NormalizerFactory {
    public static Normalizer createUrlNormalizer(String appName, List<NormalizationRule> urlRules) {
        return new UrlNormalizer(new NormalizerImpl(appName, urlRules));
    }

    public static Normalizer createTransactionNormalizer(String appName, List<NormalizationRule> transactionNameRules, List<TransactionSegmentTerms> transactionSegmentTermRules) {
        Normalizer normalizer = new NormalizerImpl(appName, transactionNameRules);
        if (!transactionSegmentTermRules.isEmpty()) {
            normalizer = NormalizerFactory.compoundNormalizer(normalizer, NormalizerFactory.createTransactionSegmentNormalizer(transactionSegmentTermRules));
        }
        return normalizer;
    }

    private static Normalizer compoundNormalizer(final Normalizer ... normalizers) {
        final ArrayList<NormalizationRule> rules = new ArrayList<NormalizationRule>();
        for (Normalizer n : normalizers) {
            rules.addAll(n.getRules());
        }
        return new Normalizer(){

            @Override
            public String normalize(String name) {
                for (Normalizer n : normalizers) {
                    if ((name = n.normalize(name)) != null) continue;
                    return name;
                }
                return name;
            }

            @Override
            public List<NormalizationRule> getRules() {
                return rules;
            }
        };
    }

    static Normalizer createTransactionSegmentNormalizer(final List<TransactionSegmentTerms> transactionSegmentTermRules) {
        return new Normalizer(){

            @Override
            public String normalize(String name) {
                for (TransactionSegmentTerms terms : transactionSegmentTermRules) {
                    if (!name.startsWith(terms.prefix)) continue;
                    String afterPrefix = name.substring(terms.prefix.length() + 1);
                    String[] segments = afterPrefix.split("/");
                    ArrayList<String> keep = new ArrayList<String>(segments.length + 1);
                    keep.add(terms.prefix);
                    boolean discarded = false;
                    for (String segment : segments) {
                        if (terms.terms.contains(segment)) {
                            keep.add(segment);
                            discarded = false;
                            continue;
                        }
                        if (discarded) continue;
                        keep.add("*");
                        discarded = true;
                    }
                    name = Joiner.on('/').join(keep);
                }
                return name;
            }

            @Override
            public List<NormalizationRule> getRules() {
                return Collections.emptyList();
            }
        };
    }

    public static Normalizer createMetricNormalizer(String appName, List<NormalizationRule> metricNameRules) {
        return new NormalizerImpl(appName, metricNameRules);
    }

    private static class UrlNormalizer
    implements Normalizer {
        private final Normalizer normalizer;

        private UrlNormalizer(Normalizer normalizer) {
            this.normalizer = normalizer;
        }

        @Override
        public String normalize(String name) {
            if (name == null) {
                return null;
            }
            String normalizedName = name;
            if (!normalizedName.startsWith("/")) {
                normalizedName = "/" + name;
            }
            return this.normalizer.normalize(normalizedName);
        }

        @Override
        public List<NormalizationRule> getRules() {
            return this.normalizer.getRules();
        }
    }
}

