/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.rpm;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ConnectionListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.RPMServiceManager;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.service.Service;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public interface RPMConnectionService
extends Service {
    public void connect(IRPMService var1);

    public void connectImmediate(IRPMService var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void awaitConnectImmediate(RPMServiceManager rpmServiceManager, int timeout2, TimeUnit timeUnit) {
        final CountDownLatch latch = new CountDownLatch(1);
        ConnectionListener listener = new ConnectionListener(){

            @Override
            public void connected(IRPMService rpmService, AgentConfig agentConfig) {
                latch.countDown();
            }

            @Override
            public void disconnected(IRPMService rpmService) {
            }
        };
        rpmServiceManager.addConnectionListener(listener);
        this.connectImmediate(rpmServiceManager.getRPMService());
        try {
            if (!rpmServiceManager.getRPMService().isConnected()) {
                latch.await(timeout2, timeUnit);
            }
        }
        catch (InterruptedException e) {
            Agent.LOG.log(Level.FINER, e, e.getMessage());
        }
        finally {
            rpmServiceManager.removeConnectionListener(listener);
        }
    }
}

