/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.trace;

import com.newrelic.agent.Agent;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.trace.ITransactionSampler;
import com.newrelic.agent.trace.TransactionTrace;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class SyntheticsTransactionSampler
implements ITransactionSampler {
    private final ConcurrentLinkedQueue<TransactionData> pending = new ConcurrentLinkedQueue();
    private final AtomicInteger pendingCount = new AtomicInteger(0);
    static final int MAX_SYNTHETIC_TRANSACTION_PER_HARVEST = 20;
    private static final TransactionData queueMarker = new TransactionData(null, 0);

    @Override
    public boolean noticeTransaction(TransactionData td) {
        if (td.isSyntheticTransaction()) {
            if (this.pendingCount.get() < 20) {
                this.pendingCount.incrementAndGet();
                this.pending.add(td);
                String msg = MessageFormat.format("Sampled Synthetics Transaction: {0}", td);
                Agent.LOG.finest(msg);
                return true;
            }
            Agent.LOG.log(Level.FINER, "Dropped Synthetic TT for app {0}", td.getApplicationName());
        }
        return false;
    }

    @Override
    public List<TransactionTrace> harvest(String appName) {
        TransactionData queued;
        LinkedList<TransactionTrace> result = new LinkedList<TransactionTrace>();
        if (appName == null) {
            return result;
        }
        this.pending.add(queueMarker);
        int removedCount = 0;
        while ((queued = this.pending.poll()) != queueMarker) {
            if (appName.equals(queued.getApplicationName())) {
                TransactionTrace tt = TransactionTrace.getTransactionTrace(queued);
                tt.setSyntheticsResourceId(queued.getSyntheticsResourceId());
                ++removedCount;
                result.add(tt);
                continue;
            }
            this.pending.add(queued);
        }
        this.pendingCount.addAndGet(-removedCount);
        return result;
    }

    @Override
    public void stop() {
    }

    int getPendingCount() {
        return this.pendingCount.get();
    }
}

