/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracing;

import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.DistributedTracePayload;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracing.DistributedTraceService;
import com.newrelic.agent.tracing.DistributedTraceUtil;
import com.newrelic.agent.tracing.Sampled;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.logging.Level;

public class DistributedTracePayloadImpl
implements DistributedTracePayload {
    public final long timestamp;
    public final String parentType;
    public final String accountId;
    public final String trustKey;
    public final String applicationId;
    public final String guid;
    public final String traceId;
    public final Float priority;
    public final Sampled sampled;
    public final String txnId;

    public static DistributedTracePayloadImpl createDistributedTracePayload(String traceId, String guid, String txnId, float priority) {
        DistributedTraceService distributedTraceService = ServiceFactory.getDistributedTraceService();
        String accountId = distributedTraceService.getAccountId();
        if (accountId == null) {
            AgentBridge.getAgent().getLogger().log(Level.FINER, "Not creating distributed trace payload due to null accountId. Make sure the agent has connected to New Relic.");
            return null;
        }
        String trustKey = distributedTraceService.getTrustKey();
        String applicationId = distributedTraceService.getApplicationId();
        long timestamp = System.currentTimeMillis();
        Sampled sampled = DistributedTraceUtil.isSampledPriority(priority) ? Sampled.SAMPLED_YES : Sampled.SAMPLED_NO;
        return new DistributedTracePayloadImpl(timestamp, "App", accountId, trustKey, applicationId, guid, traceId, txnId, Float.valueOf(priority), sampled);
    }

    protected DistributedTracePayloadImpl(long timestamp, String parentType, String accountId, String trustKey, String applicationId, String guid, String traceId, String txnId, Float priority, Sampled sampled) {
        this.timestamp = timestamp;
        this.parentType = parentType;
        this.accountId = accountId;
        this.trustKey = trustKey;
        this.applicationId = applicationId;
        this.guid = guid;
        this.txnId = txnId;
        this.traceId = traceId;
        this.priority = priority;
        this.sampled = sampled;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getTransactionId() {
        return this.txnId;
    }

    public String text() {
        DistributedTraceService distributedTraceService = ServiceFactory.getDistributedTraceService();
        JSONObject payload = new JSONObject();
        JSONArray catVersion = new JSONArray();
        catVersion.add(distributedTraceService.getMajorSupportedCatVersion());
        catVersion.add(distributedTraceService.getMinorSupportedCatVersion());
        payload.put("v", catVersion);
        JSONObject data = new JSONObject();
        data.put("ti", this.timestamp);
        data.put("ty", this.parentType);
        data.put("ac", this.accountId);
        if (!this.accountId.equals(this.trustKey)) {
            data.put("tk", this.trustKey);
        }
        data.put("ap", this.applicationId);
        if (this.guid != null) {
            data.put("id", this.guid);
        }
        data.put("tr", this.traceId);
        data.put("pr", this.priority);
        data.put("sa", this.sampled.booleanValue());
        if (this.txnId != null) {
            data.put("tx", this.txnId);
        }
        payload.put("d", data);
        return payload.toJSONString();
    }

    public String httpSafe() {
        return Base64.getEncoder().encodeToString(this.text().getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        return "DistributedTracePayloadImpl{timestamp=" + this.timestamp + ", parentType='" + this.parentType + '\'' + ", accountId='" + this.accountId + '\'' + ", trustKey='" + this.trustKey + '\'' + ", applicationId='" + this.applicationId + '\'' + ", guid='" + this.guid + '\'' + ", traceId='" + this.traceId + '\'' + ", txnId='" + this.txnId + '\'' + ", sampled=" + (Object)((Object)this.sampled) + ", priority=" + this.priority + '}';
    }
}

