/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracing;

import com.newrelic.agent.tracing.ParentType;
import com.newrelic.agent.tracing.Sampled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class W3CTraceState {
    private final List<String> traceStateHeaders;
    private final boolean containsNrData;
    private final List<String> vendorStates;
    private final int version;
    private final String trustKey;
    private final ParentType parentType;
    private final String guid;
    private final String accountId;
    private final String applicationId;
    private final String txnId;
    private final Sampled sampled;
    private final Float priority;
    private final long timestamp;

    W3CTraceState(List<String> traceStateHeaders, List<String> vendorStates) {
        this(traceStateHeaders, vendorStates, false, 0, null, ParentType.Invalid, null, null, null, null, Sampled.UNKNOWN, null, 0L);
    }

    W3CTraceState(List<String> traceStateHeaders, List<String> vendorStates, boolean containsNrData, int version, String trustKey, ParentType parentType, String accountId, String applicationId, String guid, String txnId, Sampled sampled, Float priority, long timestamp) {
        this.traceStateHeaders = new ArrayList<String>(traceStateHeaders);
        this.containsNrData = containsNrData;
        this.vendorStates = new ArrayList<String>(vendorStates);
        this.version = version;
        this.trustKey = trustKey;
        this.parentType = parentType;
        this.accountId = accountId;
        this.applicationId = applicationId;
        this.txnId = txnId;
        this.guid = guid;
        this.sampled = sampled;
        this.priority = priority;
        this.timestamp = timestamp;
    }

    public List<String> getTraceStateHeaders() {
        return this.traceStateHeaders;
    }

    boolean containsNrData() {
        return this.containsNrData;
    }

    public List<String> getVendorStates() {
        return Collections.unmodifiableList(this.vendorStates);
    }

    public int getVersion() {
        return this.version;
    }

    public String getTrustKey() {
        return this.trustKey;
    }

    public ParentType getParentType() {
        return this.parentType;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getTxnId() {
        return this.txnId;
    }

    public Sampled getSampled() {
        return this.sampled;
    }

    public Float getPriority() {
        return this.priority;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        W3CTraceState that = (W3CTraceState)o;
        return this.containsNrData == that.containsNrData && this.version == that.version && this.timestamp == that.timestamp && Objects.equals(this.traceStateHeaders, that.traceStateHeaders) && Objects.equals(this.vendorStates, that.vendorStates) && Objects.equals(this.trustKey, that.trustKey) && Objects.equals((Object)this.parentType, (Object)that.parentType) && Objects.equals(this.guid, that.guid) && Objects.equals(this.accountId, that.accountId) && Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.txnId, that.txnId) && Objects.equals((Object)this.sampled, (Object)that.sampled) && Objects.equals(this.priority, that.priority);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.traceStateHeaders, this.containsNrData, this.vendorStates, this.version, this.trustKey, this.parentType, this.guid, this.accountId, this.applicationId, this.txnId, this.sampled, this.priority, this.timestamp});
    }
}

