/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.daemon;

import com.newrelic.agent.deps.okhttp3.Authenticator;
import com.newrelic.agent.deps.okhttp3.Headers;
import com.newrelic.agent.deps.okhttp3.MediaType;
import com.newrelic.agent.deps.okhttp3.OkHttpClient;
import com.newrelic.agent.deps.okhttp3.Request;
import com.newrelic.agent.deps.okhttp3.RequestBody;
import com.newrelic.agent.deps.okhttp3.Response;
import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.http.HttpResponse;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.time.Duration;
import java.util.Map;

public class OkHttpPoster
implements HttpPoster {
    private final OkHttpClient okHttpClient;

    public OkHttpPoster(Duration callTimeout) {
        this(null, null, callTimeout);
    }

    public OkHttpPoster(Proxy proxy, Authenticator proxyAuthenticator, Duration callTimeout) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().callTimeout(callTimeout);
        if (proxy != null) {
            builder.proxy(proxy);
            if (proxyAuthenticator != null) {
                builder.authenticator(proxyAuthenticator);
            }
        }
        this.okHttpClient = builder.build();
    }

    @Override
    public HttpResponse post(URL url, Map<String, String> headers, byte[] body, String mediaType) throws IOException {
        RequestBody requestBody = RequestBody.create(body, MediaType.get(mediaType));
        Request request = new Request.Builder().url(url).headers(Headers.of(headers)).post(requestBody).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            HttpResponse httpResponse = new HttpResponse(response.body() != null ? response.body().string() : null, response.code(), response.message(), response.headers().toMultimap());
            return httpResponse;
        }
    }
}

