/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tosummary;

import com.newrelic.jfr.tosummary.EventToSummary;
import com.newrelic.jfr.tosummary.LongSummarizer;
import com.newrelic.jfr.tosummary.SimpleDurationSummarizer;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Summary;
import java.util.stream.Stream;
import jdk.jfr.consumer.RecordedEvent;

public class PerThreadNetworkReadSummarizer
implements EventToSummary {
    private final String threadName;
    private final LongSummarizer bytesSummary;
    private final SimpleDurationSummarizer duration;
    public static final String JFR_SOCKET_READ_DURATION = "jfr.SocketRead.duration";
    public static final String JFR_SOCKET_READ_BYTES_READ = "jfr.SocketRead.bytesRead";
    public static final String BYTES_READ = "bytesRead";
    public static final String THREAD_NAME = "thread.name";

    public PerThreadNetworkReadSummarizer(String threadName, long startTimeMs) {
        this(threadName, new LongSummarizer(BYTES_READ), new SimpleDurationSummarizer(startTimeMs));
    }

    public PerThreadNetworkReadSummarizer(String threadName, LongSummarizer longSummarizer, SimpleDurationSummarizer duration) {
        this.threadName = threadName;
        this.bytesSummary = longSummarizer;
        this.duration = duration;
    }

    @Override
    public String getEventName() {
        return "jdk.SocketRead";
    }

    @Override
    public void accept(RecordedEvent ev) {
        this.bytesSummary.accept(ev);
        this.duration.accept(ev);
    }

    @Override
    public Stream<Summary> summarize() {
        Attributes attr = new Attributes().put(THREAD_NAME, this.threadName);
        Summary outRead = new Summary(JFR_SOCKET_READ_BYTES_READ, this.bytesSummary.getCount(), this.bytesSummary.getSum(), this.bytesSummary.getMin(), this.bytesSummary.getMax(), this.duration.getStartTimeMs(), this.duration.getEndTimeMs(), attr);
        Summary outDuration = new Summary(JFR_SOCKET_READ_DURATION, this.bytesSummary.getCount(), this.duration.getDurationMillis(), this.duration.getMinDurationMillis(), this.duration.getMaxDurationMillis(), this.duration.getStartTimeMs(), outRead.getEndTimeMs(), attr);
        return Stream.of(outRead, outDuration);
    }

    @Override
    public void reset() {
        this.bytesSummary.reset();
        this.duration.reset();
    }
}

