/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tosummary;

import com.newrelic.jfr.RecordedObjectValidators;
import com.newrelic.jfr.tosummary.BaseDurationSummarizer;
import java.time.Duration;
import java.util.function.Supplier;
import jdk.jfr.consumer.RecordedEvent;

public class SimpleDurationSummarizer
extends BaseDurationSummarizer {
    public static final String SIMPLE_CLASS_NAME = SimpleDurationSummarizer.class.getSimpleName();

    public SimpleDurationSummarizer(long startTimeMs) {
        super(startTimeMs);
    }

    public SimpleDurationSummarizer(long startTimeMs, Supplier<Long> clock) {
        super(startTimeMs, clock);
    }

    public SimpleDurationSummarizer(long startTimeMs, Supplier<Long> clock, String durationName) {
        super(startTimeMs, clock, durationName);
    }

    private Duration getDuration(RecordedEvent ev) {
        if (this.durationName.isPresent() && RecordedObjectValidators.hasField(ev, (String)this.durationName.get(), SIMPLE_CLASS_NAME)) {
            return ev.getDuration((String)this.durationName.get());
        }
        return ev.getDuration();
    }

    public void accept(RecordedEvent ev) {
        Duration duration = this.getDuration(ev);
        this.endTimeMs = ev.getStartTime().plus(duration).toEpochMilli();
        this.duration = this.duration.plus(duration);
        if (duration.compareTo(this.maxDuration) > 0) {
            this.maxDuration = duration;
        }
        if (duration.compareTo(this.minDuration) < 0) {
            this.minDuration = duration;
        }
    }
}

