/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.jasper.GeneratorVisitTracerFactory;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import java.text.MessageFormat;

@PointCut
public class JasperCompilerPointCut
extends TracerFactoryPointCut {
    public static String CURRENT_JSP_FILE_KEY = "CurrentJspFileKey";
    private static final ClassMatcher CLASS_MATCHER = new ExactClassMatcher("org/apache/jasper/compiler/Compiler");
    private static final MethodMatcher COMPILE_METHOD_1_MATCHER = new ExactMethodMatcher("compile", "(ZZ)V");
    private static final MethodMatcher COMPILE_METHOD_2_MATCHER = new ExactMethodMatcher("compile", "(Z)V");
    private static final MethodMatcher METHOD_MATCHER = OrMethodMatcher.getMethodMatcher(COMPILE_METHOD_1_MATCHER, COMPILE_METHOD_2_MATCHER);

    public JasperCompilerPointCut(PointCutClassTransformer classTransformer) {
        super(JasperCompilerPointCut.class, CLASS_MATCHER, METHOD_MATCHER);
    }

    @Override
    public Tracer doGetTracer(Transaction tx, ClassMethodSignature sig, Object compiler, Object[] args) {
        Tracer parent = tx.getTransactionActivity().getLastTracer();
        if (parent != null && parent instanceof JasperCompilerTracer) {
            return null;
        }
        try {
            String page;
            Object context = compiler.getClass().getMethod("getCompilationContext", new Class[0]).invoke(compiler, new Object[0]);
            if (context != null && (page = (String)context.getClass().getMethod("getJspFile", new Class[0]).invoke(context, new Object[0])) != null) {
                String msg = MessageFormat.format("Compiling JSP: {0}", page);
                Agent.LOG.fine(msg);
                GeneratorVisitTracerFactory.noticeJspCompile(tx, page);
                JasperCompilerTracer tracer = new JasperCompilerTracer(tx, sig, compiler, new SimpleMetricNameFormat("View" + page.replace('.', '_') + "/Compile"));
                return tracer;
            }
        }
        catch (Throwable t2) {
            Agent.LOG.severe("Unable to generate a Jasper compilation metric: " + t2.getMessage());
        }
        return null;
    }

    private final class JasperCompilerTracer
    extends DefaultTracer {
        public JasperCompilerTracer(Transaction tx, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter) {
            super(tx, sig, object, metricNameFormatter, 0);
        }
    }
}

