/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.config.JmxConfig;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.extension.Extension;
import com.newrelic.agent.jmx.JmxAttributeProcessor;
import com.newrelic.agent.jmx.JmxAttributeProcessorWrapper;
import com.newrelic.agent.jmx.LinkingMetadataRegistration;
import com.newrelic.agent.jmx.create.JmxGet;
import com.newrelic.agent.jmx.create.JmxInvoke;
import com.newrelic.agent.jmx.create.JmxObjectFactory;
import com.newrelic.agent.jmx.metrics.JmxFrameworkValues;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;

public class JmxService
extends AbstractService
implements HarvestListener {
    private static final int INVOKE_ERROR_COUNT_MAX = 5;
    private static final String J2EE_STATS_ATTRIBUTE_PROCESSOR_CLASS_NAME = "com.newrelic.agent.jmx.J2EEStatsAttributeProcessor";
    private final Set<JmxAttributeProcessor> jmxAttributeProcessors = new HashSet<JmxAttributeProcessor>();
    private final JmxObjectFactory jmxMetricFactory;
    private final List<JmxGet> jmxGets = new LinkedList<JmxGet>();
    private final List<JmxInvoke> jmxInvokes = new LinkedList<JmxInvoke>();
    private final Queue<JmxFrameworkValues> toBeAdded = new ConcurrentLinkedQueue<JmxFrameworkValues>();
    private final Set<MBeanServer> alwaysIncludeMBeanServers = new CopyOnWriteArraySet<MBeanServer>();
    private final Set<MBeanServer> toRemoveMBeanServers = new CopyOnWriteArraySet<MBeanServer>();
    private final JmxConfig jmxConfig;

    public JmxService(JmxConfig jmxConfig) {
        super(JmxService.class.getSimpleName());
        this.jmxConfig = jmxConfig;
        this.jmxMetricFactory = JmxObjectFactory.createJmxFactory();
    }

    @VisibleForTesting
    public List<JmxGet> getConfigurations() {
        return Collections.unmodifiableList(this.jmxGets);
    }

    public void addJmxAttributeProcessor(JmxAttributeProcessor attributeProcessor) {
        this.jmxAttributeProcessors.add(attributeProcessor);
    }

    @Override
    protected void doStart() {
        if (this.jmxConfig.isEnabled()) {
            this.registerAgentMBeans();
            this.jmxMetricFactory.getStartUpJmxObjects(this.jmxGets, this.jmxInvokes);
            if (this.jmxGets.size() > 0) {
                ServiceFactory.getHarvestService().addHarvestListener(this);
            }
            this.addJmxAttributeProcessor(JmxAttributeProcessorWrapper.createInstance(J2EE_STATS_ATTRIBUTE_PROCESSOR_CLASS_NAME));
        }
    }

    @Override
    public final boolean isEnabled() {
        return this.jmxConfig.isEnabled();
    }

    public void addJmxFrameworkValues(JmxFrameworkValues jmxValues) {
        if (this.jmxConfig.isEnabled()) {
            this.toBeAdded.add(jmxValues);
        }
    }

    @Override
    protected void doStop() {
        this.jmxGets.clear();
        this.jmxInvokes.clear();
        this.jmxAttributeProcessors.clear();
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        if (Agent.LOG.isFinerEnabled()) {
            Agent.LOG.log(Level.FINER, MessageFormat.format("Harvesting JMX metrics for {0}", appName));
        }
        try {
            this.process(statsEngine);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unexpected error querying MBeans in JMX service: ", e.toString());
            this.getLogger().finer(msg);
        }
    }

    @Override
    public void afterHarvest(String appName) {
    }

    public void setJmxServer(MBeanServer server) {
        if (server != null && !this.alwaysIncludeMBeanServers.contains(server)) {
            Agent.LOG.log(Level.FINE, "JMX Service : MBeanServer of type {0} was added.", server.getClass().getName());
            this.alwaysIncludeMBeanServers.add(server);
        }
    }

    public void removeJmxServer(MBeanServer serverToRemove) {
        if (serverToRemove != null) {
            Agent.LOG.log(Level.FINE, "JMX Service : MBeanServer of type {0} was removed.", serverToRemove.getClass().getName());
            this.toRemoveMBeanServers.add(serverToRemove);
        }
    }

    public boolean iteratedObjectNameKeysEnabled() {
        return this.jmxConfig.enableIteratedObjectNameKeys();
    }

    private void process(StatsEngine statsEngine, Collection<MBeanServer> srvrList, JmxGet config) {
        ObjectName name = config.getObjectName();
        if (name == null) {
            return;
        }
        for (MBeanServer server : srvrList) {
            try {
                Set<ObjectInstance> queryMBeans = server.queryMBeans(name, null);
                this.getLogger().finer(MessageFormat.format("JMX Service : MBeans query {0}, matches {1}", name, queryMBeans.size()));
                HashMap<ObjectName, Map<String, Float>> mbeanToAttValues = new HashMap<ObjectName, Map<String, Float>>();
                for (ObjectInstance instance : queryMBeans) {
                    ObjectName actualName = instance.getObjectName();
                    String rootMetricName = config.getRootMetricName(actualName, server);
                    Collection<String> attributes = config.getAttributes();
                    HashMap<String, Float> values = new HashMap<String, Float>();
                    for (String attr : attributes) {
                        this.getLogger().finest(MessageFormat.format("Fetching attributes for mbean {0}", actualName));
                        this.getAttAndRecord(attr, name, server, instance, statsEngine, rootMetricName, values);
                    }
                    if (values.isEmpty()) continue;
                    mbeanToAttValues.put(actualName, values);
                }
                config.recordStats(statsEngine, mbeanToAttValues, server);
            }
            catch (Exception e) {
                this.getLogger().fine(MessageFormat.format("An error occurred fetching JMX object matching name {0}", name));
                this.getLogger().log(Level.FINEST, "JMX error", e);
            }
        }
    }

    private void getAttAndRecord(String attr, ObjectName name, MBeanServer server, ObjectInstance instance, StatsEngine statsEngine, String rootMetricName, Map<String, Float> values) {
        String[] compNames = attr.split("\\.");
        Object attrObj = this.getAttribute(name, server, instance, attr, compNames);
        if (attrObj == null) {
            return;
        }
        if (attrObj instanceof Attribute) {
            this.recordJmxValue(statsEngine, instance, (Attribute)attrObj, rootMetricName, attr, values);
        } else if (attrObj instanceof CompositeDataSupport) {
            if (compNames.length == 2) {
                this.recordJmxValue(statsEngine, instance, new Attribute(attr, ((CompositeDataSupport)attrObj).get(compNames[1])), rootMetricName, attr, values);
            } else {
                this.getLogger().fine(MessageFormat.format("Found CompositeDataSupport object for {0}, but no object attribute specified, correct syntax is object.attribute", attr));
            }
        } else {
            this.recordJmxValue(statsEngine, instance, new Attribute(attr, attrObj), rootMetricName, attr, values);
        }
    }

    private Object getAttribute(ObjectName name, MBeanServer server, ObjectInstance instance, String attr, String[] compNames) {
        try {
            return server.getAttribute(instance.getObjectName(), attr);
        }
        catch (AttributeNotFoundException e) {
            this.getLogger().fine(MessageFormat.format("Attribute {0} for metric {1} was not found", attr, name));
        }
        catch (Exception e) {
            this.getLogger().fine(MessageFormat.format("An error occurred fetching JMX attribute {0} for metric {1}", attr, name));
            this.getLogger().log(Level.FINEST, "JMX error", e);
        }
        try {
            return server.getAttribute(instance.getObjectName(), compNames[0]);
        }
        catch (AttributeNotFoundException e) {
            this.getLogger().fine(MessageFormat.format("Composite attribute {0} for metric {1} was not found", attr, name));
        }
        catch (Exception e) {
            this.getLogger().fine(MessageFormat.format("An error occurred fetching JMX composite attribute {0} for metric {1}", compNames[0], name));
            this.getLogger().log(Level.FINEST, "JMX error", e);
        }
        return null;
    }

    private void runThroughAndRemoveInvokes(Collection<MBeanServer> srvrList) {
        if (this.jmxInvokes.size() > 0) {
            Iterator<JmxInvoke> invokes = this.jmxInvokes.iterator();
            while (invokes.hasNext()) {
                JmxInvoke current = invokes.next();
                if (this.handleInvoke(srvrList, current)) {
                    invokes.remove();
                    continue;
                }
                current.incrementErrorCount();
                if (current.getErrorCount() < 5) continue;
                invokes.remove();
            }
        }
    }

    private boolean handleInvoke(Collection<MBeanServer> srvrList, JmxInvoke invoke) {
        ObjectName name = invoke.getObjectName();
        if (name == null) {
            return true;
        }
        boolean isSuccess = false;
        for (MBeanServer server : srvrList) {
            if (!this.invoke(server, invoke)) continue;
            isSuccess = true;
        }
        return isSuccess;
    }

    private boolean invoke(MBeanServer server, JmxInvoke current) {
        try {
            server.invoke(current.getObjectName(), current.getOperationName(), current.getParams(), current.getSignature());
            this.getLogger().fine(MessageFormat.format("Successfully invoked JMX server for {0}", current.getObjectNameString()));
            return true;
        }
        catch (Exception e) {
            this.getLogger().fine(MessageFormat.format("An error occurred invoking JMX server for {0}", current.getObjectNameString()));
            this.getLogger().log(Level.FINEST, "JMX error", e);
            return false;
        }
    }

    private void recordJmxValue(StatsEngine statsEngine, ObjectInstance instance, Attribute attribute, String rootMetric, String attName, Map<String, Float> values) {
        if (this.recordCustomJmxValue(statsEngine, instance, attribute, rootMetric, values)) {
            return;
        }
        this.recordNonCustomJmxValue(instance, attribute, attName, values);
    }

    private boolean recordCustomJmxValue(StatsEngine statsEngine, ObjectInstance instance, Attribute attribute, String metricName, Map<String, Float> values) {
        for (JmxAttributeProcessor processor : this.jmxAttributeProcessors) {
            if (!processor.process(statsEngine, instance, attribute, metricName, values)) continue;
            return true;
        }
        return false;
    }

    private void recordNonCustomJmxValue(ObjectInstance instance, Attribute attribute, String attName, Map<String, Float> values) {
        Object value = attribute.getValue();
        Number num = null;
        if (value instanceof Number) {
            num = (Number)value;
        } else if (value instanceof Boolean) {
            num = (Boolean)value != false ? 1 : 0;
        } else if (value != null) {
            try {
                num = Float.valueOf(Float.parseFloat(value.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (num != null) {
            this.getLogger().finer(MessageFormat.format("Recording JMX metric {0} : {1}", attName, value));
            values.put(attName, Float.valueOf(num.floatValue()));
        } else if (value == null) {
            this.getLogger().fine(MessageFormat.format("MBean {0} attribute {1} value is null", instance.getObjectName(), attName));
        } else {
            this.getLogger().fine(MessageFormat.format("MBean {0} attribute {1} is not a number ({2}/{3})", instance.getObjectName(), attName, value, value.getClass().getName()));
        }
    }

    private void process(StatsEngine statsEngine) {
        Collection<MBeanServer> srvrList = this.getServers();
        this.addNewFrameworks();
        this.runThroughAndRemoveInvokes(srvrList);
        for (JmxGet object : this.jmxGets) {
            this.process(statsEngine, srvrList, object);
        }
    }

    private Collection<MBeanServer> getServers() {
        AbstractCollection srvrList;
        if (this.alwaysIncludeMBeanServers.isEmpty() && this.toRemoveMBeanServers.isEmpty()) {
            srvrList = MBeanServerFactory.findMBeanServer(null);
        } else {
            srvrList = new HashSet<MBeanServer>(MBeanServerFactory.findMBeanServer(null));
            this.getLogger().log(Level.FINEST, "JMX Service : toRemove MBeansServers ({0})", this.toRemoveMBeanServers.size());
            srvrList.removeAll(this.toRemoveMBeanServers);
            this.getLogger().log(Level.FINEST, "JMX Service : toAdd MBeansServers ({0})", this.alwaysIncludeMBeanServers.size());
            srvrList.addAll(this.alwaysIncludeMBeanServers);
        }
        this.getLogger().log(Level.FINER, "JMX Service : querying MBeansServers ({0})", srvrList.size());
        return srvrList;
    }

    private void addNewFrameworks() {
        JmxFrameworkValues framework = this.toBeAdded.poll();
        while (framework != null) {
            this.jmxMetricFactory.convertFramework(framework, this.jmxGets, this.jmxInvokes);
            framework = this.toBeAdded.poll();
        }
    }

    public void reloadExtensions(Set<Extension> oldExtensions, Set<Extension> extensions) {
        Iterator<JmxGet> iterator = this.jmxGets.iterator();
        while (iterator.hasNext()) {
            if (!oldExtensions.contains(iterator.next().getOrigin())) continue;
            iterator.remove();
        }
        for (Extension newExtension : extensions) {
            this.jmxMetricFactory.addExtension(newExtension, this.jmxGets);
        }
    }

    private void registerAgentMBeans() {
        if (this.jmxConfig.registerLinkingMetadataMBean()) {
            new LinkingMetadataRegistration(Agent.LOG).registerLinkingMetadata();
        }
    }
}

