/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.TransactionErrorPriority;
import com.newrelic.agent.attributes.AttributeValidator;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.bridge.external.ExternalParameters;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.RetryException;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.util.Strings;
import com.newrelic.api.agent.AttributeHolder;
import com.newrelic.api.agent.InboundHeaders;
import com.newrelic.api.agent.OutboundHeaders;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public abstract class AbstractTracer
implements Tracer,
AttributeHolder {
    static final int INITIAL_PARAMETER_MAP_SIZE = 5;
    static final int INITIAL_PARAMETER_SET_SIZE = 5;
    protected static final String ATTRIBUTE_TYPE = "custom";
    private final TransactionActivity transactionActivity;
    private AttributeValidator attributeValidator;
    private Set<String> rollupMetricNames;
    private Set<String> exclusiveRollupMetricNames;
    Map<String, Object> customAttributes;
    Map<String, Object> agentAttributes;
    private Set<String> agentAttributeNamesForSpans;
    private String customPrefix = "Custom";
    private Boolean trackChildThreads = null;
    private Boolean trackCallBackRunnable = false;
    private AtomicReference<TracedException> tracerError = new AtomicReference<TracedException>(TracedException.NO_EXCEPTION);
    private final long startTimeInMillis;
    AtomicReference<Long> finishTime = new AtomicReference<Object>(null);
    private final String ATTRIBUTE_API_METHOD_NAME = "TracedMethod.addCustomAttributes";

    public AbstractTracer(Transaction transaction) {
        this(transaction.getTransactionActivity(), new AttributeValidator(ATTRIBUTE_TYPE));
    }

    public AbstractTracer(TransactionActivity txa, AttributeValidator attributeValidator) {
        this.transactionActivity = txa;
        this.startTimeInMillis = System.currentTimeMillis();
        this.attributeValidator = attributeValidator;
    }

    public final Transaction getTransaction() {
        return this.transactionActivity.getTransaction();
    }

    @Override
    public final TransactionActivity getTransactionActivity() {
        return this.transactionActivity;
    }

    protected Object getInvocationTarget() {
        return null;
    }

    public final Object invoke(Object methodName, Method method, Object[] args) {
        block14: {
            try {
                if (args == null) {
                    Agent.LOG.severe("Tracer.finish() was invoked with no arguments");
                } else if ("s" == methodName) {
                    if (args.length == 2) {
                        this.finish((Integer)args[0], args[1]);
                    } else {
                        Agent.LOG.severe(MessageFormat.format("Tracer.finish(int, Object) was invoked with {0} arguments(s)", args.length));
                    }
                } else if ("u" == methodName) {
                    if (args.length == 1) {
                        this.finish((Throwable)args[0]);
                    } else {
                        Agent.LOG.severe(MessageFormat.format("Tracer.finish(Throwable) was invoked with {0} arguments(s)", args.length));
                    }
                } else {
                    Agent.LOG.severe(MessageFormat.format("Tracer.finish was invoked with an unknown method: {0}", methodName));
                }
            }
            catch (RetryException e) {
                return this.invoke(methodName, method, args);
            }
            catch (Throwable t2) {
                if (!Agent.LOG.isLoggable(Level.FINE)) break block14;
                String msg = MessageFormat.format("An error occurred finishing method tracer {0} for signature {1} : {2}", this.getClass().getName(), this.getClassMethodSignature(), t2.toString());
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    Agent.LOG.log(Level.FINEST, msg, t2);
                }
                Agent.LOG.fine(msg);
            }
        }
        return null;
    }

    @Override
    public abstract ClassMethodSignature getClassMethodSignature();

    @Override
    public boolean isChildHasStackTrace() {
        return false;
    }

    public void nameTransaction(TransactionNamePriority priority) {
        try {
            ClassMethodSignature classMethodSignature = this.getClassMethodSignature();
            Object invocationTarget = this.getInvocationTarget();
            String className = invocationTarget == null ? classMethodSignature.getClassName() : invocationTarget.getClass().getName();
            String txName = className + "/" + classMethodSignature.getMethodName();
            Agent.LOG.log(Level.FINER, "Setting transaction name using instrumented class and method: {0}", txName);
            Transaction tx = this.transactionActivity.getTransaction();
            tx.setTransactionName(priority, false, this.customPrefix, txName);
        }
        catch (Throwable t2) {
            Agent.LOG.log(Level.FINEST, "nameTransaction", t2);
        }
    }

    public TracedMethod getParentTracedMethod() {
        return this.getParentTracer();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    protected Set<String> getRollupMetricNames() {
        return this.rollupMetricNames;
    }

    protected Set<String> getExclusiveRollupMetricNames() {
        return this.exclusiveRollupMetricNames;
    }

    public void addRollupMetricName(String ... metricNameParts) {
        if (this.rollupMetricNames == null) {
            this.rollupMetricNames = new HashSet<String>();
        }
        this.rollupMetricNames.add(Strings.join('/', metricNameParts));
    }

    public void setRollupMetricNames(String ... metricNames) {
        this.rollupMetricNames = new HashSet<String>(metricNames.length);
        this.rollupMetricNames.addAll(Arrays.asList(metricNames));
    }

    public void addExclusiveRollupMetricName(String ... metricNameParts) {
        if (this.exclusiveRollupMetricNames == null) {
            this.exclusiveRollupMetricNames = new HashSet<String>();
        }
        this.exclusiveRollupMetricNames.add(Strings.join('/', metricNameParts));
    }

    public void setCustomMetricPrefix(String prefix) {
        this.customPrefix = prefix;
    }

    public void setTrackChildThreads(boolean shouldTrack) {
        this.trackChildThreads = shouldTrack;
    }

    public boolean trackChildThreads() {
        if (null == this.trackChildThreads) {
            TracedMethod parent = this.getParentTracedMethod();
            if (null == parent) {
                return true;
            }
            return parent.trackChildThreads();
        }
        return this.trackChildThreads;
    }

    public void setTrackCallbackRunnable(boolean shouldTrack) {
        this.trackCallBackRunnable = shouldTrack;
    }

    public boolean isTrackCallbackRunnable() {
        return this.trackCallBackRunnable != false || this.isParentTrackCallbackRunnable();
    }

    private boolean isParentTrackCallbackRunnable() {
        TracedMethod parent = this.getParentTracedMethod();
        if (null == parent) {
            return false;
        }
        return parent.isTrackCallbackRunnable();
    }

    public void addOutboundRequestHeaders(OutboundHeaders outboundHeaders) {
        Agent.LOG.severe("addOutboundRequestHeaders is only supported on subclasses of DefaultTracer: {0}");
    }

    public void readInboundResponseHeaders(InboundHeaders inboundResponseHeaders) {
        Agent.LOG.severe("readInboundResponseHeaders is only supported on subclasses of DefaultTracer: {0}");
    }

    public void reportAsExternal(com.newrelic.api.agent.ExternalParameters externalParameters) {
        Agent.LOG.severe("reportAsExternal is only supported on subclasses of DefaultTracer: {0}");
    }

    public void reportAsExternal(ExternalParameters externalParameters) {
        Agent.LOG.severe("reportAsExternal is only supported on subclasses of DefaultTracer: {0}");
    }

    @Override
    public void markFinishTime() {
        this.finishTime.compareAndSet(null, System.nanoTime());
    }

    @Override
    public long getStartTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Override
    public com.newrelic.api.agent.ExternalParameters getExternalParameters() {
        return null;
    }

    @Override
    public void setNoticedError(Throwable throwable) {
        this.tracerError.compareAndSet(TracedException.NO_EXCEPTION, new TracedException(TransactionErrorPriority.API, throwable));
    }

    @Override
    public void setThrownException(Throwable throwable) {
        this.tracerError.compareAndSet(TracedException.NO_EXCEPTION, new TracedException(TransactionErrorPriority.TRACER, throwable));
    }

    @Override
    public boolean wasExceptionSetByAPI() {
        return this.tracerError.get().getPriority() == TransactionErrorPriority.API;
    }

    @Override
    public Throwable getException() {
        return this.tracerError.get().getException();
    }

    public void addCustomAttribute(String key, Number value) {
        this.setAttributeIfValid(key, value);
    }

    public void addCustomAttribute(String key, String value) {
        this.setAttributeIfValid(key, value);
    }

    public void addCustomAttribute(String key, boolean value) {
        this.setAttributeIfValid(key, value);
    }

    public void addCustomAttributes(Map<String, Object> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            Agent.LOG.log(Level.FINER, "Unable to add {0} attributes because {1} was invoked with a null or empty map", ATTRIBUTE_TYPE, "TracedMethod.addCustomAttributes");
            return;
        }
        for (Map.Entry<String, Object> current : attributes.entrySet()) {
            this.setAttributeIfValid(current.getKey(), current.getValue());
        }
    }

    private void setAttributeIfValid(String key, Object value) {
        Object verifiedValue = this.attributeValidator.verifyParameterAndReturnValue(key, value, "TracedMethod.addCustomAttributes");
        if (verifiedValue != null) {
            this.setAttribute(key, verifiedValue, true, true, false);
        }
    }

    private boolean shouldAddAttribute() {
        return this.getTransaction() != null && !this.getTransaction().getTransactionCounts().isOverTracerSegmentLimit();
    }

    public void setAttribute(String key, Object value, boolean checkLimits, boolean isCustom, boolean addAgentAttrToSpan) {
        if (checkLimits && !this.shouldAddAttribute()) {
            return;
        }
        if (value.getClass().isArray()) {
            value = Arrays.asList((Object[])value);
        }
        if (checkLimits) {
            this.getTransaction().getTransactionCounts().incrementSize(AbstractTracer.sizeof(value));
        }
        if (isCustom) {
            if (this.customAttributes == null) {
                this.customAttributes = new HashMap<String, Object>(1, 5.0f);
            }
            this.customAttributes.put(key, value);
        } else {
            if (this.agentAttributes == null) {
                this.agentAttributes = new HashMap<String, Object>(1, 5.0f);
            }
            this.agentAttributes.put(key, value);
            if (addAgentAttrToSpan) {
                if (this.agentAttributeNamesForSpans == null) {
                    this.agentAttributeNamesForSpans = new HashSet<String>(5);
                }
                this.agentAttributeNamesForSpans.add(key);
            }
        }
    }

    static int sizeof(Object value) {
        int size = 0;
        if (value == null) {
            return 0;
        }
        if (value instanceof String) {
            return ((String)value).length();
        }
        if (value instanceof StackTraceElement) {
            StackTraceElement elem = (StackTraceElement)value;
            return AbstractTracer.sizeof(elem.getClassName()) + AbstractTracer.sizeof(elem.getFileName()) + AbstractTracer.sizeof(elem.getMethodName()) + 10;
        }
        if (value instanceof Object[]) {
            for (Object obj : (Object[])value) {
                size += AbstractTracer.sizeof(obj);
            }
        }
        return size;
    }

    @Override
    public void setAgentAttribute(String key, Object value) {
        this.setAttribute(key, value, true, false, false);
    }

    @Override
    public void setAgentAttribute(String key, Object value, boolean addToSpan) {
        this.setAttribute(key, value, true, false, addToSpan);
    }

    @Override
    public void removeAgentAttribute(String key) {
        if (this.agentAttributes != null) {
            this.agentAttributes.remove(key);
        }
    }

    @Override
    public Object getAgentAttribute(String key) {
        return this.agentAttributes == null ? null : this.agentAttributes.get(key);
    }

    @Override
    public Map<String, Object> getAgentAttributes() {
        if (this.agentAttributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.agentAttributes);
    }

    @Override
    public Map<String, Object> getCustomAttributes() {
        if (this.customAttributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.customAttributes);
    }

    @Override
    public Set<String> getAgentAttributeNamesForSpans() {
        if (this.agentAttributeNamesForSpans == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.agentAttributeNamesForSpans);
    }

    public Object getCustomAttribute(String key) {
        return this.customAttributes == null ? null : this.customAttributes.get(key);
    }

    public static Tracer getParentTracerWithSpan(Tracer tracer) {
        Tracer current;
        for (current = tracer; current != null && !current.isTransactionSegment(); current = current.getParentTracer()) {
        }
        return current;
    }

    private static class TracedException {
        private final TransactionErrorPriority priority;
        private final Throwable exception;
        static final TracedException NO_EXCEPTION = new TracedException(null, null);

        TracedException(TransactionErrorPriority priority, Throwable exception) {
            this.priority = priority;
            this.exception = exception;
        }

        public TransactionErrorPriority getPriority() {
            return this.priority;
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

