/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.bridge.external.ExternalParameters;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.trace.TransactionSegment;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.api.agent.InboundHeaders;
import com.newrelic.api.agent.OutboundHeaders;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class UltraLightTracer
implements Tracer {
    private final TransactionActivity txa;
    private final ClassMethodSignature classMethodSignature;
    private final Tracer parentTracer;
    private final long startNanos = System.nanoTime();
    private final AtomicLong endNanos = new AtomicLong();
    private final String segmentName;

    public static UltraLightTracer createClampedSegment(TransactionActivity txa, ClassMethodSignature classMethodSignature) {
        return new UltraLightTracer(txa, classMethodSignature, "Clamped");
    }

    private UltraLightTracer(TransactionActivity txa, ClassMethodSignature classMethodSignature, String metricPrefix) {
        this.txa = txa;
        this.classMethodSignature = classMethodSignature;
        this.parentTracer = txa.getLastTracer();
        this.segmentName = metricPrefix + "/" + classMethodSignature.getClassName() + "/" + classMethodSignature.getMethodName();
        txa.tracerStarted(this);
    }

    public void finish(int opcode, Object returnValue) {
        this.doFinish(opcode);
    }

    public void finish(Throwable throwable) {
        this.doFinish(191);
    }

    private void doFinish(int opcode) {
        this.endNanos.set(System.nanoTime());
        this.txa.tracerFinished(this, opcode);
        this.txa.getTransactionStats().getScopedStats().getOrCreateResponseTimeStats(this.segmentName).recordResponseTimeInNanos(this.getDuration());
        this.parentTracer.childTracerFinished(this);
    }

    public boolean isMetricProducer() {
        return true;
    }

    @Override
    public TransactionActivity getTransactionActivity() {
        return this.txa;
    }

    @Override
    public Tracer getParentTracer() {
        return this.parentTracer;
    }

    @Override
    public TransactionSegment getTransactionSegment(TransactionTracerConfig ttConfig, SqlObfuscator sqlObfuscator, long startTime, TransactionSegment lastSibling) {
        return new TransactionSegment(ttConfig, sqlObfuscator, startTime, this);
    }

    @Override
    public String getTransactionSegmentName() {
        return this.segmentName;
    }

    @Override
    public Map<String, Object> getAgentAttributes() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> getCustomAttributes() {
        return Collections.emptyMap();
    }

    @Override
    public ClassMethodSignature getClassMethodSignature() {
        return this.classMethodSignature;
    }

    @Override
    public boolean isTransactionSegment() {
        return false;
    }

    @Override
    public long getStartTimeInMillis() {
        return this.getStartTimeInMilliseconds();
    }

    @Override
    public long getStartTimeInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.startNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getEndTimeInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.endNanos.get(), TimeUnit.NANOSECONDS);
    }

    @Override
    public long getExclusiveDuration() {
        return this.getDuration();
    }

    @Override
    public long getDuration() {
        return this.endNanos.get() - this.startNanos;
    }

    @Override
    public String getMetricName() {
        return this.segmentName;
    }

    public void addCustomAttribute(String key, Number value) {
    }

    public void addCustomAttribute(String key, String value) {
    }

    public void addCustomAttribute(String key, boolean value) {
    }

    public void addCustomAttributes(Map<String, Object> attributes) {
    }

    @Override
    public long getStartTime() {
        return 0L;
    }

    @Override
    public long getEndTime() {
        return 0L;
    }

    @Override
    public long getDurationInMilliseconds() {
        return 0L;
    }

    @Override
    public long getRunningDurationInNanos() {
        return 0L;
    }

    public TracedMethod getParentTracedMethod() {
        return null;
    }

    public void setRollupMetricNames(String ... metricNames) {
    }

    public void setMetricNameFormatInfo(String metricName, String transactionSegmentName, String transactionSegmentUri) {
    }

    public void addExclusiveRollupMetricName(String ... metricNameParts) {
    }

    public void nameTransaction(TransactionNamePriority namePriority) {
    }

    public void setCustomMetricPrefix(String prefix) {
    }

    public void setTrackChildThreads(boolean shouldTrack) {
    }

    public boolean trackChildThreads() {
        return false;
    }

    public void setTrackCallbackRunnable(boolean shouldTrack) {
    }

    public boolean isTrackCallbackRunnable() {
        return false;
    }

    @Override
    public String getTransactionSegmentUri() {
        return null;
    }

    @Override
    public void setAgentAttribute(String key, Object value) {
    }

    @Override
    public void setAgentAttribute(String key, Object value, boolean addToSpan) {
    }

    @Override
    public void removeAgentAttribute(String key) {
    }

    @Override
    public Object getAgentAttribute(String key) {
        return null;
    }

    @Override
    public void childTracerFinished(Tracer child) {
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public void setParentTracer(Tracer tracer) {
    }

    @Override
    public boolean isParent() {
        return false;
    }

    @Override
    public boolean isChildHasStackTrace() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public void removeTransactionSegment() {
    }

    @Override
    public void markFinishTime() {
    }

    @Override
    public String getGuid() {
        return null;
    }

    @Override
    public com.newrelic.api.agent.ExternalParameters getExternalParameters() {
        return null;
    }

    @Override
    public Set<String> getAgentAttributeNamesForSpans() {
        return null;
    }

    @Override
    public void setNoticedError(Throwable throwable) {
    }

    @Override
    public Throwable getException() {
        return null;
    }

    @Override
    public void setThrownException(Throwable throwable) {
    }

    @Override
    public boolean wasExceptionSetByAPI() {
        return false;
    }

    public void setMetricName(String ... metricNameParts) {
    }

    public void addRollupMetricName(String ... metricNameParts) {
    }

    public void reportAsExternal(com.newrelic.api.agent.ExternalParameters externalParameters) {
    }

    public void addOutboundRequestHeaders(OutboundHeaders outboundHeaders) {
    }

    public void readInboundResponseHeaders(InboundHeaders inboundResponseHeaders) {
    }

    public void reportAsExternal(ExternalParameters externalParameters) {
    }

    public Object invoke(Object proxy, Method method, Object[] args) {
        return null;
    }
}

