/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util.asm;

import com.newrelic.agent.deps.com.google.common.collect.ListMultimap;
import com.newrelic.agent.deps.com.google.common.collect.Multimap;
import com.newrelic.agent.deps.com.google.common.collect.Multimaps;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class AnnotationDetails
extends AnnotationVisitor {
    final String desc;
    private ListMultimap<String, Object> attributes;

    public AnnotationDetails(AnnotationVisitor av, String desc) {
        super(589824, av);
        this.desc = desc;
    }

    public List<Object> getValues(String name) {
        if (this.attributes == null) {
            return Collections.emptyList();
        }
        return this.attributes.get((Object)name);
    }

    public Object getValue(String name) {
        List<Object> values = this.getValues(name);
        if (values.isEmpty()) {
            return null;
        }
        return values.iterator().next();
    }

    @Override
    public void visit(String name, Object value) {
        this.getOrCreateAttributes().put(name, value);
        super.visit(name, value);
    }

    Multimap<String, Object> getOrCreateAttributes() {
        if (this.attributes == null) {
            this.attributes = Multimaps.newListMultimap(new HashMap(), ArrayList::new);
        }
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationDetails annotationDetails = (AnnotationDetails)obj;
        return Objects.equals(this.desc, annotationDetails.desc) && Objects.equals(this.attributes, annotationDetails.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.desc, this.attributes);
    }

    public String toString() {
        return "AnnotationDetails [desc=" + this.desc + ", attributes=" + this.attributes + "]";
    }
}

