/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.deps.org.apache.commons.lang3.StringUtils;
import java.lang.instrument.Instrumentation;

public class JbossUtils {
    public static final String JBOSS_MODULES_MAIN_CLASS = "org/jboss/modules/Main.class";
    public static final String JBOSS_MODULES_MAIN = "org.jboss.modules.Main";
    public static final String NR_JBOSS_JSR_77_FIX = "com.newrelic.jboss.jsr77.fix";
    public static final String JBOSS_MODULES_SYSTEM_PKGS = "jboss.modules.system.pkgs";
    public static final String COM_NR_INSTRUMENTATION_SECURITY = "com.nr.instrumentation.security";
    public static final String JAVA_UTIL_LOGGING = "java.util.logging";
    public static final String JAVA_LANG_MANAGEMENT = "java.lang.management";
    public static final String JAVAX_MANAGEMENT = "javax.management";

    public void checkAndApplyJbossAdjustments(Instrumentation inst) {
        if (this.isJbossServer(inst)) {
            String cur = System.getProperty(JBOSS_MODULES_SYSTEM_PKGS);
            if (StringUtils.isBlank(cur)) {
                System.setProperty(JBOSS_MODULES_SYSTEM_PKGS, this.getJbossSystemPackages());
            } else if (!StringUtils.containsIgnoreCase(cur, COM_NR_INSTRUMENTATION_SECURITY)) {
                System.setProperty(JBOSS_MODULES_SYSTEM_PKGS, cur + "," + this.getJbossSystemPackages());
            }
        }
    }

    public String getJbossSystemPackages() {
        String defaultJbossSysPackages = String.join((CharSequence)",", JAVA_UTIL_LOGGING, COM_NR_INSTRUMENTATION_SECURITY, JAVA_LANG_MANAGEMENT);
        String jsr77FixProp = System.getProperty(NR_JBOSS_JSR_77_FIX);
        if (Boolean.TRUE.toString().equalsIgnoreCase(jsr77FixProp)) {
            return defaultJbossSysPackages;
        }
        return "javax.management," + defaultJbossSysPackages;
    }

    public boolean isJbossServer(Instrumentation inst) {
        if (ClassLoader.getSystemClassLoader().getResource(JBOSS_MODULES_MAIN_CLASS) != null) {
            return true;
        }
        return JbossUtils.isClassLoaded(JBOSS_MODULES_MAIN, inst);
    }

    private static boolean isClassLoaded(String className, Instrumentation instrumentation) {
        if (instrumentation == null || className == null) {
            throw new IllegalArgumentException("instrumentation and className must not be null");
        }
        Class[] classes = instrumentation.getAllLoadedClasses();
        if (classes != null) {
            for (Class klass : classes) {
                if (!className.equals(klass.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

