/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave;

import com.newrelic.agent.deps.org.objectweb.asm.Label;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Opcodes;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.AnalyzerAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.LocalVariablesSorter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.MethodRemapper;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Remapper;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.TryCatchBlockNode;
import com.newrelic.weave.utils.ReturnInsnProcessor;
import com.newrelic.weave.utils.WeaveUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MethodCallInlinerAdapter
extends LocalVariablesSorter {
    private List<TryCatchBlockNode> inlinedTryCatchBlocks = null;
    private final AnalyzerAdapter analyzerAdapter;
    private Map<String, InlinedMethod> inliners;
    static InlinedMethod DO_NOT_INLINE = new InlinedMethod(null, null);

    public MethodCallInlinerAdapter(String owner, int access, String name, String desc, MethodVisitor next, boolean inlineFrames) {
        this(589824, owner, access, name, desc, next, inlineFrames);
    }

    protected MethodCallInlinerAdapter(int api, String owner, int access, String name, String desc, MethodVisitor next, boolean inlineFrames) {
        super(api, access, desc, MethodCallInlinerAdapter.getNext(owner, access, name, desc, next, inlineFrames));
        this.analyzerAdapter = inlineFrames ? (AnalyzerAdapter)this.mv : null;
        this.mv = new InlinedTryCatchBlockSorter(589824, this.mv, access, name, desc, null, null);
    }

    private static MethodVisitor getNext(String owner, int access, String name, String desc, MethodVisitor next, boolean inlineFrames) {
        MethodVisitor mv = next;
        if (inlineFrames) {
            mv = new AnalyzerAdapter(owner, access, name, desc, mv);
        }
        return mv;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        InlinedMethod inliner = this.getInliner(owner, name, desc);
        if (inliner == DO_NOT_INLINE) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        if (inliner.inliner == null) {
            MethodVisitor mv = this.mv;
            if (this.analyzerAdapter != null) {
                mv = new MergeFrameAdapter(this.api, this.analyzerAdapter, mv);
            }
            if (inliner.method.tryCatchBlocks != null && !inliner.method.tryCatchBlocks.isEmpty()) {
                if (this.inlinedTryCatchBlocks == null) {
                    this.inlinedTryCatchBlocks = new ArrayList<TryCatchBlockNode>();
                }
                this.inlinedTryCatchBlocks.addAll(inliner.method.tryCatchBlocks);
            }
            int access = opcode == 184 ? 8 : 0;
            inliner.inliner = new InliningAdapter(this.api, access, desc, this, mv, inliner.remapper);
        }
        inliner.method.accept(inliner.inliner);
    }

    protected abstract InlinedMethod mustInline(String var1, String var2, String var3);

    private InlinedMethod getInliner(String owner, String name, String desc) {
        String key;
        InlinedMethod method;
        if (this.inliners == null) {
            this.inliners = new HashMap<String, InlinedMethod>();
        }
        if ((method = this.inliners.get(key = owner + "." + name + desc)) == null) {
            method = this.mustInline(owner, name, desc);
            if (method == null) {
                method = DO_NOT_INLINE;
            } else {
                MethodNode methodNodeCopy = WeaveUtils.copy(method.method);
                if (this.shouldClearReturnStacks(name, desc)) {
                    MethodNode result = WeaveUtils.newMethodNode(methodNodeCopy);
                    methodNodeCopy.accept(new ClearReturnAdapter(owner, methodNodeCopy, result));
                    methodNodeCopy = result;
                }
                methodNodeCopy.instructions.resetLabels();
                InliningAdapter originalInliner = method.inliner;
                method = new InlinedMethod(methodNodeCopy, method.remapper);
                method.inliner = originalInliner;
            }
            this.inliners.put(key, method);
        }
        return method;
    }

    private boolean shouldClearReturnStacks(String name, String desc) {
        if (this.clearReturnStacksDisabled()) {
            return false;
        }
        String invokeSuspendName = "invokeSuspend";
        String invokeSuspendDesc = "(Ljava/lang/Object;)Ljava/lang/Object;";
        return "invokeSuspend".equals(name) && "(Ljava/lang/Object;)Ljava/lang/Object;".equals(desc);
    }

    private boolean clearReturnStacksDisabled() {
        String enabled = System.getProperty("newrelic.config.class_transformer.clear_return_stacks", "true");
        return enabled.equalsIgnoreCase("false");
    }

    private class InlinedTryCatchBlockSorter
    extends MethodNode {
        public InlinedTryCatchBlockSorter(int api, MethodVisitor mv, int access, String name, String desc, String signature, String[] exceptions) {
            super(api, access, name, desc, signature, exceptions);
            this.mv = mv;
        }

        private boolean isInlinedTryCatch(TryCatchBlockNode t2) {
            return null != MethodCallInlinerAdapter.this.inlinedTryCatchBlocks && MethodCallInlinerAdapter.this.inlinedTryCatchBlocks.contains(t2);
        }

        @Override
        public void visitEnd() {
            if (null != MethodCallInlinerAdapter.this.inlinedTryCatchBlocks) {
                int numTryCatchBlocks = MethodCallInlinerAdapter.this.inlinedTryCatchBlocks.size();
                MethodCallInlinerAdapter.this.inlinedTryCatchBlocks = new ArrayList(numTryCatchBlocks);
                for (int i = this.tryCatchBlocks.size() - numTryCatchBlocks; i < this.tryCatchBlocks.size(); ++i) {
                    MethodCallInlinerAdapter.this.inlinedTryCatchBlocks.add(this.tryCatchBlocks.get(i));
                }
                Comparator<TryCatchBlockNode> comp = new Comparator<TryCatchBlockNode>(){

                    @Override
                    public int compare(TryCatchBlockNode t1, TryCatchBlockNode t2) {
                        boolean isT1Inlined = InlinedTryCatchBlockSorter.this.isInlinedTryCatch(t1);
                        boolean isT2Inlined = InlinedTryCatchBlockSorter.this.isInlinedTryCatch(t2);
                        if (isT1Inlined && isT2Inlined) {
                            return 0;
                        }
                        if (isT1Inlined) {
                            return -1;
                        }
                        if (isT2Inlined) {
                            return 1;
                        }
                        return 0;
                    }
                };
                Collections.sort(this.tryCatchBlocks, comp);
                for (int i = 0; i < this.tryCatchBlocks.size(); ++i) {
                    ((TryCatchBlockNode)this.tryCatchBlocks.get(i)).updateIndex(i);
                }
                MethodCallInlinerAdapter.this.inlinedTryCatchBlocks.clear();
            }
            if (this.mv != null) {
                this.accept(this.mv);
            }
        }
    }

    static class MergeFrameAdapter
    extends MethodVisitor {
        private final AnalyzerAdapter analyzerAdapter;

        public MergeFrameAdapter(int api, AnalyzerAdapter analyzerAdapter, MethodVisitor next) {
            super(api, next);
            this.analyzerAdapter = analyzerAdapter;
        }

        @Override
        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
            int i;
            List<Object> callerLocal = this.analyzerAdapter.locals;
            int nCallerLocal = callerLocal == null ? 0 : callerLocal.size();
            int nMergedLocal = Math.max(nCallerLocal, nLocal);
            Object[] mergedLocal = new Object[nMergedLocal];
            for (i = 0; i < nCallerLocal; ++i) {
                if (callerLocal.get(i) == Opcodes.TOP) continue;
                mergedLocal[i] = callerLocal.get(i);
            }
            for (i = 0; i < nLocal; ++i) {
                if (local[i] == Opcodes.TOP) continue;
                mergedLocal[i] = local[i];
            }
            List<Object> callerStack = this.analyzerAdapter.stack;
            int nCallerStack = callerStack == null ? 0 : callerStack.size();
            int nMergedStack = nCallerStack + nStack;
            Object[] mergedStack = new Object[nMergedStack];
            for (int i2 = 0; i2 < nCallerStack; ++i2) {
                mergedStack[i2] = callerStack.get(i2);
            }
            if (nStack > 0) {
                System.arraycopy(stack, 0, mergedStack, nCallerStack, nStack);
            }
            super.visitFrame(type, nMergedLocal, mergedLocal, nMergedStack, mergedStack);
        }
    }

    class ClearReturnAdapter
    extends MethodNode {
        String owner;

        public ClearReturnAdapter(String owner, MethodNode source, MethodVisitor next) {
            super(589824, source.access, source.name, source.desc, source.signature, source.exceptions.toArray(new String[source.exceptions.size()]));
            this.mv = next;
            this.owner = owner;
        }

        @Override
        public void visitEnd() {
            ReturnInsnProcessor.clearReturnStacks(this.owner, this);
            this.accept(this.mv);
        }
    }

    class InliningAdapter
    extends LocalVariablesSorter {
        private final int access;
        private final String desc;
        private final LocalVariablesSorter caller;
        private Label end;

        public InliningAdapter(int api, int access, String desc, LocalVariablesSorter caller, MethodVisitor next, Remapper remapper) {
            super(api, access, desc, new MethodRemapper(next, remapper));
            this.access = access;
            this.desc = desc;
            this.caller = caller;
        }

        @Override
        public void visitCode() {
            int i;
            super.visitCode();
            int off = (this.access & 8) != 0 ? 0 : 1;
            Type[] args2 = Type.getArgumentTypes(this.desc);
            int argRegister = off;
            for (i = 0; i < args2.length; ++i) {
                argRegister += args2[i].getSize();
            }
            for (i = args2.length - 1; i >= 0; --i) {
                this.visitVarInsn(args2[i].getOpcode(54), argRegister -= args2[i].getSize());
            }
            if (off > 0) {
                this.visitVarInsn(58, 0);
            }
            this.end = new Label();
        }

        @Override
        public void visitInsn(int opcode) {
            if (opcode >= 172 && opcode <= 177) {
                super.visitJumpInsn(167, this.end);
            } else {
                super.visitInsn(opcode);
            }
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            super.visitVarInsn(opcode, var + this.firstLocal);
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            super.visitIincInsn(var + this.firstLocal, increment);
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            super.visitLocalVariable(name, desc, signature, start, end, index + this.firstLocal);
        }

        @Override
        public void visitMaxs(int stack, int locals) {
            super.visitLabel(this.end);
        }

        @Override
        public void visitEnd() {
        }

        @Override
        protected int newLocalMapping(Type type) {
            return this.caller.newLocal(type);
        }
    }

    public static class InlinedMethod {
        public final MethodNode method;
        public final Remapper remapper;
        InliningAdapter inliner;

        public InlinedMethod(MethodNode method, Remapper remapper) {
            this.method = method;
            this.remapper = remapper;
        }
    }
}

