/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import java.util.Map;

public class DistributedTracingConfig
extends BaseConfig {
    private static final boolean DEFAULT_DISTRIBUTED_TRACING = true;
    private static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.distributed_tracing.";
    public static final String ENABLED = "enabled";
    public static final String TRUSTED_ACCOUNT_KEY = "trusted_account_key";
    public static final String ACCOUNT_ID = "account_id";
    public static final String PRIMARY_APPLICATION_ID = "primary_application_id";
    public static final String DISTRIBUTED_TRACING_ENABLED = "newrelic.config.distributed_tracing.enabled";
    public static final String ENABLED_ENV_KEY = "NEW_RELIC_DISTRIBUTED_TRACING_ENABLED";
    public static final String EXCLUDE_NEWRELIC_HEADER = "exclude_newrelic_header";
    public static final String SAMPLER = "sampler";
    public static final String REMOTE_PARENT_SAMPLED = "remote_parent_sampled";
    public static final String REMOTE_PARENT_NOT_SAMPLED = "remote_parent_not_sampled";
    public static final String SAMPLE_ALWAYS_ON = "always_on";
    public static final String SAMPLE_ALWAYS_OFF = "always_off";
    public static final String SAMPLE_DEFAULT = "default";
    private final boolean enabled = this.getProperty("enabled", true);
    private final String trustedAccountKey = (String)this.getProperty("trusted_account_key");
    private final String accountId = (String)this.getProperty("account_id");
    private final String primaryApplicationId = (String)this.getProperty("primary_application_id");
    private final boolean includeNewRelicHeader = this.getProperty("exclude_newrelic_header", false) == false;
    private final String remoteParentSampled;
    private final String remoteParentNotSampled;

    DistributedTracingConfig(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
        BaseConfig samplerConfig = new BaseConfig(this.nestedProps(SAMPLER), "newrelic.config.distributed_tracing..sampler");
        this.remoteParentSampled = samplerConfig.getProperty(REMOTE_PARENT_SAMPLED, SAMPLE_DEFAULT);
        this.remoteParentNotSampled = samplerConfig.getProperty(REMOTE_PARENT_NOT_SAMPLED, SAMPLE_DEFAULT);
    }

    public String getTrustedAccountKey() {
        return this.trustedAccountKey;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getPrimaryApplicationId() {
        return this.primaryApplicationId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public boolean isIncludeNewRelicHeader() {
        return this.includeNewRelicHeader;
    }

    public String getRemoteParentSampled() {
        return this.remoteParentSampled;
    }

    public String getRemoteParentNotSampled() {
        return this.remoteParentNotSampled;
    }
}

