/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tosummary;

import com.newrelic.jfr.ThreadNameNormalizer;
import com.newrelic.jfr.Workarounds;
import com.newrelic.jfr.tosummary.EventToSummary;
import com.newrelic.telemetry.metrics.Summary;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import jdk.jfr.consumer.RecordedEvent;

public abstract class AbstractThreadDispatchingSummarizer
implements EventToSummary {
    protected final Map<String, EventToSummary> perThread = new HashMap<String, EventToSummary>();
    protected final ThreadNameNormalizer nameNormalizer;

    public AbstractThreadDispatchingSummarizer(ThreadNameNormalizer nameNormalizer) {
        this.nameNormalizer = nameNormalizer;
    }

    @Override
    public Stream<Summary> summarize() {
        return this.perThread.values().stream().flatMap(EventToSummary::summarize);
    }

    @Override
    public void reset() {
        this.perThread.clear();
    }

    @Override
    public abstract String getEventName();

    public abstract EventToSummary createPerThreadSummarizer(String var1, long var2);

    @Override
    public void accept(RecordedEvent ev) {
        Optional<String> possibleGroupedThreadName = this.groupedName(ev);
        possibleGroupedThreadName.ifPresent(groupedThreadName -> {
            if (this.perThread.get(groupedThreadName) == null) {
                this.perThread.put((String)groupedThreadName, this.createPerThreadSummarizer((String)groupedThreadName, ev.getStartTime().toEpochMilli()));
            }
            this.perThread.get(groupedThreadName).accept(ev);
        });
    }

    protected Optional<String> groupedName(RecordedEvent ev) {
        Optional<String> possibleThreadName = Workarounds.getThreadName(ev);
        if (possibleThreadName.isPresent()) {
            String normalizedThreadName = this.nameNormalizer.getNormalizedThreadName(possibleThreadName.get());
            return Optional.ofNullable(normalizedThreadName);
        }
        return Optional.empty();
    }
}

