/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry;

import com.newrelic.telemetry.BaseConfig;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.events.EventBatchSender;
import com.newrelic.telemetry.http.HttpPoster;
import java.util.function.Supplier;

public interface EventBatchSenderFactory {
    default public EventBatchSender createBatchSender(String apiKey) {
        SenderConfiguration.SenderConfigurationBuilder configuration = EventBatchSender.configurationBuilder().apiKey(apiKey).httpPoster(this.getPoster());
        return EventBatchSender.create(configuration.build());
    }

    default public SenderConfiguration.SenderConfigurationBuilder configureWith(BaseConfig baseConfig) {
        return this.configureWith(baseConfig.getApiKey()).secondaryUserAgent(baseConfig.getSecondaryUserAgent()).auditLoggingEnabled(baseConfig.isAuditLoggingEnabled());
    }

    default public SenderConfiguration.SenderConfigurationBuilder configureWith(String apiKey) {
        return EventBatchSender.configurationBuilder().apiKey(apiKey).httpPoster(this.getPoster());
    }

    public HttpPoster getPoster();

    public static EventBatchSenderFactory fromHttpImplementation(Supplier<HttpPoster> creator) {
        return creator::get;
    }
}

