/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.org.apache.logging.log4j.core.config.yaml;

import com.newrelic.agent.deps.org.apache.logging.log4j.core.LoggerContext;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.Configuration;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.ConfigurationFactory;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.ConfigurationSource;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.Order;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.yaml.YamlConfiguration;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.util.Loader;

@Plugin(name="YamlConfigurationFactory", category="ConfigurationFactory")
@Order(value=7)
public class YamlConfigurationFactory
extends ConfigurationFactory {
    private static final String[] SUFFIXES = new String[]{".yml", ".yaml"};
    private static final String[] dependencies = new String[]{"com.newrelic.agent.deps.com.fasterxml.jackson.databind.ObjectMapper", "com.newrelic.agent.deps.com.fasterxml.jackson.databind.JsonNode", "com.newrelic.agent.deps.com.fasterxml.jackson.core.JsonParser", "com.newrelic.agent.deps.com.fasterxml.jackson.dataformat.yaml.YAMLFactory"};
    private final boolean isActive;

    public YamlConfigurationFactory() {
        for (String dependency : dependencies) {
            if (Loader.isClassAvailable(dependency)) continue;
            LOGGER.debug("Missing dependencies for Yaml support, ConfigurationFactory {} is inactive", (Object)this.getClass().getName());
            this.isActive = false;
            return;
        }
        this.isActive = true;
    }

    @Override
    protected boolean isActive() {
        return this.isActive;
    }

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source2) {
        if (!this.isActive) {
            return null;
        }
        return new YamlConfiguration(loggerContext, source2);
    }

    @Override
    public String[] getSupportedTypes() {
        return SUFFIXES;
    }
}

