/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.TransactionData;
import com.newrelic.agent.attributes.AttributesUtils;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.environment.EnvironmentService;
import com.newrelic.agent.json.AttributeFilters;
import com.newrelic.agent.model.AttributeFilter;
import com.newrelic.agent.model.SpanError;
import com.newrelic.agent.model.SpanEvent;
import com.newrelic.agent.service.analytics.LimitedSizeHashMap;
import com.newrelic.agent.service.analytics.SpanErrorBuilder;
import com.newrelic.agent.service.analytics.SpanEventFactory;
import com.newrelic.agent.service.analytics.TransactionDataToDistributedTraceIntrinsics;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.AbstractTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracing.DistributedTracePayloadImpl;
import com.newrelic.agent.tracing.SpanProxy;
import com.newrelic.agent.tracing.W3CTraceState;
import com.newrelic.agent.tracing.W3CTraceStateSupport;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class TracerToSpanEvent {
    private static final Set<String> UNWANTED_SPAN_ATTRIBUTES = new HashSet<String>(Arrays.asList("databaseCallCount", "databaseDuration", "externalCallCount", "externalDuration", "gcCumulative", "memcacheDuration", "nr.apdexPerfZone", "totalTime", "transactionSubType", "transactionType", "nr.alternatePathHashes", "nr.guid", "nr.pathHash", "nr.referringTransactionGuid", "nr.tripId", "host.displayName", "process.instanceName", "nr.syntheticsJobId", "nr.syntheticsMonitorId", "nr.syntheticsResourceId", "parentSpanId", "priority", "sampled", "guid", "traceId"));
    private final Map<String, SpanErrorBuilder> errorBuilderForApp;
    private final AttributeFilter filter;
    private final Supplier<Long> timestampSupplier;
    private final EnvironmentService environmentService;
    private final TransactionDataToDistributedTraceIntrinsics transactionDataToDistributedTraceIntrinsics;
    private final SpanErrorBuilder defaultSpanErrorBuilder;

    public TracerToSpanEvent(Map<String, SpanErrorBuilder> errorBuilderForApp, EnvironmentService environmentService, TransactionDataToDistributedTraceIntrinsics transactionDataToDistributedTraceIntrinsics, SpanErrorBuilder defaultSpanErrorBuilder) {
        this(errorBuilderForApp, AttributeFilters.SPAN_EVENTS_ATTRIBUTE_FILTER, SpanEventFactory.DEFAULT_SYSTEM_TIMESTAMP_SUPPLIER, environmentService, transactionDataToDistributedTraceIntrinsics, defaultSpanErrorBuilder);
    }

    TracerToSpanEvent(Map<String, SpanErrorBuilder> errorBuilderForApp, AttributeFilter filter, Supplier<Long> timestampSupplier, EnvironmentService environmentService, TransactionDataToDistributedTraceIntrinsics transactionDataToDistributedTraceIntrinsics, SpanErrorBuilder defaultSpanErrorBuilder) {
        this.errorBuilderForApp = errorBuilderForApp;
        this.filter = filter;
        this.timestampSupplier = timestampSupplier;
        this.environmentService = environmentService;
        this.transactionDataToDistributedTraceIntrinsics = transactionDataToDistributedTraceIntrinsics;
        this.defaultSpanErrorBuilder = defaultSpanErrorBuilder;
    }

    public SpanEvent createSpanEvent(Tracer tracer, TransactionData transactionData, TransactionStats transactionStats, boolean isRoot, boolean crossProcessOnly) {
        SpanProxy spanProxy = transactionData.getSpanProxy();
        DistributedTracePayloadImpl inboundPayload = spanProxy.getInboundDistributedTracePayload();
        SpanEventFactory builder = new SpanEventFactory(transactionData.getApplicationName(), this.filter, this.timestampSupplier).setGuid(tracer.getGuid()).setClmAttributes(tracer.getAgentAttributes()).setTraceId(spanProxy.getOrCreateTraceId()).setSampled(transactionData.sampled()).setParentId(this.getParentId(tracer, transactionData, crossProcessOnly)).setTransactionId(transactionData.getGuid()).setDurationInSeconds((float)tracer.getDuration() / 1.0E9f).setName(tracer.getTransactionSegmentName()).setTimestamp(tracer.getStartTimeInMillis()).setPriority(transactionData.getPriority()).setExternalParameterAttributes(tracer.getExternalParameters()).setAgentAttributesMarkedForSpans(tracer.getAgentAttributeNamesForSpans(), tracer.getAgentAttributes()).setStackTraceAttributes(tracer.getAgentAttributes()).setIsRootSpanEvent(isRoot).setDecider(inboundPayload == null || inboundPayload.priority == null);
        builder = this.maybeSetError(tracer, transactionData, isRoot, builder);
        builder = this.maybeSetGraphQLAttributes(tracer, builder);
        W3CTraceState traceState = spanProxy.getInitiatingW3CTraceState();
        if (traceState != null) {
            if (isRoot && traceState.getGuid() != null) {
                builder.setTrustedParent(traceState.getGuid());
            }
            Set<String> vendorKeys = W3CTraceStateSupport.buildVendorKeys(traceState);
            builder.setTracingVendors(vendorKeys);
        }
        LimitedSizeHashMap<String, Object> spanUserAttributes = new LimitedSizeHashMap<String, Object>(64);
        spanUserAttributes.putAll(tracer.getCustomAttributes());
        if (isRoot) {
            this.copyTransactionAttributesToRootSpanBuilder(builder, transactionData, spanUserAttributes, transactionStats);
        }
        builder.putAllUserAttributes(spanUserAttributes);
        return builder.build();
    }

    private SpanEventFactory maybeSetGraphQLAttributes(Tracer tracer, SpanEventFactory builder) {
        Map<String, Object> agentAttributes = tracer.getAgentAttributes();
        boolean containsGraphQLAttributes = agentAttributes.keySet().stream().anyMatch(key -> key.contains("graphql"));
        if (containsGraphQLAttributes) {
            agentAttributes.entrySet().stream().filter(e -> ((String)e.getKey()).contains("graphql")).forEach(e -> builder.putAgentAttribute((String)e.getKey(), e.getValue()));
        }
        return builder;
    }

    private SpanEventFactory maybeSetError(Tracer tracer, TransactionData transactionData, boolean isRoot, SpanEventFactory builder) {
        SpanErrorBuilder spanErrorBuilder = this.errorBuilderForApp.get(transactionData.getApplicationName());
        SpanErrorBuilder spanErrorBuilder2 = spanErrorBuilder = spanErrorBuilder == null ? this.defaultSpanErrorBuilder : spanErrorBuilder;
        if (spanErrorBuilder.areErrorsEnabled()) {
            SpanError spanError = spanErrorBuilder.buildSpanError(tracer, isRoot, transactionData.getResponseStatus(), transactionData.getStatusMessage(), transactionData.getThrowable());
            return builder.setSpanError(spanError);
        }
        return builder;
    }

    private void copyTransactionAttributesToRootSpanBuilder(SpanEventFactory builder, TransactionData transactionData, LimitedSizeHashMap<String, Object> spanUserAttributes, TransactionStats transactionStats) {
        builder.putIntrinsicAttribute("transaction.name", transactionData.getPriorityTransactionName().getName());
        Integer port = this.environmentService.getEnvironment().getAgentIdentity().getServerPort();
        builder.putAgentAttribute("port", port);
        if (transactionStats.getUnscopedStats().getStatsMap().containsKey("WebFrontend/QueueTime")) {
            builder.putAgentAttribute("queueDuration", Float.valueOf(transactionStats.getUnscopedStats().getOrCreateResponseTimeStats("WebFrontend/QueueTime").getTotal()));
        }
        this.copyTransactionIntrinsicAttributes(builder, transactionData);
        this.copyDistributedTraceIntrinsicAttributes(builder, transactionData);
        this.copyTransactionAgentAttributes(builder, transactionData);
        this.copyTransactionUserAttributes(transactionData, spanUserAttributes);
    }

    private void copyTransactionIntrinsicAttributes(SpanEventFactory builder, TransactionData transactionData) {
        Map<String, Object> intrinsicAttributes = transactionData.getIntrinsicAttributes();
        Map<String, ?> filteredIntrinsics = this.filterAttributes(intrinsicAttributes);
        builder.putAllAgentAttributes(filteredIntrinsics);
    }

    private void copyDistributedTraceIntrinsicAttributes(SpanEventFactory builder, TransactionData transactionData) {
        Map<String, Object> distributedTraceIntrinsicAttributes = this.transactionDataToDistributedTraceIntrinsics.buildDistributedTracingIntrinsics(transactionData, false);
        if (distributedTraceIntrinsicAttributes != null) {
            Map<String, ?> filteredIntrinsics = this.filterAttributes(distributedTraceIntrinsicAttributes);
            builder.putAllAgentAttributes(filteredIntrinsics);
        }
    }

    private void copyTransactionAgentAttributes(SpanEventFactory builder, TransactionData transactionData) {
        Map<String, Object> agentAttributes = transactionData.getAgentAttributes();
        Map<String, ?> filteredAgentAttributes = this.filterAttributes(agentAttributes);
        builder.putAllAgentAttributes(filteredAgentAttributes);
        Map<String, Map<String, String>> prefixedAttributes = transactionData.getPrefixedAttributes();
        Map<String, ?> filteredPrefixedAttributes = this.filterAttributes(AttributesUtils.appendAttributePrefixes(prefixedAttributes));
        builder.putAllAgentAttributes(filteredPrefixedAttributes);
    }

    private void copyTransactionUserAttributes(TransactionData transactionData, LimitedSizeHashMap<String, Object> spanUserAttributes) {
        Map<String, Object> userAttributes = transactionData.getUserAttributes();
        Map<String, ?> filteredUserAttributes = this.filterAttributes(userAttributes);
        spanUserAttributes.putAllIfAbsent(filteredUserAttributes);
    }

    private Map<String, ?> filterAttributes(Map<String, ?> intrinsicAttributes) {
        return Maps.filterKeys(intrinsicAttributes, key -> !UNWANTED_SPAN_ATTRIBUTES.contains(key));
    }

    private String getParentId(Tracer tracer, TransactionData transactionData, boolean crossProcessOnly) {
        if (crossProcessOnly) {
            return null;
        }
        Tracer parentSegment = AbstractTracer.getParentTracerWithSpan(tracer.getParentTracer());
        if (parentSegment != null) {
            return parentSegment.getGuid();
        }
        DistributedTracePayloadImpl inboundPayload = transactionData.getInboundDistributedTracePayload();
        if (inboundPayload != null) {
            return inboundPayload.getGuid();
        }
        if (transactionData.getW3CTraceParent() != null) {
            return transactionData.getW3CTraceParent().getParentId();
        }
        return null;
    }
}

