/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.FieldVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Label;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import java.util.HashSet;
import java.util.Set;

public class ClassUtils {
    public static java.lang.reflect.Method findSuperDefinition(java.lang.reflect.Method method) {
        return ClassUtils.findSuperDefinition(method.getDeclaringClass(), method);
    }

    private static java.lang.reflect.Method findSuperDefinition(Class<?> clazz, java.lang.reflect.Method method) {
        Class<?>[] interfaces;
        for (Class<?> interfaceClass : interfaces = clazz.getInterfaces()) {
            try {
                return interfaceClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (Exception exception) {
                method = ClassUtils.findSuperDefinition(interfaceClass, method);
            }
        }
        Class<?> parentClass = clazz.getSuperclass();
        if (parentClass != null) {
            try {
                method = parentClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return ClassUtils.findSuperDefinition(parentClass, method);
        }
        return method;
    }

    public static Set<String> getClassReferences(byte[] classBytes) {
        ClassReader cr = new ClassReader(classBytes);
        final HashSet<String> classNames = new HashSet<String>();
        ClassVisitor cv = new ClassVisitor(589824){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.addType(Type.getObjectType(superName));
                for (String iFace : interfaces) {
                    this.addType(Type.getObjectType(iFace));
                }
            }

            @Override
            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                this.addType(Type.getType(desc));
                return null;
            }

            private void addType(Type type) {
                if (type == null) {
                    return;
                }
                if (type.getSort() == 9) {
                    this.addType(type.getElementType());
                } else if (type.getSort() == 10) {
                    classNames.add(type.getInternalName());
                }
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                this.addMethodClasses(name, desc);
                return new MethodVisitor(589824){

                    @Override
                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        this.addType(Type.getType(desc));
                    }

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        this.addMethodClasses(name, desc);
                    }

                    @Override
                    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                        this.addType(Type.getType(desc));
                    }
                };
            }

            private void addMethodClasses(String name, String desc) {
                Method method = new Method(name, desc);
                for (Type t2 : method.getArgumentTypes()) {
                    this.addType(t2);
                }
            }
        };
        cr.accept(cv, 4);
        return classNames;
    }
}

