/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.daemon;

import com.newrelic.agent.deps.org.slf4j.Logger;
import com.newrelic.agent.deps.org.slf4j.LoggerFactory;
import com.newrelic.jfr.daemon.JFRUploader;
import com.newrelic.jfr.daemon.JfrRecorder;
import com.newrelic.jfr.daemon.JfrRecorderException;
import com.newrelic.jfr.daemon.JfrRecorderFactory;
import com.newrelic.jfr.daemon.SafeSleep;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class JfrController {
    private static final Logger logger = LoggerFactory.getLogger(JfrController.class);
    private final ExecutorService executorService = Executors.newFixedThreadPool(2, r -> {
        Thread thread2 = new Thread(r, JfrController.class.getSimpleName());
        thread2.setDaemon(true);
        return thread2;
    });
    private final JfrRecorderFactory recorderFactory;
    private final JFRUploader uploader;
    private final Duration harvestInterval;
    private volatile boolean shutdown = false;
    private JfrRecorder jfrRecorder;

    public JfrController(JfrRecorderFactory recorderFactory, JFRUploader uploader, Duration harvestInterval) {
        this.recorderFactory = recorderFactory;
        this.uploader = uploader;
        this.harvestInterval = harvestInterval;
    }

    public void shutdown() {
        logger.info("Shutting down JfrController.");
        this.shutdown = true;
    }

    public void loop() throws JfrRecorderException {
        logger.info("Starting JfrController.");
        while (!this.shutdown) {
            SafeSleep.sleep(this.harvestInterval);
            if (this.jfrRecorder == null) {
                this.resetJfrRecorder();
            }
            try {
                Path pathToFile = this.jfrRecorder.recordToFile();
                this.executorService.submit(() -> this.uploader.handleFile(pathToFile));
            }
            catch (JfrRecorderException e) {
                logger.warn("An error occurred recording JFR to file, resetting recorder: {}", (Object)e.getMessage());
                this.resetJfrRecorder();
            }
        }
        logger.info("Stopping JfrController. Shutdown detected.");
        this.executorService.shutdown();
    }

    private void resetJfrRecorder() throws JfrRecorderException {
        this.jfrRecorder = this.recorderFactory.getRecorder();
    }
}

