/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic;

import com.newrelic.BackoffPolicy;
import com.newrelic.ChannelClosingException;
import com.newrelic.HeadersInterceptor;
import com.newrelic.InfiniteTracingConfig;
import com.newrelic.Observer;
import com.newrelic.ResponseObserver;
import com.newrelic.SpanBatchObserver;
import com.newrelic.SpanObserver;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.io.grpc.ManagedChannel;
import com.newrelic.agent.deps.io.grpc.okhttp.OkHttpChannelBuilder;
import com.newrelic.agent.deps.io.grpc.stub.ClientCallStreamObserver;
import com.newrelic.api.agent.Logger;
import com.newrelic.api.agent.MetricAggregator;
import com.newrelic.trace.v1.IngestServiceGrpc;
import com.newrelic.trace.v1.V1;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.concurrent.GuardedBy;

class ChannelManager {
    private final Logger logger;
    private final InfiniteTracingConfig config;
    private final MetricAggregator aggregator;
    private final BackoffPolicy backoffManager;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private boolean isShutdownForever;
    @GuardedBy(value="lock")
    private CountDownLatch backoffLatch;
    @GuardedBy(value="lock")
    private ManagedChannel managedChannel;
    @GuardedBy(value="lock")
    private boolean recreateSpanObserver = true;
    @GuardedBy(value="lock")
    private Observer observer;
    @GuardedBy(value="lock")
    private String agentRunToken;
    @GuardedBy(value="lock")
    private Map<String, String> requestMetadata;

    ChannelManager(InfiniteTracingConfig config, MetricAggregator aggregator, String agentRunToken, Map<String, String> requestMetadata) {
        this.logger = config.getLogger();
        this.config = config;
        this.aggregator = aggregator;
        this.agentRunToken = agentRunToken;
        this.requestMetadata = requestMetadata;
        this.backoffManager = new BackoffPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateMetadata(String agentRunToken, Map<String, String> requestMetadata) {
        Object object = this.lock;
        synchronized (object) {
            this.agentRunToken = agentRunToken;
            this.requestMetadata = requestMetadata;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Observer getObserver() {
        CountDownLatch latch;
        Object object = this.lock;
        synchronized (object) {
            latch = this.backoffLatch;
        }
        if (latch != null) {
            try {
                this.logger.log(Level.FINE, "Awaiting backoff.");
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Thread interrupted while awaiting backoff.");
            }
        }
        object = this.lock;
        synchronized (object) {
            if (this.isShutdownForever) {
                throw new RuntimeException("No longer accepting connections to gRPC.");
            }
            if (this.managedChannel == null) {
                this.logger.log(Level.FINE, "Creating gRPC channel.");
                this.managedChannel = this.buildChannel();
            }
            if (this.recreateSpanObserver) {
                if (this.observer != null) {
                    this.logger.log(Level.FINE, "Cancelling and recreating gRPC span observer.");
                    this.observer.cancel("CLOSING_CONNECTION", new ChannelClosingException());
                }
                IngestServiceGrpc.IngestServiceStub ingestServiceStub = this.buildStub(this.managedChannel);
                ResponseObserver responseObserver = this.buildResponseObserver();
                this.observer = this.config.getUseBatching() ? this.buildSpanBatchObserver((ClientCallStreamObserver)ingestServiceStub.recordSpanBatch(responseObserver)) : this.buildSpanObserver((ClientCallStreamObserver)ingestServiceStub.recordSpan(responseObserver));
                this.aggregator.incrementCounter("Supportability/InfiniteTracing/Connect");
                this.recreateSpanObserver = false;
            }
            return this.observer;
        }
    }

    @VisibleForTesting
    Observer buildSpanObserver(ClientCallStreamObserver<V1.Span> observer) {
        return new SpanObserver(observer);
    }

    @VisibleForTesting
    Observer buildSpanBatchObserver(ClientCallStreamObserver<V1.SpanBatch> observer) {
        return new SpanBatchObserver(observer);
    }

    @VisibleForTesting
    IngestServiceGrpc.IngestServiceStub buildStub(ManagedChannel managedChannel) {
        IngestServiceGrpc.IngestServiceStub ingestServiceStub = IngestServiceGrpc.newStub(managedChannel);
        if (this.config.getUseCompression()) {
            ingestServiceStub = (IngestServiceGrpc.IngestServiceStub)ingestServiceStub.withCompression("gzip");
        }
        return ingestServiceStub;
    }

    @VisibleForTesting
    ResponseObserver buildResponseObserver() {
        return new ResponseObserver(this.logger, this, this.aggregator, this.backoffManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recreateSpanObserver() {
        Object object = this.lock;
        synchronized (object) {
            this.recreateSpanObserver = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownChannelAndBackoff(int backoffSeconds) {
        CountDownLatch latch;
        this.logger.log(Level.FINE, "Shutting down gRPC channel and backing off for {0} seconds.", (Object)backoffSeconds);
        Object object = this.lock;
        synchronized (object) {
            if (this.backoffLatch != null) {
                this.logger.log(Level.FINE, "Backoff already in progress.");
                return;
            }
            latch = this.backoffLatch = new CountDownLatch(1);
            if (this.managedChannel != null) {
                this.managedChannel.shutdown();
                this.managedChannel = null;
            }
            this.recreateSpanObserver();
        }
        try {
            TimeUnit.SECONDS.sleep(backoffSeconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread interrupted while backing off.");
        }
        object = this.lock;
        synchronized (object) {
            latch.countDown();
            this.backoffLatch = null;
        }
        this.logger.log(Level.FINE, "Backoff complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownChannelForever() {
        Object object = this.lock;
        synchronized (object) {
            this.logger.log(Level.FINE, "Shutting down gRPC channel forever.");
            this.shutdownChannelAndBackoff(0);
            this.isShutdownForever = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    ManagedChannel buildChannel() {
        HashMap<String, String> headers;
        Object object = this.lock;
        synchronized (object) {
            headers = this.requestMetadata != null ? new HashMap<String, String>(this.requestMetadata) : new HashMap();
            headers.put("agent_run_token", this.agentRunToken);
        }
        headers.put("license_key", this.config.getLicenseKey());
        if (this.config.getFlakyPercentage() != null) {
            this.logger.log(Level.WARNING, "Infinite tracing is configured with a flaky percentage! There will be errors!");
            headers.put("flaky", this.config.getFlakyPercentage().toString());
            if (this.config.getFlakyCode() != null) {
                headers.put("flaky_code", this.config.getFlakyCode().toString());
            }
        }
        OkHttpChannelBuilder channelBuilder = (OkHttpChannelBuilder)((OkHttpChannelBuilder)OkHttpChannelBuilder.forAddress(this.config.getHost(), this.config.getPort()).defaultLoadBalancingPolicy("pick_first")).intercept(new HeadersInterceptor(headers));
        if (this.config.getUsePlaintext()) {
            channelBuilder.usePlaintext();
        } else {
            channelBuilder.useTransportSecurity();
        }
        return channelBuilder.build();
    }
}

