/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.AgentConnectionEstablishedListener;
import com.newrelic.agent.ConnectionConfigListener;
import com.newrelic.agent.ConnectionListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.RPMService;
import com.newrelic.agent.RPMServiceManager;
import com.newrelic.agent.application.PriorityApplicationName;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

public class RPMServiceManagerImpl
extends AbstractService
implements RPMServiceManager {
    private final IRPMService defaultRPMService;
    private final Map<String, IRPMService> appNameToRPMService = new ConcurrentHashMap<String, IRPMService>();
    private final AtomicReference<ConnectionConfigListener> connectionConfigListenerRef = new AtomicReference<Object>(null);
    private final ConnectionConfigListener connectionConfigListener;
    private final List<ConnectionListener> connectionListeners = new CopyOnWriteArrayList<ConnectionListener>();
    private final ConnectionListener connectionListener;
    private final List<AgentConnectionEstablishedListener> agentConnectionEstablishedListeners;
    private volatile List<IRPMService> rpmServices;

    public RPMServiceManagerImpl(AgentConnectionEstablishedListener ... agentConnectionEstablishedListeners) {
        super(RPMServiceManager.class.getSimpleName());
        this.agentConnectionEstablishedListeners = new ArrayList<AgentConnectionEstablishedListener>(Arrays.asList(agentConnectionEstablishedListeners));
        this.connectionConfigListener = new ConnectionConfigListener(){

            @Override
            public AgentConfig connected(IRPMService rpmService, Map<String, Object> connectionInfo) {
                ConnectionConfigListener listener = (ConnectionConfigListener)RPMServiceManagerImpl.this.connectionConfigListenerRef.get();
                if (listener != null) {
                    return listener.connected(rpmService, connectionInfo);
                }
                return ServiceFactory.getConfigService().getDefaultAgentConfig();
            }
        };
        this.connectionListener = new ConnectionListener(){

            @Override
            public void connected(IRPMService rpmService, AgentConfig agentConfig) {
                for (ConnectionListener each : RPMServiceManagerImpl.this.connectionListeners) {
                    each.connected(rpmService, agentConfig);
                }
            }

            @Override
            public void disconnected(IRPMService rpmService) {
                for (ConnectionListener each : RPMServiceManagerImpl.this.connectionListeners) {
                    each.disconnected(rpmService);
                }
            }
        };
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        String host = config.getHost();
        String port = Integer.toString(config.getPort());
        this.getLogger().config(MessageFormat.format("Configured to connect to New Relic at {0}:{1}", host, port));
        this.defaultRPMService = this.createRPMService(config.getApplicationNames(), this.connectionConfigListener, this.connectionListener);
        ArrayList<IRPMService> list = new ArrayList<IRPMService>(1);
        list.add(this.defaultRPMService);
        this.rpmServices = Collections.unmodifiableList(list);
    }

    @Override
    protected synchronized void doStart() throws Exception {
        for (IRPMService rpmService : this.rpmServices) {
            rpmService.start();
        }
    }

    @Override
    protected synchronized void doStop() throws Exception {
        for (IRPMService rpmService : this.rpmServices) {
            rpmService.stop();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setConnectionConfigListener(ConnectionConfigListener listener) {
        this.connectionConfigListenerRef.compareAndSet(null, listener);
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    @Override
    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    @Override
    public IRPMService getRPMService() {
        return this.defaultRPMService;
    }

    @Override
    public IRPMService getRPMService(String appName) {
        if (appName == null || this.defaultRPMService.getApplicationName().equals(appName)) {
            return this.defaultRPMService;
        }
        return this.appNameToRPMService.get(appName);
    }

    @Override
    public IRPMService getOrCreateRPMService(PriorityApplicationName appName) {
        IRPMService rpmService = this.getRPMService(appName.getName());
        if (rpmService != null) {
            return rpmService;
        }
        return this.createRPMServiceForAppName(appName.getName(), appName.getNames());
    }

    @Override
    public IRPMService getOrCreateRPMService(String appName) {
        IRPMService rpmService = this.getRPMService(appName);
        if (rpmService != null) {
            return rpmService;
        }
        ArrayList<String> appNames = new ArrayList<String>(1);
        appNames.add(appName);
        return this.createRPMServiceForAppName(appName, appNames);
    }

    private synchronized IRPMService createRPMServiceForAppName(String appName, List<String> appNames) {
        IRPMService rpmService = this.getRPMService(appName);
        if (rpmService == null) {
            rpmService = this.createRPMService(appNames, this.connectionConfigListener, this.connectionListener);
            this.appNameToRPMService.put(appName, rpmService);
            ArrayList<IRPMService> list = new ArrayList<IRPMService>(this.appNameToRPMService.size() + 1);
            list.addAll(this.appNameToRPMService.values());
            list.add(this.defaultRPMService);
            this.rpmServices = Collections.unmodifiableList(list);
            if (this.isStarted()) {
                try {
                    rpmService.start();
                }
                catch (Exception e) {
                    String msg = MessageFormat.format("Error starting New Relic Service for {0}: {1}", rpmService.getApplicationName(), e);
                    this.getLogger().severe(msg);
                }
            }
        }
        return rpmService;
    }

    protected IRPMService createRPMService(List<String> appNames, ConnectionConfigListener connectionConfigListener, ConnectionListener connectionListener) {
        return new RPMService(appNames, connectionConfigListener, connectionListener, null, this.agentConnectionEstablishedListeners);
    }

    @Override
    public List<IRPMService> getRPMServices() {
        return this.rpmServices;
    }
}

