/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.datastore.DatabaseVendor;
import com.newrelic.agent.database.DatabaseStatementParser;
import com.newrelic.agent.database.ParsedDatabaseStatement;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Cache;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Caffeine;
import java.sql.ResultSetMetaData;
import java.util.logging.Level;

public class CachingDatabaseStatementParser
implements DatabaseStatementParser {
    private final DatabaseStatementParser databaseStatementParser;
    private volatile Cache<String, ParsedDatabaseStatement> statements;

    public CachingDatabaseStatementParser(DatabaseStatementParser databaseStatementParser) {
        this.databaseStatementParser = databaseStatementParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<String, ParsedDatabaseStatement> getOrCreateCache() {
        if (null == this.statements) {
            CachingDatabaseStatementParser cachingDatabaseStatementParser = this;
            synchronized (cachingDatabaseStatementParser) {
                if (null == this.statements) {
                    this.statements = Caffeine.newBuilder().maximumSize(1000L).weakKeys().executor(Runnable::run).build();
                }
            }
        }
        return this.statements;
    }

    @Override
    public ParsedDatabaseStatement getParsedDatabaseStatement(DatabaseVendor databaseVendor, String statement, ResultSetMetaData resultSetMetaData) {
        RuntimeException toLog = null;
        try {
            if (statement == null) {
                Agent.LOG.log(Level.FINE, "Returning UNPARSEABLE_STATEMENT due to null statement for {0}", resultSetMetaData);
                return UNPARSEABLE_STATEMENT;
            }
            Cache<String, ParsedDatabaseStatement> cache = this.getOrCreateCache();
            ParsedDatabaseStatement parsedStatement = cache.getIfPresent(statement);
            if (parsedStatement == null) {
                parsedStatement = this.databaseStatementParser.getParsedDatabaseStatement(databaseVendor, statement, resultSetMetaData);
                cache.put(statement, parsedStatement);
            }
            return parsedStatement;
        }
        catch (RuntimeException ex) {
            toLog = ex;
            Agent.LOG.log(Level.FINEST, "In cache.get() or its loader:", toLog);
            Agent.LOG.log(Level.FINE, "Returning UNPARSEABLE_STATEMENT for {0}", resultSetMetaData);
            return UNPARSEABLE_STATEMENT;
        }
    }
}

