/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.io.grpc.stub;

import com.newrelic.agent.deps.com.google.common.base.Preconditions;
import com.newrelic.agent.deps.io.grpc.CallOptions;
import com.newrelic.agent.deps.io.grpc.Channel;
import com.newrelic.agent.deps.io.grpc.ClientCall;
import com.newrelic.agent.deps.io.grpc.ClientInterceptor;
import com.newrelic.agent.deps.io.grpc.ExperimentalApi;
import com.newrelic.agent.deps.io.grpc.ForwardingClientCall;
import com.newrelic.agent.deps.io.grpc.ForwardingClientCallListener;
import com.newrelic.agent.deps.io.grpc.ForwardingServerCall;
import com.newrelic.agent.deps.io.grpc.Metadata;
import com.newrelic.agent.deps.io.grpc.MethodDescriptor;
import com.newrelic.agent.deps.io.grpc.ServerCall;
import com.newrelic.agent.deps.io.grpc.ServerCallHandler;
import com.newrelic.agent.deps.io.grpc.ServerInterceptor;
import com.newrelic.agent.deps.io.grpc.Status;
import java.util.concurrent.atomic.AtomicReference;

public final class MetadataUtils {
    private MetadataUtils() {
    }

    public static ClientInterceptor newAttachHeadersInterceptor(Metadata extraHeaders) {
        return new HeaderAttachingClientInterceptor(extraHeaders);
    }

    public static ClientInterceptor newCaptureMetadataInterceptor(AtomicReference<Metadata> headersCapture, AtomicReference<Metadata> trailersCapture) {
        return new MetadataCapturingClientInterceptor(headersCapture, trailersCapture);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11462")
    public static ServerInterceptor newAttachMetadataServerInterceptor(Metadata extras) {
        return new MetadataAttachingServerInterceptor(extras);
    }

    private static final class MetadataAttachingServerInterceptor
    implements ServerInterceptor {
        private final Metadata extras;

        MetadataAttachingServerInterceptor(Metadata extras) {
            this.extras = extras;
        }

        @Override
        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            return next.startCall(new MetadataAttachingServerCall<ReqT, RespT>(call), headers);
        }

        final class MetadataAttachingServerCall<ReqT, RespT>
        extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
            boolean headersSent;

            MetadataAttachingServerCall(ServerCall<ReqT, RespT> delegate) {
                super(delegate);
            }

            @Override
            public void sendHeaders(Metadata headers) {
                headers.merge(MetadataAttachingServerInterceptor.this.extras);
                this.headersSent = true;
                super.sendHeaders(headers);
            }

            @Override
            public void close(Status status, Metadata trailers) {
                if (!this.headersSent) {
                    trailers.merge(MetadataAttachingServerInterceptor.this.extras);
                }
                super.close(status, trailers);
            }
        }
    }

    private static final class MetadataCapturingClientInterceptor
    implements ClientInterceptor {
        final AtomicReference<Metadata> headersCapture;
        final AtomicReference<Metadata> trailersCapture;

        MetadataCapturingClientInterceptor(AtomicReference<Metadata> headersCapture, AtomicReference<Metadata> trailersCapture) {
            this.headersCapture = Preconditions.checkNotNull(headersCapture, "headersCapture");
            this.trailersCapture = Preconditions.checkNotNull(trailersCapture, "trailersCapture");
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return new MetadataCapturingClientCall<ReqT, RespT>(next.newCall(method, callOptions));
        }

        private final class MetadataCapturingClientCall<ReqT, RespT>
        extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
            MetadataCapturingClientCall(ClientCall<ReqT, RespT> call) {
                super(call);
            }

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                MetadataCapturingClientInterceptor.this.headersCapture.set(null);
                MetadataCapturingClientInterceptor.this.trailersCapture.set(null);
                super.start(new MetadataCapturingClientCallListener(responseListener), headers);
            }

            private final class MetadataCapturingClientCallListener
            extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
                MetadataCapturingClientCallListener(ClientCall.Listener<RespT> responseListener) {
                    super(responseListener);
                }

                @Override
                public void onHeaders(Metadata headers) {
                    MetadataCapturingClientInterceptor.this.headersCapture.set(headers);
                    super.onHeaders(headers);
                }

                @Override
                public void onClose(Status status, Metadata trailers) {
                    MetadataCapturingClientInterceptor.this.trailersCapture.set(trailers);
                    super.onClose(status, trailers);
                }
            }
        }
    }

    private static final class HeaderAttachingClientInterceptor
    implements ClientInterceptor {
        private final Metadata extraHeaders;

        HeaderAttachingClientInterceptor(Metadata extraHeaders) {
            this.extraHeaders = Preconditions.checkNotNull(extraHeaders, "extraHeaders");
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return new HeaderAttachingClientCall<ReqT, RespT>(next.newCall(method, callOptions));
        }

        private final class HeaderAttachingClientCall<ReqT, RespT>
        extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
            HeaderAttachingClientCall(ClientCall<ReqT, RespT> call) {
                super(call);
            }

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.merge(HeaderAttachingClientInterceptor.this.extraHeaders);
                super.start(responseListener, headers);
            }
        }
    }
}

