/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.frameworks.spring;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import java.lang.reflect.Method;

@PointCut
public class HandlerMethodInvoker3PointCut
extends TracerFactoryPointCut {
    public HandlerMethodInvoker3PointCut(PointCutClassTransformer classTransformer) {
        super(new PointCutConfiguration("spring_handler_method_invoker"), (ClassMatcher)new ExactClassMatcher("org/springframework/web/bind/annotation/support/HandlerMethodInvoker"), HandlerMethodInvoker3PointCut.createExactMethodMatcher("invokeHandlerMethod", "(Ljava/lang/reflect/Method;Ljava/lang/Object;Lorg/springframework/web/context/request/NativeWebRequest;Lorg/springframework/ui/ExtendedModelMap;)Ljava/lang/Object;"));
    }

    @Override
    public Tracer doGetTracer(Transaction transaction, ClassMethodSignature sig, Object invoker, Object[] args2) {
        StringBuilder tracerName = new StringBuilder("Spring/Java");
        String methodName = ((Method)args2[0]).getName();
        Class<?> controller = args2[1].getClass();
        tracerName.append(this.getControllerName(methodName, controller));
        return new DefaultTracer(transaction, sig, invoker, new SimpleMetricNameFormat(tracerName.toString()));
    }

    private String getControllerName(String methodName, Class<?> controller) {
        String controllerName = controller.getName();
        int indexOf = controllerName.indexOf("$$EnhancerBy");
        if (indexOf > 0) {
            controllerName = controllerName.substring(0, indexOf);
        }
        return '/' + controllerName + '/' + methodName;
    }
}

